/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;

public class StringUtils {
    private static final String STRING_D = "=";
    private static final String STRING_A = "&";
    private static final String STRING_Y = "Y";
    private static final String STRING_N = "N";
    private static final String COMMON_DATE = "yyyyMMddHHmmss";
    SimpleDateFormat _sec_sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String COMMON_DATE1 = "yyyyMMddHHmmssSSS";
    SimpleDateFormat _mills_sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public static String bytesToHexString(byte[] src) {
        String text = JSON.toJSONString((Object)"");
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || "".equals(hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(StringUtils.charToByte(hexChars[pos]) << 4 | StringUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte numToByte(int num) {
        return (byte)num;
    }

    public static byte[] compleBytes(byte[] srcBytes, int baseDigt, byte compleBits) {
        byte[] bytes = null;
        if (srcBytes.length % baseDigt != 0) {
            bytes = new byte[(srcBytes.length / baseDigt + 1) * baseDigt];
            System.arraycopy(srcBytes, 0, bytes, 0, srcBytes.length);
            int i = 0;
            while (i + srcBytes.length < bytes.length) {
                bytes[srcBytes.length + i] = compleBits;
                ++i;
            }
        } else {
            bytes = srcBytes;
        }
        return bytes;
    }

    public static byte[] removeCompleBytes(byte[] bytes, byte compleBits) {
        int pos = bytes.length;
        while (bytes[--pos] == compleBits) {
        }
        byte[] newBytes = new byte[++pos];
        System.arraycopy(bytes, 0, newBytes, 0, pos);
        return newBytes;
    }

    public static int toInt(byte[] bRefArr) {
        int iOutcome = 0;
        for (int i = 0; i < bRefArr.length; ++i) {
            byte bLoop = bRefArr[i];
            iOutcome += (bLoop & 0xFF) << 8 * i;
        }
        return iOutcome;
    }

    public static long toLong(byte[] bRefArr) {
        long iOutcome = 0L;
        for (int i = 0; i < bRefArr.length; ++i) {
            byte bLoop = bRefArr[i];
            iOutcome += (long)((bLoop & 0xFF) << 8 * i);
        }
        return iOutcome;
    }

    public String getDate(int lt, int ht, Integer mills) {
        long timestamp = (long)lt + (long)ht * 256L * 256L * 256L * 256L;
        if (mills == null) {
            return this._sec_sdf.format(new Date(timestamp * 1000L));
        }
        return this._mills_sdf.format(new Date(timestamp * 1000L + (long)mills.intValue()));
    }

    public static int getInt(byte[] bytes, int pos, int len) {
        byte[] bArr = new byte[len];
        System.arraycopy(bytes, pos, bArr, 0, len);
        return StringUtils.toInt(bArr);
    }

    public static long resolvNumBytes(byte[] bytes) {
        long value = 0L;
        value += Long.valueOf(StringUtils.getInt(bytes, 51, 2)).longValue();
        value += Long.valueOf(StringUtils.getInt(bytes, 53, 2)) * 256L * 256L;
        value += Long.valueOf(StringUtils.getInt(bytes, 55, 2)) * 256L * 256L * 256L * 256L;
        return value += Long.valueOf(StringUtils.getInt(bytes, 57, 2)) * 256L * 256L * 256L * 256L * 256L * 256L;
    }

    public static int getReversedInt(byte[] bytes, int pos, int len) {
        byte[] bArr = new byte[len];
        System.arraycopy(bytes, pos, bArr, 0, len);
        return StringUtils.toInt(StringUtils.bytesReverseOrder(bArr));
    }

    public static byte[] bytesReverseOrder(byte[] b) {
        int length = b.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[length - i - 1] = b[i];
        }
        return result;
    }

    public static String camelCaseName(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(Character.toLowerCase(ch));
            }
        }
        return result.toString();
    }

    public static String underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        if (camelCaseName != null && camelCaseName.length() > 0) {
            result.append(camelCaseName.substring(0, 1).toUpperCase());
            for (int i = 1; i < camelCaseName.length(); ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(ch);
                    continue;
                }
                result.append(Character.toUpperCase(ch));
            }
        }
        return result.toString();
    }

    public static String getUrlParam(String json, String encode) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            stringBuffer.append(key);
            stringBuffer.append(STRING_D);
            if (STRING_Y.equals(encode)) {
                stringBuffer.append(StringUtils.getURLEncoderString(value));
            } else {
                stringBuffer.append(value);
            }
            stringBuffer.append(STRING_A);
        }
        return stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1);
    }

    public static String getUrlParam(String json) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = jsonObject.getString(key);
            stringBuffer.append(key);
            stringBuffer.append(STRING_D);
            stringBuffer.append(StringUtils.getURLEncoderString(value));
            stringBuffer.append(STRING_A);
        }
        return stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1);
    }

    public static String getURLEncoderString(String str) {
        String result = "";
        if (null == str) {
            return "";
        }
        try {
            result = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String URLDecoderString(String str) {
        String result = "";
        if (null == str) {
            return "";
        }
        try {
            result = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String dealPath(String urlParams, String eprpath) {
        HashMap valuesMap = new HashMap();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)urlParams)) {
            Arrays.stream(urlParams.split(STRING_A)).forEach(k -> {
                String[] split = k.split(STRING_D);
                valuesMap.put(split[0], split[1]);
            });
        }
        for (Map.Entry entry : valuesMap.entrySet()) {
            String k2 = (String)entry.getKey();
            String v = (String)entry.getValue();
            eprpath = eprpath.replace("{".concat(k2).concat("}"), v);
        }
        return eprpath;
    }

    public static void main(String[] args) {
        String s = StringUtils.dealPath("a=err&b=344", "c=${a}&d=${b}");
        System.out.println(s);
    }
}

