/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UrlUtil {
    private static final Pattern PATTERN = Pattern.compile("(http:\\/\\/|https:\\/\\/)?(?:(?:[0,1]?\\d?\\d|2[0-4]\\d|25[0-5])\\.){3}(?:[0,1]?\\d?\\d|2[0-4]\\d|25[0-5]):\\d{0,5}");
    private static final String API = "api";
    private static final String JSON = "json";
    private static final String XML = "xml";
    private static final String OSNAPI = "OSN/api";
    private static final String WS = "ws";
    private static final String FORMDATA = "formData";
    private static final String DEFAULT_VERSION = "1";

    public static boolean checkUrl(String pathInfo) {
        if (StringUtils.isBlank((CharSequence)pathInfo)) {
            return false;
        }
        if (UrlUtil.checkIP(pathInfo)) {
            String[] hostPort;
            if (pathInfo.startsWith("http")) {
                String[] http = StringUtils.split((String)pathInfo, (String)"\\/\\/");
                hostPort = StringUtils.split((String)http[1], (String)":");
            } else {
                hostPort = StringUtils.split((String)pathInfo, (String)":");
            }
            return UrlUtil.isHostConnector(hostPort[0], Integer.parseInt(hostPort[1]));
        }
        return UrlUtil.isHostReachable(pathInfo);
    }

    private static boolean checkIP(String pathInfo) {
        return PATTERN.matcher(pathInfo).matches();
    }

    private static boolean isHostConnector(String host, int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean isHostReachable(String host) {
        try {
            return InetAddress.getByName(host).isReachable(1000);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getAbilityInfo(String pathInfo, MsgContext msgContext) throws Exception {
        if (pathInfo.startsWith("/mock/")) {
            pathInfo = pathInfo.substring(6);
            msgContext.setRequestMode("mock");
        } else {
            pathInfo = pathInfo.substring(1);
            msgContext.setRequestMode("nomal");
        }
        if (pathInfo.startsWith(JSON)) {
            msgContext.setInputProtocal(JSON);
            pathInfo = pathInfo.substring(JSON.length() + 1);
        } else if (pathInfo.startsWith(XML)) {
            msgContext.setInputProtocal(XML);
            pathInfo = pathInfo.substring(XML.length() + 1);
        } else if (pathInfo.startsWith(OSNAPI)) {
            msgContext.setInputProtocal(JSON);
            pathInfo = pathInfo.substring(OSNAPI.length() + 1);
        } else if (pathInfo.startsWith(WS)) {
            msgContext.setInputProtocal(WS);
            pathInfo = pathInfo.substring(WS.length() + 1);
        } else if (pathInfo.startsWith(API)) {
            msgContext.setInputProtocal(JSON);
            pathInfo = pathInfo.substring(API.length() + 1);
        } else if (pathInfo.startsWith(FORMDATA)) {
            msgContext.setInputProtocal(FORMDATA);
            pathInfo = pathInfo.substring(FORMDATA.length() + 1);
        }
        int versionInfoIndex = pathInfo.lastIndexOf("/");
        String apiVersion = pathInfo.substring(versionInfoIndex + 1);
        if (apiVersion.startsWith("V") || apiVersion.startsWith("v")) {
            String busiServiceName = pathInfo.substring(0, versionInfoIndex).replaceAll("/", "_");
            return String.join((CharSequence)"_", busiServiceName, apiVersion.substring(1));
        }
        String busiServiceName = pathInfo.replaceAll("/", "_");
        return String.join((CharSequence)"_", busiServiceName, DEFAULT_VERSION);
    }

    public static void main(String[] args) throws Exception {
        String abilityInfo = UrlUtil.getAbilityInfo("/api/json_hello_service/v1", new MsgContext());
        System.out.println(abilityInfo);
    }
}

