/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.enums;

import java.util.Arrays;

public enum LoadBalanceEnum {
    RANDOM(0, "random"),
    LEAST_CONCURRENT(1, "leastConcurrent"),
    CAPABLE(2, "capable"),
    ROUND_ROBIN(3, "roundRobin"),
    HASH(4, "hash");

    private final int code;
    private final String name;

    public static String getLoadBalanceByCode(int code) {
        return Arrays.stream(LoadBalanceEnum.values()).filter(e -> e.code == code).findFirst().orElse(RANDOM).getName();
    }

    private LoadBalanceEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

