/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.model.bo.system;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JaxbUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class TlogRspHeader
implements Serializable {
    private static final long serialVersionUID = 490195903112533796L;
    private byte[] rspData = null;
    private String rspDataString = null;
    private Map headers = null;
    private Object rspObj = null;

    public Object getRspObj(MsgContext msg) {
        if (this.rspObj != null) {
            return this.rspObj;
        }
        return this.getRspObject(msg);
    }

    private Object getRspObject(MsgContext msg) {
        String content = new String(msg.getTlogRspHeader().getRspData());
        String className = msg.getEsbAbility().getOutputClassName();
        Class<?> c = null;
        try {
            Object object = null;
            switch (msg.getEsbAbility().getOutputProtocal()) {
                case "json": {
                    c = msg.getEsbAbility().getClzLoader().loadClass(className);
                    object = GsonUtil.fromJson(content, c);
                    break;
                }
                case "xml": {
                    c = msg.getEsbAbility().getClzLoader().loadClass(className);
                    object = JaxbUtil.xmlToBean(content, msg.getEsbAbility().getContextRsp());
                    break;
                }
                case "dubbo": {
                    c = msg.getEsbAbility().getClzLoader().loadClass(className);
                    object = GsonUtil.fromJson(content, c);
                    break;
                }
                case "hsf": {
                    c = msg.getEsbAbility().getClzLoader().loadClass(className);
                    object = GsonUtil.fromJson(content, c);
                    break;
                }
            }
            msg.getTlogRspHeader().setRspObj(object);
            return object;
        }
        catch (Exception e) {
            throw new AbilityException(CodeMsg.ESB_ERROR.fillArgs(":" + e.getMessage()));
        }
    }

    public byte[] getRspData() {
        return this.rspData;
    }

    public String getRspDataString() {
        return this.rspDataString;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Object getRspObj() {
        return this.rspObj;
    }

    public void setRspData(byte[] rspData) {
        this.rspData = rspData;
    }

    public void setRspDataString(String rspDataString) {
        this.rspDataString = rspDataString;
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public void setRspObj(Object rspObj) {
        this.rspObj = rspObj;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TlogRspHeader)) {
            return false;
        }
        TlogRspHeader other = (TlogRspHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getRspData(), other.getRspData())) {
            return false;
        }
        String this$rspDataString = this.getRspDataString();
        String other$rspDataString = other.getRspDataString();
        if (this$rspDataString == null ? other$rspDataString != null : !this$rspDataString.equals(other$rspDataString)) {
            return false;
        }
        Map this$headers = this.getHeaders();
        Map other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Object this$rspObj = this.getRspObj();
        Object other$rspObj = other.getRspObj();
        return !(this$rspObj == null ? other$rspObj != null : !this$rspObj.equals(other$rspObj));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TlogRspHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getRspData());
        String $rspDataString = this.getRspDataString();
        result = result * 59 + ($rspDataString == null ? 43 : $rspDataString.hashCode());
        Map $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Object $rspObj = this.getRspObj();
        result = result * 59 + ($rspObj == null ? 43 : $rspObj.hashCode());
        return result;
    }

    public String toString() {
        return "TlogRspHeader(rspData=" + Arrays.toString(this.getRspData()) + ", rspDataString=" + this.getRspDataString() + ", headers=" + this.getHeaders() + ", rspObj=" + this.getRspObj() + ")";
    }
}

