/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.ohaotian.abilitycommon.enums.ParamTypeEnum;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class StrUtil {
    public static String unlineToPascal(String str) {
        if (str != null) {
            if (str.indexOf("_") == -1) {
                return StrUtil.fristToUpCase(str);
            }
            StringBuilder result = new StringBuilder();
            String[] temp = str.split("_");
            for (int i = 0; i < temp.length; ++i) {
                if ("".equals(temp[i]) || temp[i].isEmpty()) continue;
                result.append(StrUtil.fristToUpCaseLaterToLoCase(temp[i]));
            }
            return result.toString();
        }
        return str;
    }

    public static String unlineToCamel(String str) {
        if (str != null) {
            if (str.indexOf("_") == -1) {
                return StrUtil.fristToLoCase(str);
            }
            StringBuilder result = new StringBuilder();
            String[] temp = str.split("_");
            boolean falg = false;
            for (int i = 0; i < temp.length; ++i) {
                if ("".equals(temp[i]) || temp[i].isEmpty()) continue;
                if (!falg) {
                    falg = true;
                    result.append(temp[i].toLowerCase());
                    continue;
                }
                result.append(StrUtil.fristToUpCaseLaterToLoCase(temp[i]));
            }
            return result.toString();
        }
        return str;
    }

    public static String CamelToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        if (!para.contains("_")) {
            for (int i = 0; i < para.length(); ++i) {
                if (!Character.isUpperCase(para.charAt(i))) continue;
                sb.insert(i + temp, "_");
                ++temp;
            }
        }
        return sb.toString().toLowerCase();
    }

    public static String fristToUpCaseLaterToLoCase(String str) {
        if (str != null && str.length() > 0) {
            str = str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
        }
        return str;
    }

    public static String fristToLoCaseLaterToUpCase(String str) {
        if (str != null && str.length() > 0) {
            str = str.substring(0, 1).toLowerCase() + str.substring(1).toUpperCase();
        }
        return str;
    }

    public static String fristToUpCase(String str) {
        if (str != null && str.length() > 0) {
            str = str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }

    public static String fristToLoCase(String str) {
        if (str != null && str.length() > 0) {
            str = str.substring(0, 1).toLowerCase() + str.substring(1);
        }
        return str;
    }

    public static boolean indexOf(String regex, String ... str) {
        if (str == null) {
            return false;
        }
        for (String temp : str) {
            if (temp.indexOf(regex) != -1) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String magre(String separator, String ... str) {
        StringBuffer result = null;
        for (String temp : str) {
            if (result == null) {
                result = new StringBuffer(temp);
            }
            result.append("," + temp);
        }
        return result.toString();
    }

    public static String replace(String str, List<String[]> rep) {
        for (String[] item : rep) {
            if (item[1] == null) {
                item[1] = "";
            }
            str = str.replace(item[0], item[1]);
        }
        return str;
    }

    public static String[] asStrArray(String ... str) {
        return str;
    }

    public static String getRfc822DateFormat(Date date) {
        SimpleDateFormat rfc822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        rfc822DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return rfc822DateFormat.format(date);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String ... str) {
        if (str == null || str.length == 0) {
            return true;
        }
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != null && !"".equals(str[i].trim())) continue;
            return true;
        }
        return false;
    }

    public static String millisToDateTime(long time, String pattern) {
        long day = time / 86400000L;
        long hour = time % 86400000L / 3600000L;
        long minute = time % 86400000L % 3600000L / 60000L;
        long second = time % 86400000L % 3600000L % 60000L / 1000L;
        pattern = pattern.indexOf("$y") == -1 ? pattern.replace("$d", Long.toString(day)) : pattern.replace("$y", Long.toString(day / 365L)).replace("$d", Long.toString(day % 365L));
        return pattern.replace("$h", Long.toString(hour)).replace("$m", Long.toString(minute)).replace("$s", Long.toString(second));
    }

    public static boolean isType(String str, ParamTypeEnum type) {
        try {
            if (type == ParamTypeEnum.Boolean) {
                return "true".equals(str) || "false".equals(str);
            }
            if (type == ParamTypeEnum.Integer) {
                Integer.parseInt(str);
            } else if (type == ParamTypeEnum.Long) {
                Long.parseLong(str);
            } else if (type == ParamTypeEnum.Float) {
                Float.parseFloat(str);
            } else if (type == ParamTypeEnum.Double) {
                Double.parseDouble(str);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean numberGtNumber(ParamTypeEnum type, String str, Number num) {
        try {
            if (type == ParamTypeEnum.Integer) {
                int i = Integer.parseInt(str);
                return i > num.intValue();
            }
            if (type == ParamTypeEnum.Long) {
                long l = Long.parseLong(str);
                return l > num.longValue();
            }
            if (type == ParamTypeEnum.Float) {
                float f = Float.parseFloat(str);
                return f > num.floatValue();
            }
            if (type == ParamTypeEnum.Double) {
                double d = Double.parseDouble(str);
                return d > num.doubleValue();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean numberLtNumber(ParamTypeEnum type, String str, Number num) {
        try {
            if (type == ParamTypeEnum.Integer) {
                int i = Integer.parseInt(str);
                return i < num.intValue();
            }
            if (type == ParamTypeEnum.Long) {
                long l = Long.parseLong(str);
                return l < num.longValue();
            }
            if (type == ParamTypeEnum.Float) {
                float f = Float.parseFloat(str);
                return f < num.floatValue();
            }
            if (type == ParamTypeEnum.Double) {
                double d = Double.parseDouble(str);
                return d < num.doubleValue();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getint(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static int getintTry(String str) {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Integer getInteger(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return null;
        }
        return Integer.parseInt(str);
    }

    public static long getlong(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    public static long getlongTry(String str) {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static Long getLong(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    public static float getfloat(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0.0f;
        }
        return Float.parseFloat(str);
    }

    public static Float getFloat(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return null;
        }
        return new Float(str);
    }

    public static double getdouble(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static Double getDouble(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return null;
        }
        return new Double(str);
    }

    public static Date getDate(String str) throws NumberFormatException {
        if (StrUtil.isNullOrEmpty(str)) {
            return null;
        }
        try {
            return Date.from(Instant.parse(str));
        }
        catch (Exception e) {
            return new Date(Long.parseLong(str));
        }
    }

    public static Instant getInstant(String str) throws NumberFormatException, DateTimeParseException, RuntimeException {
        if (StrUtil.isNullOrEmpty(str)) {
            return null;
        }
        try {
            return Instant.parse(str);
        }
        catch (Exception e) {
            return Instant.ofEpochMilli(Long.parseLong(str));
        }
    }

    public static List<Long> strSplit(String str) {
        String[] strS;
        ArrayList<Long> list = new ArrayList<Long>();
        for (String ss : strS = str.split(",")) {
            list.add(Long.parseLong(ss));
        }
        return list;
    }
}

