/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ParseUtil {
    private static final String ESB_ENTITY = "\\{esb:entity.*\\}";
    private static final String ESB_LIS = "\\{esb:list.*\\}";
    private static final String ESB_LIS_END = "\\{/esb:list\\}";
    private static final String PRORETY_NAME = "(\\w*)\\s*=";
    private static final String PROPERTY_VALUE = "=\\s*((.*?)[(?\\s)|}]|(.*)|)";
    private static final String IS_JSON = "isjson";
    private static final String PATH = "path";

    public static String doParse(Object rootObject, String template) throws NoSuchFieldException, IllegalAccessException {
        Matcher listBeforeMatcher = Pattern.compile(ESB_LIS).matcher(template);
        while (listBeforeMatcher.find()) {
            int beforeStartIndex = listBeforeMatcher.start();
            int beforeEndIndex = listBeforeMatcher.end();
            String labelContent = listBeforeMatcher.group();
            Map<String, String> property = ParseUtil.getProperty(labelContent);
            String path = property.get(PATH);
            List newObjectList = (List)ReflectBeanValueUtil.getValue(rootObject, path);
            String content = ParseUtil.parseList(rootObject, newObjectList, template.substring(beforeEndIndex + 1), path);
            template = template.substring(0, beforeStartIndex) + content;
            listBeforeMatcher = Pattern.compile(ESB_LIS).matcher(template);
        }
        String content = template;
        Matcher entityMatcher = Pattern.compile(ESB_ENTITY).matcher(template);
        while (entityMatcher.find()) {
            String path = ParseUtil.getProperty(entityMatcher.group()).get(PATH);
            Object value = ReflectBeanValueUtil.getValue(rootObject, path);
            content = content.replaceFirst(ESB_ENTITY, value.toString());
        }
        return content;
    }

    private static String parseList(Object rootObject, List<Object> currentObjects, String template, String currentPath) throws NoSuchFieldException, IllegalAccessException {
        if (currentPath == null) {
            currentPath = "";
        }
        String content = null;
        int afterStartIndex_content = -1;
        int afterEndIndex_content = -1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < currentObjects.size(); ++i) {
            String path;
            Object object = currentObjects.get(i);
            content = template;
            int beforeStartIndex = -1;
            int beforeEndIndex = -1;
            Matcher listBeforeMatcher = Pattern.compile(ESB_LIS).matcher(content);
            Matcher listAfterMatcher_content = Pattern.compile(ESB_LIS_END).matcher(content);
            if (listAfterMatcher_content.find()) {
                afterStartIndex_content = listAfterMatcher_content.start();
                afterEndIndex_content = listAfterMatcher_content.end();
            }
            while (listBeforeMatcher.find()) {
                beforeStartIndex = listBeforeMatcher.start();
                beforeEndIndex = listBeforeMatcher.end();
                if (afterStartIndex_content <= beforeEndIndex) break;
                String labelContent = listBeforeMatcher.group();
                Map<String, String> property = ParseUtil.getProperty(labelContent);
                path = property.get(PATH);
                String realPath = path.substring(currentPath.length());
                List newObjectList = (List)ReflectBeanValueUtil.getValue(object, realPath);
                String result = ParseUtil.parseList(rootObject, newObjectList, content.substring(beforeEndIndex + 1), path);
                content = content.substring(0, beforeStartIndex) + result;
                listBeforeMatcher = Pattern.compile(ESB_LIS).matcher(content);
                listAfterMatcher_content = Pattern.compile(ESB_LIS_END).matcher(content);
                if (!listAfterMatcher_content.find()) continue;
                afterStartIndex_content = listAfterMatcher_content.start();
                afterEndIndex_content = listAfterMatcher_content.end();
            }
            String currentContent = afterStartIndex_content > 0 ? content.substring(0, afterStartIndex_content) : new String(content);
            Matcher entityMatcher = Pattern.compile(ESB_ENTITY).matcher(currentContent);
            while (entityMatcher.find()) {
                Object value;
                path = ParseUtil.getProperty(entityMatcher.group()).get(PATH);
                if (path.startsWith(currentPath)) {
                    path = path.substring(currentPath.length());
                    value = ReflectBeanValueUtil.getValue(object, path);
                } else {
                    value = ReflectBeanValueUtil.getValue(rootObject, path);
                }
                currentContent = currentContent.replaceFirst(ESB_ENTITY, value.toString());
            }
            sb.append(currentContent);
            if (i >= currentObjects.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString() + content.substring(afterEndIndex_content + 1);
    }

    private static Map<String, String> getProperty(String labelContent) {
        labelContent = labelContent.substring(0, labelContent.length() - 1);
        HashMap<String, String> PropertyMap = new HashMap<String, String>();
        ArrayList<String> propertyName = new ArrayList<String>();
        Pattern propertyNamePattern = Pattern.compile(PRORETY_NAME);
        Matcher propertyNameMatcher = propertyNamePattern.matcher(labelContent);
        while (propertyNameMatcher.find()) {
            propertyName.add(propertyNameMatcher.group(1));
        }
        ArrayList<String> propertyValue = new ArrayList<String>();
        Pattern propertyValuePattern = Pattern.compile(PROPERTY_VALUE);
        Matcher propertyValueMatcher = propertyValuePattern.matcher(labelContent);
        while (propertyValueMatcher.find()) {
            String value = propertyValueMatcher.group(1);
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            propertyValue.add(value);
        }
        for (int i = 0; i < propertyName.size(); ++i) {
            PropertyMap.put(((String)propertyName.get(i)).trim(), ((String)propertyValue.get(i)).trim());
        }
        return PropertyMap;
    }
}

