/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.atp.base.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.lang.ObjectId;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    private Snowflake snowflake;

    @PostConstruct
    void init() {
        long workerId = 0L;
        long dataCenterId = 0L;
        try {
            workerId = IdGenerator.getWorkId();
            dataCenterId = IdGenerator.getDataCenterId();
            this.snowflake = IdUtil.getSnowflake((long)workerId, (long)dataCenterId);
            log.info("\u5f53\u524d\u673a\u5668 workerId: {} , dataCenterId: {}", (Object)workerId, (Object)dataCenterId);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u673a\u5668 ID \u5931\u8d25", (Throwable)e);
            workerId = NetUtil.getLocalhost().hashCode();
            log.info("\u5f53\u524d\u673a\u5668 workerId: {}", (Object)workerId);
        }
    }

    private static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostAddress);
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return sums % 32;
        }
        catch (UnknownHostException e) {
            return RandomUtils.nextLong((long)0L, (long)31L);
        }
    }

    private static Long getDataCenterId() {
        try {
            String hostName = SystemUtils.getHostName();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostName);
            int sums = 0;
            for (int i : ints) {
                sums += i;
            }
            return sums % 32;
        }
        catch (Exception e) {
            return RandomUtils.nextLong((long)0L, (long)31L);
        }
    }

    public synchronized String batchId(int tenantId, int module) {
        String prefix = DateTime.now().toString("yyyyMMddHHmmssSSS");
        return prefix + tenantId + module + RandomUtil.randomNumbers((int)3);
    }

    @Deprecated
    public synchronized String getBatchId(int tenantId, int module) {
        return this.batchId(tenantId, module);
    }

    public String simpleUUID() {
        return IdUtil.simpleUUID();
    }

    public String randomUUID() {
        return IdUtil.randomUUID();
    }

    public synchronized long snowflakeId() {
        try {
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.snowflake.nextId();
    }

    public synchronized long snowflakeId(long workerId, long dataCenterId) {
        Snowflake snowflake = IdUtil.getSnowflake((long)workerId, (long)dataCenterId);
        return snowflake.nextId();
    }

    public String objectId() {
        return ObjectId.next();
    }
}

