/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.asymmetric.SM2;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="Encryption")
public class EncryptionMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        String arg1Str = null;
        String arg2Str = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (arg1Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                arg1Str = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (arg2Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                arg2Str = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                switch (method) {
                    case Encryption_Base64_getEncoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), Base64.getEncoder().encodeToString(arg1Str.getBytes(StandardCharsets.UTF_8)));
                    }
                    case Encryption_Base64_getDecoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), new String(Base64.getDecoder().decode(arg1Str)));
                    }
                    case Encryption_Base64_getUrlEncoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), Base64.getUrlEncoder().encodeToString(arg1Str.getBytes(StandardCharsets.UTF_8)));
                    }
                    case Encryption_Base64_getUrlDecoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), new String(Base64.getUrlDecoder().decode(arg1Str)));
                    }
                    case Encryption_URLEncoder_encode: {
                        arg2Str = arg2Str == null ? "UTF-8" : arg2Str;
                        try {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), URLEncoder.encode(arg1Str, arg2Str));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InterfaceException(e.getMessage(), e);
                        }
                    }
                    case Encryption_URLDecoder_decode: {
                        arg2Str = arg2Str == null ? "UTF-8" : arg2Str;
                        try {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), URLDecoder.decode(arg1Str, arg2Str));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InterfaceException(e.getMessage(), e);
                        }
                    }
                    case Encryption_SM2_encode: {
                        return this.doSM2EncodeMethod(faceMsgContext, arg1Str, arg2Str, tagAttributes.getReturnPath());
                    }
                }
                throw new InterfaceException("\n\tBase64\u65b9\u6cd5\u4e2d\u4e0d\u5b58\u5728\u8be5\u65b9\u6cd5: " + method.getCode());
            }
            throw new InterfaceException("\n\tBase64." + method.getCode() + "\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570:" + next.getName());
        }
        throw new InterfaceException("\n\tBase64\u65b9\u6cd5\u89e3\u6790\u9519\u8bef: " + method.getCode() + " \u65b9\u6cd5\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!");
    }

    public <M> boolean doSM2EncodeMethod(FaceMsgContext<M> faceMsgContext, String privateKey, String after, String returnPath) {
        SM2 sm2 = new SM2(BCUtil.toSm2Params((String)privateKey), null);
        byte[] sign = sm2.sign(after.getBytes(StandardCharsets.UTF_8), null);
        String result = HexUtil.encodeHexStr((byte[])sign);
        return this.upath.put(faceMsgContext, returnPath, result);
    }
}

