/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.baseEnum.BaseAttributes;
import com.ohaotian.plugin.model.baseEnum.BaseOperators;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GeneralUtils {
    public static String nullType = "null";

    public static Object getObjectByType(String type, Object value) throws InterfaceException {
        if (value == null || nullType.equals(type)) {
            return null;
        }
        String valueString = value.toString();
        try {
            switch (type) {
                case "Object": {
                    return value;
                }
                case "String": {
                    if (value.getClass() == byte[].class) {
                        return new String((byte[])value);
                    }
                    return valueString;
                }
                case "JSONObject": {
                    if (value instanceof Map) {
                        if (value instanceof JSONObject) {
                            return value;
                        }
                        return new JSONObject((Map)((HashMap)value));
                    }
                    return JSONObject.parseObject((String)valueString);
                }
                case "JSONArray": {
                    if (value instanceof List) {
                        if (value instanceof JSONArray) {
                            return value;
                        }
                        return new JSONArray((List)((ArrayList)value));
                    }
                    return JSONArray.parseArray((String)valueString);
                }
                case "int": 
                case "Integer": {
                    return new BigDecimal(valueString).intValue();
                }
                case "Double": {
                    return new Double(valueString);
                }
                case "Long": {
                    return new BigDecimal(valueString).longValue();
                }
                case "BigDecimal": {
                    return new BigDecimal(valueString);
                }
                case "Boolean": {
                    return "true".equals(valueString);
                }
                case "Byte[]": {
                    return valueString.getBytes(StandardCharsets.UTF_8);
                }
            }
            throw new InterfaceException("\n\t\u6ca1\u6709 " + type + " \u7c7b\u578b\u7684\u8f6c\u6362\u65b9\u5f0f!");
        }
        catch (Exception e) {
            throw new InterfaceException("\n\t\u7c7b\u578b\u8f6c\u6362\u9519\u8bef: " + value.getClass().getName() + " \u7c7b\u578b \u8f6c\u6362\u4e3a " + type + " \u7c7b\u578b\u5931\u8d25!!  \u60f3\u8981\u8f6c\u6362\u7684\u6570\u636e\u4e3a: " + valueString, e);
        }
    }

    public static boolean doStringJudge(String inputValue, String operator, String judgeObject) throws InterfaceException {
        switch (operator) {
            case "equals": {
                return inputValue.equals(judgeObject);
            }
            case "notEquals": {
                return !inputValue.equals(judgeObject);
            }
            case "isEmpty": {
                return inputValue.isEmpty();
            }
            case "contains": {
                return inputValue.contains(judgeObject);
            }
            case "startsWith": {
                return inputValue.startsWith(judgeObject);
            }
            case "endsWith": {
                return inputValue.endsWith(judgeObject);
            }
        }
        throw new InterfaceException("\n\tString\u7c7b\u578b\u6ca1\u6709 " + operator + " \u5173\u7cfb\u8fd0\u7b97\u7b26\u7684\u89e3\u6790\u65b9\u5f0f");
    }

    public static boolean doBooleanJudge(boolean inputValue, String operator, boolean judgeValue) throws InterfaceException {
        switch (operator) {
            case "==": 
            case "equals": {
                return inputValue == judgeValue;
            }
            case "!=": 
            case "notEquals": {
                return inputValue != judgeValue;
            }
        }
        throw new InterfaceException("\n\tBoolean\u7c7b\u578b\u6ca1\u6709 " + operator + " \u5173\u7cfb\u8fd0\u7b97\u7b26\u7684\u89e3\u6790\u65b9\u5f0f");
    }

    public static boolean doJSONObjectJudge(Object inputObject, String operator, Object judgeObject) {
        BaseOperators baseOperator = BaseOperators.getWithCode(operator);
        return Boolean.FALSE;
    }

    public static boolean doJSONArrayJudge(Object inputObject, String operator, Object judgeObject) {
        BaseOperators baseOperator = BaseOperators.getWithCode(operator);
        return Boolean.FALSE;
    }

    public static boolean doNumberJudge(BigDecimal inputValue, String operator, BigDecimal judgeValue) throws InterfaceException {
        switch (operator) {
            case "==": {
                return inputValue.compareTo(judgeValue) == 0;
            }
            case "!=": {
                return inputValue.compareTo(judgeValue) != 0;
            }
            case "<": {
                return inputValue.compareTo(judgeValue) < 0;
            }
            case ">": {
                return inputValue.compareTo(judgeValue) > 0;
            }
            case "<=": {
                return inputValue.compareTo(judgeValue) < 1;
            }
            case ">=": {
                return inputValue.compareTo(judgeValue) > -1;
            }
        }
        throw new InterfaceException("\n\tNumber\u6570\u636e\u7c7b\u578b\u6ca1\u6709 " + operator + " \u5173\u7cfb\u8fd0\u7b97\u7b26\u7684\u89e3\u6790\u65b9\u5f0f");
    }

    public static boolean doForIntJudge(int inputObject, String operator, int judgeObject) throws InterfaceException {
        switch (operator) {
            case "==": {
                return inputObject == judgeObject;
            }
            case "!=": {
                return inputObject != judgeObject;
            }
            case "<": {
                return inputObject < judgeObject;
            }
            case ">": {
                return inputObject > judgeObject;
            }
            case "<=": {
                return inputObject <= judgeObject;
            }
            case ">=": {
                return inputObject >= judgeObject;
            }
        }
        throw new InterfaceException("\n\tNumber\u6570\u636e\u7c7b\u578b\u6ca1\u6709 " + operator + " \u5173\u7cfb\u8fd0\u7b97\u7b26\u7684\u89e3\u6790\u65b9\u5f0f");
    }

    public static Element createVariableElement(String name, String type, String inPath) throws InterfaceException {
        try {
            String variableString = "<VARIABLE name=\"" + name + "\" type=\"" + type + "\" inPath=\"" + inPath + "\"/>";
            Document document = DocumentHelper.parseText((String)variableString);
            return document.getRootElement();
        }
        catch (Exception e) {
            throw new InterfaceException("\n\t\u7a0b\u5e8f\u81ea\u5b9a\u4e49\u521b\u5efa \u53d8\u91cf\u5143\u7d20 \u5931\u8d25! ", e);
        }
    }

    public static Element createValuationElement(String inPath, String type, String outPath) throws InterfaceException {
        try {
            String valuationString = "<VALUATION inPath=\"" + inPath + "\" type=\"" + type + "\" outPath=\"" + outPath + "\"/>";
            Document document = DocumentHelper.parseText((String)valuationString);
            return document.getRootElement();
        }
        catch (Exception e) {
            throw new InterfaceException("\n\t\u7a0b\u5e8f\u81ea\u5b9a\u4e49\u521b\u5efa \u8d4b\u503c\u5143\u7d20 \u5931\u8d25! ", e);
        }
    }

    public static MethodAttributeBO getMethodAttribute(Element element) throws InterfaceException {
        MethodAttributeBO methodAttributeBO = new MethodAttributeBO();
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_INPATH.getCode())) {
                methodAttributeBO.setInPath(attribute.getValue());
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_TYPE.getCode())) {
                methodAttributeBO.setType(attribute.getValue());
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_OUTPATH.getCode())) {
                methodAttributeBO.setReturnPath(attribute.getValue());
                continue;
            }
            throw new InterfaceException("\n\t\u89e3\u6790\u65b9\u6cd5\u7684 " + element.getName() + " \u6807\u7b7e\u65f6\u51fa\u73b0\u4e86\u9519\u8bef\u5c5e\u6027: " + attribute.getName());
        }
        return methodAttributeBO;
    }
}

