/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="JSONObject")
public class JSONObjectMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        Object obj = this.upath.get(faceMsgContext, inPath);
        JSONObject jsonObject = obj instanceof Map ? (obj instanceof JSONObject ? (JSONObject)obj : new JSONObject((Map)((HashMap)obj))) : JSONObject.parseObject((String)obj.toString());
        switch (method) {
            case JSONObject_clear: {
                jsonObject.clear();
                return this.upath.put(faceMsgContext, inPath, jsonObject);
            }
            case JSONObject_get_key: {
                return this.doGetMethod(faceMsgContext, iterator, jsonObject);
            }
            case JSONObject_put_key_value: {
                this.doPutMethod(faceMsgContext, iterator, jsonObject);
                return this.upath.put(faceMsgContext, inPath, jsonObject);
            }
            case JSONObject_remove_key: 
            case JSONObject_remove_key_value: {
                this.doRemoveMethod(faceMsgContext, iterator, jsonObject);
                return this.upath.put(faceMsgContext, inPath, jsonObject);
            }
            case JSONObject_parseObject_text: 
            case JSONObject_parseObject_text_class: {
                return this.doParseObjectMethod(faceMsgContext, iterator);
            }
            case JSONObject_toJSON: {
                return this.doToJSONMethod(faceMsgContext, iterator);
            }
            case JSONObject_toString: {
                return this.doToStringMethod(faceMsgContext, iterator, jsonObject);
            }
            case JSONObject_toJSONString: {
                return this.doToJSONStringMethod(faceMsgContext, iterator);
            }
        }
        throw new InterfaceException("\n\tJSONObject\u7c7b\u578b\u4e0d\u5b58\u5728\u8be5\u65b9\u6cd5: " + method.getCode());
    }

    public <M> boolean doGetMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONObject jsonObject) throws InterfaceException {
        Object key = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                key = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), jsonObject.get((Object)key.toString()));
            }
            throw new InterfaceException("\n\tJSONObject.get()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        throw new InterfaceException("\n\tJSONObject.get()\u65b9\u6cd5\u5931\u8d25: \u6ca1\u6709\u8fd4\u56de\u8d4b\u503c! ");
    }

    public <M> boolean doPutMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONObject jsonObject) throws InterfaceException {
        String key = null;
        Object value = null;
        Object returnObject = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (key == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                key = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                value = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                returnObject = jsonObject.put(key, value);
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), returnObject);
            }
            throw new InterfaceException("\n\tJSONObject.put()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        return Boolean.TRUE;
    }

    public <M> void doRemoveMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONObject jsonObject) throws InterfaceException {
        Object key = null;
        Object value = null;
        Object returnObject = null;
        boolean flag = Boolean.FALSE;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (key == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                key = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                value = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                returnObject = jsonObject.remove((Object)key.toString(), value);
                flag = Boolean.TRUE;
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                if (Boolean.FALSE.equals(flag)) {
                    returnObject = jsonObject.remove((Object)key.toString());
                    flag = Boolean.TRUE;
                }
                this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), returnObject);
                continue;
            }
            throw new InterfaceException("\n\tJSONObject.remove()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        if (Boolean.FALSE.equals(flag)) {
            jsonObject.remove((Object)key.toString());
        }
    }

    public <M> boolean doParseObjectMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator) throws InterfaceException {
        String text = null;
        Object returnObject = null;
        boolean flag = Boolean.FALSE;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (text == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                text = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                returnObject = JSONObject.parseObject(text, GeneralUtils.getObjectByType(tagAttributes.getType(), tagAttributes.getInPath()).getClass());
                flag = Boolean.TRUE;
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                if (Boolean.FALSE.equals(flag)) {
                    if (text == null) {
                        throw new InterfaceException("\n\tJSONObject.parseObject()\u65b9\u6cd5\u4e2d\u672a\u8d4b\u503c\u6216\u8005\u672a\u6307\u5b9a\u53c2\u6570text\u4e3aString\u7c7b\u578b!!");
                    }
                    returnObject = JSONObject.parseObject((String)text);
                }
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), returnObject);
            }
            throw new InterfaceException("\n\tJSONObject.parseObject()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        if (Boolean.FALSE.equals(flag)) {
            throw new InterfaceException("\n\tJSONObject.parseObject()\u65b9\u6cd5\u5931\u8d25: \u6ca1\u6709\u8fd4\u56de\u8d4b\u503c! ");
        }
        return flag;
    }

    public <M> boolean doToJSONMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator) throws InterfaceException {
        Object javaObject = null;
        JSONObject returnObject = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (javaObject == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                javaObject = this.upath.get(faceMsgContext, tagAttributes.getInPath());
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                returnObject = (JSONObject)JSONObject.toJSON((Object)javaObject);
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), returnObject);
            }
            throw new InterfaceException("\n\tJSONObject.toJSON(obj)\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        throw new InterfaceException("\n\tJSONObject.toJSON(obj)\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!!");
    }

    public <M> boolean doToStringMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONObject jsonObject) throws InterfaceException {
        if (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty()) && next.getName().equals(BaseTags.TAG_VALUATION.getCode())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), jsonObject.toString());
            }
            throw new InterfaceException("\n\tJSONObject.toString()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        throw new InterfaceException("\n\tJSONObject.toString()\u65b9\u6cd5\u6267\u884c\u9519\u8bef: \u6ca1\u6709\u8d4b\u503c\u64cd\u4f5c! ");
    }

    public <M> boolean doToJSONStringMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator) throws InterfaceException {
        Object arg1Obj = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (arg1Obj == null && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                arg1Obj = this.upath.get(faceMsgContext, tagAttributes.getInPath());
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), JSONObject.toJSONString((Object)arg1Obj));
            }
            throw new InterfaceException("\n\tJSONObject.toJSONString(obj)\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        throw new InterfaceException("\n\tJSONObject.toJSONString(obj)\u65b9\u6cd5\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!!");
    }
}

