/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseAttributes;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseOperators;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.service.parse.tag.Logic;
import com.ohaotian.plugin.service.parse.tag.LogicAdapter;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="IF")
public class IfLogicImpl
implements Logic {
    private static final Logger log = LoggerFactory.getLogger(IfLogicImpl.class);
    @Autowired
    private Upath upath;
    @Lazy
    @Autowired
    private LogicAdapter logicAdapter;

    @Override
    public <M> void doService(FaceMsgContext<M> faceMsgContext, Element element) throws InterfaceException {
        List attributes = element.attributes();
        String[] inPathList = null;
        String[] operatorList = null;
        String[] typeList = null;
        String[] judgePathList = null;
        String[] multivariateList = null;
        for (Attribute attribute : attributes) {
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_INPATH.getCode())) {
                inPathList = attribute.getValue().split(";");
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_OPERATOR.getCode())) {
                operatorList = attribute.getValue().split(";");
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_TYPE.getCode())) {
                typeList = attribute.getValue().split(";");
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_JUDGEPATH.getCode())) {
                judgePathList = attribute.getValue().split(";");
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_MULTIVARIATE.getCode())) {
                multivariateList = attribute.getValue().split(";");
                continue;
            }
            throw new InterfaceException("\n\tIF\u6807\u7b7e\u5305\u542b\u4e86\u9519\u8bef\u5c5e\u6027 " + attribute.getName());
        }
        boolean resultFlag = Boolean.FALSE;
        if (inPathList.length == 1) {
            void inPath = inPathList[0];
            void operator = operatorList[0];
            void type = typeList[0];
            void judgePath = judgePathList[0];
            if (type.equals(BaseObjects.OBJECT_NULL.getCode())) {
                if (operator.equals(BaseOperators.OPERATOR_NUMBER_EQUALS.getCode())) {
                    resultFlag = this.upath.get(faceMsgContext, (String)inPath) == null;
                } else if (operator.equals(BaseOperators.OPERATOR_NUMBER_NOT_EQUALS.getCode())) {
                    resultFlag = this.upath.get(faceMsgContext, (String)inPath) != null;
                }
            } else {
                resultFlag = this.doJudgeService((String)inPath, (String)operator, (String)judgePath, (String)type, faceMsgContext);
            }
        } else if (inPathList.length == operatorList.length && inPathList.length == typeList.length && inPathList.length == judgePathList.length && inPathList.length == multivariateList.length + 1) {
            for (int i = 0; i < inPathList.length; ++i) {
                String multivariate;
                if (i > 0) {
                    multivariate = multivariateList[i - 1];
                    if (Boolean.FALSE.equals(resultFlag) && multivariate.equals(BaseOperators.OPERATOR_AND.getCode()) || resultFlag && multivariate.equals(BaseOperators.OPERATOR_OR.getCode())) continue;
                }
                boolean itemFlag = Boolean.FALSE;
                String inPath = inPathList[i];
                String operator = operatorList[i];
                String type = typeList[i];
                String judgePath = judgePathList[i];
                if (type.equals(BaseObjects.OBJECT_NULL.getCode())) {
                    if (operator.equals(BaseOperators.OPERATOR_NUMBER_EQUALS.getCode())) {
                        itemFlag = this.upath.get(faceMsgContext, inPath) == null;
                    } else if (operator.equals(BaseOperators.OPERATOR_NUMBER_NOT_EQUALS.getCode())) {
                        itemFlag = this.upath.get(faceMsgContext, inPath) != null;
                    }
                } else {
                    itemFlag = this.doJudgeService(inPath, operator, judgePath, type, faceMsgContext);
                }
                if (i > 0) {
                    multivariate = multivariateList[i - 1];
                    if (multivariate.equals(BaseOperators.OPERATOR_AND.getCode())) {
                        resultFlag = resultFlag && itemFlag;
                        continue;
                    }
                    if (multivariate.equals(BaseOperators.OPERATOR_OR.getCode())) {
                        resultFlag = resultFlag || itemFlag;
                        continue;
                    }
                    throw new InterfaceException("\n\tIF\u6807\u7b7e multivariate\u5c5e\u6027\u51fa\u73b0\u4e86\u9519\u8bef\u7684\u591a\u5143\u5224\u65ad\u7b26\uff1a" + multivariate + "\uff0c\u5f53\u524d\u7248\u672c\u4ec5\u652f\u6301or,and");
                }
                resultFlag = itemFlag;
            }
        } else {
            StringBuilder errorValue = new StringBuilder();
            for (Attribute attribute : attributes) {
                errorValue.append(attribute.getName());
                errorValue.append("=");
                errorValue.append(attribute.getValue());
                errorValue.append(" ");
            }
            throw new InterfaceException("\n\tIF\u6807\u7b7e\u4e2d\u5c5e\u6027\u7684\u53c2\u6570\u53d1\u751f\u9519\u8bef\uff0c\u591a\u5143\u5224\u65ad\u4e2a\u6570\u4e0d\u5339\u914d!!\u5bf9\u5e94\u7684\u5c5e\u6027\u548c\u53c2\u6570\u4e3a\uff1a" + errorValue);
        }
        if (resultFlag) {
            Iterator iterator = element.elementIterator();
            this.logicAdapter.doLoopAnalysis(faceMsgContext, iterator);
        } else {
            Element elseElement = element.element(BaseTags.TAG_ELSE.getCode());
            if (elseElement != null) {
                Iterator iterator = elseElement.elementIterator();
                this.logicAdapter.doLoopAnalysis(faceMsgContext, iterator);
            }
        }
    }

    public <M> boolean doJudgeService(String inPath, String operator, String judgePath, String type, FaceMsgContext<M> faceMsgContext) throws InterfaceException {
        Object inputValue = GeneralUtils.getObjectByType(type, this.upath.get(faceMsgContext, inPath));
        Object judgeValue = GeneralUtils.getObjectByType(type, this.upath.get(faceMsgContext, judgePath));
        if (inputValue == null || inputValue instanceof String && judgeValue == null) {
            throw new InterfaceException("\n\tIF\u6807\u7b7e\u4e2d\u53c2\u4e0e\u5224\u65ad\u7684\u53c2\u6570\u4e3a\u7a7a! \u5f85\u5224\u65ad\u53c2\u6570\u4e3a\uff1a" + inPath + ",\u76ee\u6807\u5224\u65ad\u53c2\u6570\u4e3a\uff1a" + judgePath);
        }
        if (inputValue instanceof Number) {
            BigDecimal inputNumberValue = new BigDecimal(inputValue.toString());
            BigDecimal judgeNumberValue = new BigDecimal(judgeValue.toString());
            return GeneralUtils.doNumberJudge(inputNumberValue, operator, judgeNumberValue);
        }
        if (inputValue instanceof String) {
            return GeneralUtils.doStringJudge((String)inputValue, operator, (String)judgeValue);
        }
        if (inputValue instanceof Boolean) {
            return GeneralUtils.doBooleanJudge((Boolean)inputValue, operator, (Boolean)judgeValue);
        }
        if (inputValue instanceof Map) {
            return GeneralUtils.doJSONObjectJudge(inputValue, operator, judgeValue);
        }
        if (inputValue instanceof Collection) {
            return GeneralUtils.doJSONArrayJudge(inputValue, operator, judgeValue);
        }
        throw new InterfaceException("\n\t\u6267\u884c\u5224\u65ad\u7684\u7c7b\u578b\u9519\u8bef! \u5f85\u5224\u65ad\u53c2\u6570\u4e3a\uff1a" + inPath + ",\u5f85\u5224\u65ad\u7c7b\u578b\u4e3a\uff1a" + inPath.getClass());
    }
}

