/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util.safety;

import com.ohaotian.plugin.util.safety.BASE16coder;
import com.ohaotian.plugin.util.safety.BASE32coder;
import com.ohaotian.plugin.util.safety.SM3;
import com.ohaotian.plugin.util.safety.SMS4;
import com.ohaotian.plugin.util.safety.model.SafetyEncoder;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Algorithm {
    private static Random rd = new Random();
    public static final String PUBLIC_KEY = "PublicKey";
    public static final String PRIVATE_KEY = "PrivateKey";

    public static byte[] aesEncrypt(String original, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)skeySpec, iv);
        return cipher.doFinal(original.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] aesEncrypt(byte[] original, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(original);
        return encrypted;
    }

    public static byte[] aesEncryptnopadding(byte[] original, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/noPadding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(original);
        return encrypted;
    }

    public static String aesDecrypt(byte[] encrypted, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(encrypted);
        return new String(original, "UTF-8");
    }

    public static byte[] aesDecryptByte(byte[] encrypted, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(encrypted);
        return original;
    }

    public static String aesDecryptnopadding(byte[] encrypted, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/noPadding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(encrypted);
        byte pad = original[original.length - 1];
        boolean isPadding = false;
        if (pad > 0 && pad <= 15) {
            isPadding = true;
            for (int i = original.length - 1; i >= original.length - pad; --i) {
                if (pad == Integer.valueOf(original[i])) continue;
                isPadding = false;
                break;
            }
        }
        if (isPadding) {
            original = Arrays.copyOfRange(original, 0, original.length - pad);
        }
        return new String(original, "UTF-8");
    }

    public static byte[] aesDecryptnopaddingByte(byte[] encrypted, byte[] key, byte[] ivBytes) throws Exception {
        if (key == null || key.length != 16) {
            return null;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/noPadding");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(encrypted);
        byte pad = original[original.length - 1];
        boolean isPadding = false;
        if (pad > 0 && pad <= 15) {
            isPadding = true;
            for (int i = original.length - 1; i >= original.length - pad; --i) {
                if (pad == Integer.valueOf(original[i])) continue;
                isPadding = false;
                break;
            }
        }
        if (isPadding) {
            original = Arrays.copyOfRange(original, 0, original.length - pad);
        }
        return original;
    }

    public static byte[] hmacSha1(String text, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException {
        try {
            Mac hmacSha1;
            try {
                hmacSha1 = Mac.getInstance("HmacSHA1");
            }
            catch (NoSuchAlgorithmException nsae) {
                hmacSha1 = Mac.getInstance("HMAC-SHA-1");
            }
            SecretKeySpec macKey = new SecretKeySpec(key, "RAW");
            hmacSha1.init(macKey);
            return hmacSha1.doFinal(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    public static byte[] hmacSha256(String text, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException {
        try {
            Mac hmacSha256;
            try {
                hmacSha256 = Mac.getInstance("HmacSHA256");
            }
            catch (NoSuchAlgorithmException nsae) {
                hmacSha256 = Mac.getInstance("HMAC-SHA-256");
            }
            SecretKeySpec macKey = new SecretKeySpec(key, "RAW");
            hmacSha256.init(macKey);
            return hmacSha256.doFinal(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    public static byte[] hmacSha256(byte[] text, byte[] key) {
        try {
            Mac hmacSha256;
            try {
                hmacSha256 = Mac.getInstance("HmacSHA256");
            }
            catch (NoSuchAlgorithmException nsae) {
                hmacSha256 = Mac.getInstance("HMAC-SHA-256");
            }
            SecretKeySpec macKey = new SecretKeySpec(key, "RAW");
            hmacSha256.init(macKey);
            return hmacSha256.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    public static byte[] MD5(String inStr) {
        MessageDigest md = null;
        byte[] digest = null;
        try {
            md = MessageDigest.getInstance("MD5");
            digest = md.digest(inStr.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return digest;
    }

    public static byte[] sha1(String inStr) {
        MessageDigest md = null;
        byte[] digest = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            digest = md.digest(inStr.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return digest;
    }

    public static byte[] sha256(String inStr) {
        MessageDigest md = null;
        byte[] digest = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            digest = md.digest(inStr.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return digest;
    }

    public static byte[] sha256Byte(byte[] inByte) {
        MessageDigest md = null;
        byte[] digest = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            digest = md.digest(inByte);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return digest;
    }

    public static String encode(byte[] baseByte, SafetyEncoder encoder) {
        String encodeText;
        switch (encoder) {
            case Base64: {
                encodeText = Base64.getEncoder().encodeToString(baseByte);
                break;
            }
            case Base16: {
                BASE16coder base16Encoder = new BASE16coder();
                encodeText = base16Encoder.encode(baseByte);
                break;
            }
            case Base32: {
                BASE32coder base32Encoder = new BASE32coder();
                encodeText = base32Encoder.encode(baseByte);
                break;
            }
            default: {
                encodeText = null;
            }
        }
        return encodeText != null ? encodeText.replaceAll(System.lineSeparator(), "") : null;
    }

    public static byte[] decode(String baseString, SafetyEncoder encoder) throws Exception {
        byte[] decodeBytes;
        switch (encoder) {
            case Base64: {
                decodeBytes = Base64.getDecoder().decode(baseString);
                break;
            }
            case Base16: {
                BASE16coder base16Decoder = new BASE16coder();
                decodeBytes = base16Decoder.decode(baseString);
                break;
            }
            case Base32: {
                BASE32coder base32Decoder = new BASE32coder();
                decodeBytes = base32Decoder.decode(baseString);
                break;
            }
            default: {
                decodeBytes = null;
            }
        }
        return decodeBytes;
    }

    public static String getRandom(int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append(rd.nextInt(10));
        }
        return buf.toString();
    }

    public static byte[] getRadomASCII(int length) {
        if (length <= 0 || length >= 255) {
            return null;
        }
        byte[] buf = new byte[length];
        for (int i = 0; i < length; ++i) {
            byte b;
            buf[i] = b = (byte)rd.nextInt(255);
        }
        return buf;
    }

    public static byte[] getSM3Hash(byte[] source) throws IOException {
        if (source == null || source.length == 0) {
            return new byte[0];
        }
        byte[] sm3HashValue = SM3.hash(source);
        System.out.println("hash result -- " + Algorithm.bytesToHexString(sm3HashValue));
        return sm3HashValue;
    }

    public static byte[] getSM3Hmac(byte[] source, byte[] key) throws IOException {
        if (source == null || source.length == 0) {
            return null;
        }
        byte[] sm3HashValue = SM3.hmac_hash(key, source);
        return sm3HashValue;
    }

    public static byte[] encryptSMS4Nopadding(byte[] in, byte[] key) throws IOException {
        if (in == null || in.length < 16 || key == null || key.length < 16) {
            return null;
        }
        SMS4 sm4 = new SMS4();
        byte[] input = in;
        byte[] out = new byte[input.length];
        int ENCRYPT = 1;
        long starttime = System.nanoTime();
        sm4.sms4(input, input.length, key, out, ENCRYPT);
        return out;
    }

    public static byte[] decryptSMS4Nopadding(byte[] in, byte[] key) throws IOException {
        if (in == null || in.length < 16 || key == null || key.length < 16) {
            return null;
        }
        SMS4 sm4 = new SMS4();
        byte[] out = new byte[in.length];
        int DECRYPT = 0;
        long starttime = System.nanoTime();
        sm4.sms4(in, in.length, key, out, DECRYPT);
        byte[] output = out;
        return output;
    }

    public static byte[] encryptSMS4PCS5Padding(byte[] in, byte[] key) throws IOException {
        if (in == null || key == null || key.length < 16) {
            return null;
        }
        SMS4 sm4 = new SMS4();
        byte[] input = sm4.padding_PCS5(in);
        byte[] out = new byte[input.length];
        int ENCRYPT = 1;
        long starttime = System.nanoTime();
        sm4.sms4(input, input.length, key, out, ENCRYPT);
        return out;
    }

    public static byte[] decryptSMS4PCS5Padding(byte[] in, byte[] key) throws IOException {
        if (in == null || in.length < 16 || key == null || key.length < 16) {
            return new byte[0];
        }
        SMS4 sm4 = new SMS4();
        byte[] out = new byte[in.length];
        int DECRYPT = 0;
        long starttime = System.nanoTime();
        sm4.sms4(in, in.length, key, out, DECRYPT);
        byte[] output = sm4.cutpadding_PCS5(out);
        return output;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            String hex = Integer.toHexString(src[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            stringBuilder.append(hex.toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static byte[] HexStringtoByte(String src) {
        if (src == null || src.isEmpty()) {
            return new byte[0];
        }
        int len = src.length() / 2;
        byte[] result = new byte[len];
        char[] achar = src.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(Algorithm.toByte(achar[pos]) << 4 | Algorithm.toByte(achar[pos + 1]) & 0xFF);
        }
        return result;
    }

    private static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static Map<String, String> genRSAKeyPair() {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, String> keyMap = new HashMap<String, String>(2);
        keyMap.put(PUBLIC_KEY, Base64.getEncoder().encodeToString(publicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY, Base64.getEncoder().encodeToString(privateKey.getEncoded()));
        return keyMap;
    }
}

