/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseAttributes;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BasePaths;
import com.ohaotian.plugin.service.parse.tag.Logic;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="VARIABLE")
public class VariableLogicImpl
implements Logic {
    private static final Logger log = LoggerFactory.getLogger(VariableLogicImpl.class);
    @Autowired
    private Upath upath;

    @Override
    public <M> void doService(FaceMsgContext<M> faceMsgContext, Element element) throws InterfaceException {
        List attributes = element.attributes();
        String variableName = null;
        String inPath = BasePaths.PATH_NULL.getCode();
        String type = BaseObjects.OBJECT_NULL.getCode();
        for (Attribute attribute : attributes) {
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_NAME.getCode())) {
                variableName = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_TYPE.getCode())) {
                type = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_INPATH.getCode())) {
                inPath = attribute.getValue();
                continue;
            }
            throw new InterfaceException("\n\tVARIABLE\u53d8\u91cf\u6807\u7b7e\u5305\u542b\u4e86\u9519\u8bef\u5c5e\u6027 " + attribute.getName());
        }
        Object variableValue = GeneralUtils.getObjectByType(type, this.upath.get(faceMsgContext, inPath));
        this.upath.put(faceMsgContext, BasePaths.PATH_VARIABLE.getCode() + "." + variableName, variableValue);
    }
}

