/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.asymmetric.SM2;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.Base64;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Decoder;

@Service(value="Encryption")
public class EncryptionMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String IV = "2233445566778899";

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        String arg1Str = null;
        String arg2Str = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (arg1Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                arg1Str = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (arg2Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                arg2Str = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                switch (method) {
                    case Encryption_Base64_getEncoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), java.util.Base64.getEncoder().encodeToString(arg1Str.getBytes(StandardCharsets.UTF_8)));
                    }
                    case Encryption_Base64_getDecoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), new String(java.util.Base64.getDecoder().decode(arg1Str)));
                    }
                    case Encryption_Base64_getUrlEncoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), java.util.Base64.getUrlEncoder().encodeToString(arg1Str.getBytes(StandardCharsets.UTF_8)));
                    }
                    case Encryption_Base64_getUrlDecoder: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), new String(java.util.Base64.getUrlDecoder().decode(arg1Str)));
                    }
                    case Encryption_URLEncoder_encode: {
                        arg2Str = arg2Str == null ? "UTF-8" : arg2Str;
                        try {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), URLEncoder.encode(arg1Str, arg2Str));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InterfaceException(e.getMessage(), e);
                        }
                    }
                    case Encryption_URLDecoder_decode: {
                        arg2Str = arg2Str == null ? "UTF-8" : arg2Str;
                        try {
                            return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), URLDecoder.decode(arg1Str, arg2Str));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InterfaceException(e.getMessage(), e);
                        }
                    }
                    case Encryption_SM2_encode: {
                        return this.doSM2EncodeMethod(faceMsgContext, arg1Str, arg2Str, tagAttributes.getReturnPath());
                    }
                    case Encryption_AES_encrypt: {
                        return this.doAESEncryptMethod(faceMsgContext, arg1Str, arg2Str, tagAttributes.getReturnPath());
                    }
                    case Encryption_AES_decrypt: {
                        return this.doAESDecryptMethod(faceMsgContext, arg1Str, arg2Str, tagAttributes.getReturnPath());
                    }
                }
                throw new InterfaceException("\n\tBase64\u65b9\u6cd5\u4e2d\u4e0d\u5b58\u5728\u8be5\u65b9\u6cd5: " + method.getCode());
            }
            throw new InterfaceException("\n\tBase64." + method.getCode() + "\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570:" + next.getName());
        }
        throw new InterfaceException("\n\tBase64\u65b9\u6cd5\u89e3\u6790\u9519\u8bef: " + method.getCode() + " \u65b9\u6cd5\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!");
    }

    public static String base64Encode(byte[] bytes) {
        String data = Base64.encodeBase64String((byte[])bytes);
        if (!StringUtils.isEmpty((Object)data)) {
            return data.replaceAll("[\\s*\t\n\r]", "");
        }
        return data;
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtils.isEmpty((Object)base64Code) ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        byte[] raw = encryptKey.getBytes();
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(IV.getBytes());
        cipher.init(1, (Key)secretKeySpec, iv);
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        byte[] raw = decryptKey.getBytes();
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec(IV.getBytes());
        cipher.init(2, (Key)secretKeySpec, iv);
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public <M> boolean doAESEncryptMethod(FaceMsgContext<M> faceMsgContext, String data, String privateKey, String returnPath) {
        try {
            String result = EncryptionMethodsImpl.base64Encode(EncryptionMethodsImpl.aesEncryptToBytes(data, privateKey));
            return this.upath.put(faceMsgContext, returnPath, result);
        }
        catch (Exception e) {
            throw new InterfaceException("\n\tAES\u52a0\u5bc6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
    }

    public <M> boolean doAESDecryptMethod(FaceMsgContext<M> faceMsgContext, String encryptData, String privateKey, String returnPath) {
        try {
            String result = StringUtils.isEmpty((Object)encryptData) ? null : EncryptionMethodsImpl.aesDecryptByBytes(EncryptionMethodsImpl.base64Decode(encryptData), privateKey);
            return this.upath.put(faceMsgContext, returnPath, result);
        }
        catch (Exception e) {
            throw new InterfaceException("\n\tAES\u89e3\u5bc6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
        }
    }

    public <M> boolean doSM2EncodeMethod(FaceMsgContext<M> faceMsgContext, String privateKey, String after, String returnPath) {
        SM2 sm2 = new SM2(BCUtil.toSm2Params((String)privateKey), null);
        byte[] sign = sm2.sign(after.getBytes(StandardCharsets.UTF_8), null);
        String result = HexUtil.encodeHexStr((byte[])sign);
        return this.upath.put(faceMsgContext, returnPath, result);
    }
}

