/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.path.impl;

import com.alibaba.fastjson.JSONPath;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BasePaths;
import com.ohaotian.plugin.service.path.Upath;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UpathServiceImpl
implements Upath {
    private static final Logger log = LoggerFactory.getLogger(UpathServiceImpl.class);
    public static final String WILDCARD_BEFORE = "[*";
    public static final String WILDCARD_AFTER = "*]";

    @Override
    public <M> Object get(FaceMsgContext<M> faceMsgContext, String path) throws InterfaceException {
        try {
            if (path.startsWith(BasePaths.PATH_BASHPATH.getCode())) {
                while (path.contains(WILDCARD_BEFORE)) {
                    String name = StringUtils.substringBefore((String)StringUtils.substringAfter((String)path, (String)WILDCARD_BEFORE), (String)WILDCARD_AFTER);
                    String indexPath = "$.system.variable." + name;
                    String index = JSONPath.eval(faceMsgContext, (String)indexPath).toString();
                    path = path.replace(WILDCARD_BEFORE + name + WILDCARD_AFTER, "[" + index + "]");
                }
                return JSONPath.eval(faceMsgContext, (String)path);
            }
            return path;
        }
        catch (Exception e) {
            throw new InterfaceException("\n\t\u83b7\u53d6\u7edf\u4e00\u6570\u636e\u8def\u5f84\u5f02\u5e38: " + e.getMessage() + " \u83b7\u53d6\u8def\u5f84\u4e3a: " + path, e);
        }
    }

    @Override
    public <M> Boolean put(FaceMsgContext<M> faceMsgContext, String path, Object value) throws InterfaceException {
        try {
            while (path.contains(WILDCARD_BEFORE)) {
                String name = StringUtils.substringBefore((String)StringUtils.substringAfter((String)path, (String)WILDCARD_BEFORE), (String)WILDCARD_AFTER);
                String indexPath = "$.system.variable." + name;
                String index = JSONPath.eval(faceMsgContext, (String)indexPath).toString();
                path = path.replace(WILDCARD_BEFORE + name + WILDCARD_AFTER, "[" + index + "]");
            }
            return JSONPath.set(faceMsgContext, (String)path, (Object)value);
        }
        catch (Exception e) {
            throw new InterfaceException("\n\t\u4fee\u6539\u7edf\u4e00\u6570\u636e\u8def\u5f84\u5f02\u5e38: " + e.getMessage() + " \u4fee\u6539\u8def\u5f84\u4e3a: " + path + " \u4fee\u6539\u6570\u636e\u4e3a: " + value, e);
        }
    }

    @Override
    public <M> Object remove(FaceMsgContext<M> faceMsgContext, String path) {
        try {
            return JSONPath.set(faceMsgContext, (String)path, null);
        }
        catch (Exception e) {
            throw new InterfaceException("\n\t\u79fb\u9664\u7edf\u4e00\u6570\u636e\u8def\u5f84\u5f02\u5e38: " + e.getMessage() + " \u79fb\u9664\u8def\u5f84\u4e3a: " + path, e);
        }
    }
}

