/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelListener
extends AnalysisEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(ExcelListener.class);
    private List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
    private List<Integer> indexList = new ArrayList<Integer>();
    private Map<String, Map<String, JSONObject>> abilityResult = new HashMap<String, Map<String, JSONObject>>();
    private JSONObject tempObject = new JSONObject();
    public static final String ORIGIN_FIELD = "originFiled";
    public static final String TARGET_FIELD = "targetField";
    public static final String DESCRIPTION = "description";
    public static final String TYPE = "type";
    public static final String IS_NULL = "isNull";
    public static final String DEFAULT_VALUE = "defaultValue";
    public static final String PROPERTIES = "properties";
    public static final String[] TYPE_LIST = new String[]{"Integer", "String", "Number", "BigDecimal", "Boolean", "Long", "Double", "JSONArray"};

    public void invoke(Object object, AnalysisContext analysisContext) {
        this.dataList.add((Map<String, Object>)JSONObject.parseObject((String)JSON.toJSONString((Object)object)));
    }

    public void extra(CellExtra extra, AnalysisContext context) {
        this.indexList.add(extra.getRowIndex());
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.indexList.sort(Comparator.comparing(Integer::intValue));
        JSONObject field = new JSONObject();
        for (int rowIndex = 0; rowIndex < this.indexList.get(0) - 1; ++rowIndex) {
            JSONObject fieldInfo = this.getFieldInfo(rowIndex);
            this.tempObject.put(this.dataList.get(rowIndex).get(1).toString(), (Object)fieldInfo);
        }
    }

    public JSONObject getFieldInfo(int rowIndex) {
        JSONObject fieldDetails = new JSONObject();
        String type = this.dataList.get(rowIndex).get("3").toString();
        if (Boolean.FALSE.equals(Arrays.asList(TYPE_LIST).contains(type))) {
            if (type.contains("List")) {
                type = type.substring(5, type.length() - 1);
                fieldDetails.put(TYPE, (Object)"Array");
            } else {
                fieldDetails.put(TYPE, (Object)"Object");
            }
            fieldDetails.put(PROPERTIES, (Object)this.getProperties(type));
        } else {
            fieldDetails.put(TYPE, this.dataList.get(rowIndex).get("3"));
        }
        fieldDetails.put(ORIGIN_FIELD, this.dataList.get(rowIndex).get("0"));
        fieldDetails.put(DESCRIPTION, this.dataList.get(rowIndex).get("2"));
        fieldDetails.put(IS_NULL, this.dataList.get(rowIndex).get("4"));
        fieldDetails.put(DEFAULT_VALUE, this.dataList.get(rowIndex).get("5"));
        return fieldDetails;
    }

    public JSONObject getProperties(String parentType) {
        JSONObject jsonObject = new JSONObject();
        int indexListSize = this.indexList.size();
        for (int i = 0; i < indexListSize; ++i) {
            Map<String, Object> objectMap = this.dataList.get(this.indexList.get(i) - 1);
            if (!objectMap.get(0).equals(parentType)) continue;
            int startRow = this.indexList.get(i);
            int endRow = this.dataList.size();
            if (i + 1 != indexListSize) {
                endRow = this.indexList.get(i + 1) - 1;
            }
            while (startRow < endRow) {
                JSONObject fieldInfo = this.getFieldInfo(startRow);
                jsonObject.put(this.dataList.get(startRow).get(1).toString(), (Object)fieldInfo);
                ++startRow;
            }
        }
        return jsonObject;
    }

    public void initResult() {
        this.abilityResult.put("req", new HashMap());
        this.abilityResult.put("rsp", new HashMap());
    }

    public Map<String, Map<String, JSONObject>> getDocxResult() {
        return this.abilityResult;
    }

    public void putObjectWithName(String name) {
        String[] split = name.split("-");
        String abilityEname = split[0];
        String reqOrRsp = split[1];
        System.out.println("sheet\u9875\u7ed3\u675f\u540e\u7684temp" + JSON.toJSONString((Object)this.tempObject));
        JSONObject object = new JSONObject();
        object.put(TYPE, (Object)"object");
        object.put("title", (Object)(abilityEname + "\u80fd\u529b\u8be6\u7ec6\u4fe1\u606f"));
        object.put(ORIGIN_FIELD, null);
        object.put(PROPERTIES, (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)this.tempObject)));
        this.abilityResult.get(reqOrRsp).put(abilityEname, object);
        System.out.println("sheet\u9875\u7ed3\u675f\u540e\u7684\u503c" + JSON.toJSONString(this.abilityResult));
        this.tempObject.clear();
        this.indexList.clear();
        this.dataList.clear();
    }
}

