/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.plugin.api.DataProcessingService;
import com.ohaotian.plugin.api.InterfaceService;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.service.parse.tag.LogicAdapter;
import java.util.Iterator;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterfaceServiceImpl
implements InterfaceService {
    private static final Logger log = LoggerFactory.getLogger(InterfaceServiceImpl.class);
    @Autowired
    private LogicAdapter logicAdapter;
    @Resource(name="${interface.dataProcessing.name:pisces}")
    private DataProcessingService dataProcessingService;

    @Override
    public <M> M doService(M msgContext, String xml) throws InterfaceException {
        FaceMsgContext<M> faceMsgContext = new FaceMsgContext<M>(msgContext);
        try {
            this.dataProcessingService.doInitService(faceMsgContext);
            this.performingConfiguration(faceMsgContext, xml);
            this.dataProcessingService.doAssignmentService(faceMsgContext);
            return faceMsgContext.getSystem().getBase();
        }
        catch (Exception e) {
            log.error("\n=======xml\u811a\u672c\u89e3\u6790\u5931\u8d25=======");
            throw new InterfaceException("\n\txml\u89e3\u6790\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
        }
    }

    private <M> void performingConfiguration(FaceMsgContext<M> faceMsgContext, String xmlString) throws InterfaceException, DocumentException {
        Document document = DocumentHelper.parseText((String)xmlString);
        Element interfaceElement = document.getRootElement();
        if (Boolean.FALSE.equals(interfaceElement.getName().equals(BaseTags.TAG_INTERFACE.getCode()))) {
            throw new InterfaceException("\n\t\u8be5xml\u4e0d\u7b26\u5408\u7a0b\u5e8f\u6267\u884c\u89c4\u8303! ");
        }
        Iterator iterator = interfaceElement.elementIterator();
        this.logicAdapter.doLoopAnalysis(faceMsgContext, iterator);
    }
}

