/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.service.parse.tag.Logic;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicAdapter {
    private static final Logger log = LoggerFactory.getLogger(LogicAdapter.class);
    @Autowired
    private Map<String, Logic> logicMap = new ConcurrentHashMap<String, Logic>();

    public Logic getStrategy(String logic) throws InterfaceException {
        Logic strategy = this.logicMap.get(logic);
        if (strategy == null) {
            throw new InterfaceException("\n\t" + logic + "\u6807\u7b7e\u6ca1\u6709\u89e3\u6790\u65b9\u5f0f!!");
        }
        return strategy;
    }

    public <M> void doLoopAnalysis(FaceMsgContext<M> faceMsgContext, Iterator iterator) throws InterfaceException {
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Logic logic = this.getStrategy(element.getName());
            logic.doService(faceMsgContext, element);
        }
    }
}

