/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseAttributes;
import com.ohaotian.plugin.model.baseEnum.BaseIteration;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BasePaths;
import com.ohaotian.plugin.service.parse.tag.Logic;
import com.ohaotian.plugin.service.parse.tag.LogicAdapter;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="FOR")
public class ForLogicImpl
implements Logic {
    private static final Logger log = LoggerFactory.getLogger(ForLogicImpl.class);
    @Autowired
    private Upath upath;
    @Lazy
    @Autowired
    private LogicAdapter logicAdapter;

    @Override
    public <M> void doService(FaceMsgContext<M> faceMsgContext, Element element) throws InterfaceException {
        List attributes = element.attributes();
        String type = BaseObjects.OBJECT_INTEGER.getCode();
        String startCountPath = null;
        String operator = null;
        String stopCountPath = null;
        String iteration = null;
        String tempName = null;
        for (Attribute attribute : attributes) {
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_STARTCOUNT.getCode())) {
                startCountPath = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_OPERATOR.getCode())) {
                operator = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_STOPCOUNT.getCode())) {
                stopCountPath = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_ITERATION.getCode())) {
                iteration = attribute.getValue();
                continue;
            }
            if (attribute.getName().equals(BaseAttributes.ATTRIBUTE_NAME.getCode())) {
                tempName = attribute.getValue();
                continue;
            }
            throw new InterfaceException("\n\tFOR\u6807\u7b7e\u5305\u542b\u4e86\u9519\u8bef\u5c5e\u6027 " + attribute.getName());
        }
        Element variableElement = GeneralUtils.createVariableElement(tempName, type, startCountPath);
        Logic logic = this.logicAdapter.getStrategy(variableElement.getName());
        logic.doService(faceMsgContext, variableElement);
        String variablePath = BasePaths.PATH_VARIABLE.getCode() + "." + tempName;
        Integer startCount = this.doIteration(faceMsgContext, variablePath, BaseIteration.ITERATION_INIT.getCode());
        Integer stopCount = this.doIteration(faceMsgContext, stopCountPath, BaseIteration.ITERATION_INIT.getCode());
        if (startCount == null || stopCount == null) {
            throw new InterfaceException("\n\t\u5faa\u73af\u6570\u5b58\u5728\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01 FOR\u5bf9\u5e94\u7684\u5faa\u73af\u53d8\u91cf\u540d\u4e3a\uff1a" + tempName + "\uff0c\u6b62\u5faa\u73af\u6570\u7684\u8def\u5f84\u503c\u4e3a\uff1a" + stopCountPath);
        }
        while (GeneralUtils.doForIntJudge(startCount, operator, stopCount)) {
            Iterator iterator = element.elementIterator();
            this.logicAdapter.doLoopAnalysis(faceMsgContext, iterator);
            startCount = this.doIteration(faceMsgContext, variablePath, iteration);
        }
        this.upath.remove(faceMsgContext, variablePath);
    }

    public <M> Integer doIteration(FaceMsgContext<M> faceMsgContext, String variablePath, String iteration) throws InterfaceException {
        Integer startCount = Integer.parseInt(this.upath.get(faceMsgContext, variablePath).toString());
        switch (iteration) {
            case "init": {
                return startCount;
            }
            case "++": {
                startCount = startCount + 1;
                break;
            }
            case "--": {
                startCount = startCount - 1;
                break;
            }
            default: {
                throw new InterfaceException("\n\tFOR\u5faa\u73af\u6807\u7b7e\u4e2d\u4e0d\u5b58\u5728 " + iteration + " \u64cd\u4f5c\u7b26\uff0c\u5f53\u524d\u7248\u672c\u4ec5\u652f\u6301init,++,--");
            }
        }
        Element valuationElement = GeneralUtils.createValuationElement(startCount.toString(), BaseObjects.OBJECT_INTEGER.getCode(), variablePath);
        Logic logic = this.logicAdapter.getStrategy(valuationElement.getName());
        logic.doService(faceMsgContext, valuationElement);
        return startCount;
    }
}

