/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="JSONArray")
public class JSONArrayMethodsImpl
implements Methods {
    private static final Logger log = LoggerFactory.getLogger(JSONArrayMethodsImpl.class);
    @Autowired
    private Upath upath;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        Object obj = this.upath.get(faceMsgContext, inPath);
        JSONArray jsonArray = obj instanceof List ? (obj instanceof JSONArray ? (JSONArray)obj : new JSONArray((List)((ArrayList)obj))) : JSONArray.parseArray((String)obj.toString());
        switch (method) {
            case JSONArray_size: {
                return this.doSizeMethod(faceMsgContext, iterator, jsonArray);
            }
            case JSONArray_add_object: 
            case JSONArray_add_index_object: {
                this.doAddMethod(faceMsgContext, iterator, jsonArray);
                return this.upath.put(faceMsgContext, inPath, jsonArray);
            }
            case JSONArray_get_index: {
                return this.doGetMethod(faceMsgContext, iterator, jsonArray);
            }
            case JSONArray_remove_object: 
            case JSONArray_remove_index: {
                this.doRemoveMethod(faceMsgContext, iterator, jsonArray);
                return this.upath.put(faceMsgContext, inPath, jsonArray);
            }
            case JSONArray_parseArray_text: 
            case JSONArray_parseArray_text_clazz: {
                return this.doParseArrayMethod(faceMsgContext, iterator);
            }
            case JSONArray_clear: {
                jsonArray.clear();
                return this.upath.put(faceMsgContext, inPath, jsonArray);
            }
        }
        throw new InterfaceException("\n\tJSONArray\u4e2d\u6ca1\u6709 " + method.getCode() + " \u65b9\u6cd5\u7684\u89e3\u6790\u65b9\u5f0f");
    }

    public <M> boolean doSizeMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONArray jsonArray) throws InterfaceException {
        if (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty()) && next.getName().equals(BaseTags.TAG_VALUATION.getCode())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), jsonArray.size());
            }
            throw new InterfaceException("\n\tJSONArray.size()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        throw new InterfaceException("\n\tJSONArray.size()\u65b9\u6cd5\u6267\u884c\u9519\u8bef: \u6ca1\u6709\u8d4b\u503c\u64cd\u4f5c! ");
    }

    public <M> boolean doAddMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONArray jsonArray) throws InterfaceException {
        int arg1Index = -1;
        Object arg1Obj = null;
        Object arg2Obj = null;
        boolean flag = Boolean.FALSE;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_INT.getCode())) {
                arg1Index = Integer.parseInt(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (arg1Index == -1 && next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                arg1Obj = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                jsonArray.add(arg1Obj);
                flag = Boolean.TRUE;
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                arg2Obj = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                jsonArray.add(arg1Index, arg2Obj);
                flag = Boolean.TRUE;
                continue;
            }
            throw new InterfaceException("\n\tJSONArray.add()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        if (Boolean.FALSE.equals(flag)) {
            throw new InterfaceException("\n\tJSONArray.add()\u65b9\u6cd5\u6ca1\u6709\u53c2\u6570\u6216\u8005\u53c2\u6570\u9519\u8bef!!\u8bf7\u68c0\u67e5 ");
        }
        return flag;
    }

    public <M> boolean doGetMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONArray jsonArray) throws InterfaceException {
        int index = -1;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_INT.getCode())) {
                index = Integer.parseInt(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), jsonArray.get(index));
            }
            throw new InterfaceException("\n\tJSONArray.get()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        throw new InterfaceException("\n\tJSONArray.get()\u65b9\u6cd5\u5931\u8d25: \u6ca1\u6709\u8fd4\u56de\u8d4b\u503c");
    }

    public <M> boolean doRemoveMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator, JSONArray jsonArray) throws InterfaceException {
        int argIndex = 0;
        Object argObj = null;
        Object returnObj = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_INT.getCode())) {
                argIndex = Integer.parseInt(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                returnObj = jsonArray.remove(argIndex);
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                argObj = GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                returnObj = jsonArray.remove(argObj);
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), returnObj);
            }
            throw new InterfaceException("\n\tJSONArray.remove()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        return Boolean.TRUE;
    }

    public <M> boolean doParseArrayMethod(FaceMsgContext<M> faceMsgContext, Iterator iterator) throws InterfaceException {
        String text = null;
        List returnObject = null;
        boolean flag = Boolean.FALSE;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (text == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                text = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_PARAM.getCode())) {
                returnObject = JSONArray.parseArray(text, GeneralUtils.getObjectByType(tagAttributes.getType(), tagAttributes.getInPath()).getClass());
                flag = Boolean.TRUE;
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                if (Boolean.FALSE.equals(flag)) {
                    returnObject = JSONArray.parseArray((String)text);
                }
                return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), returnObject);
            }
            throw new InterfaceException("\n\tJSONArray.parseArray()\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570: " + next.getName());
        }
        if (Boolean.FALSE.equals(flag)) {
            throw new InterfaceException("\n\tJSONArray.parseArray()\u65b9\u6cd5\u5931\u8d25: \u6ca1\u6709\u8fd4\u56de\u8d4b\u503c! ");
        }
        return flag;
    }
}

