/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.config.cluster;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.IdGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
public class AdminClusterConfig {
    private static final Logger log = LoggerFactory.getLogger(AdminClusterConfig.class);
    @Value(value="${ability.platform.admin.name:}")
    private String name;
    @Value(value="${ability.platform.admin.master:false}")
    private boolean master;
    @Value(value="${redis.hashTags:false}")
    private Boolean hashTags;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    private ServerProperties serverProperties;
    private List<String> coreHeart = Collections.synchronizedList(new ArrayList());

    @PostConstruct
    public void initName() {
        if (ObjectUtils.isEmpty((Object)this.name)) {
            String adminName;
            this.name = adminName = "admin-" + this.serverProperties.getPort() + "-" + new IdGenerator().randomUUID();
        }
    }

    public List<String> getCoreHeart() {
        if (Boolean.FALSE.equals(this.isMaster())) {
            this.coreHeart.clear();
            try {
                Object obj = this.cacheClient.get(this.constantBaseVersion.getWEB_NODES());
                Map nodes = new HashMap();
                if (!ObjectUtils.isEmpty((Object)obj)) {
                    nodes = GsonUtil.fromJson(obj.toString(), Map.class);
                }
                for (Map.Entry cluster : nodes.entrySet()) {
                    String clusterId = (String)cluster.getKey();
                    for (Object node : (List)cluster.getValue()) {
                        Map<String, Object> nodeInfo = GsonUtil.toObjectMap(GsonUtil.toJson(node));
                        String nodeIp = nodeInfo.get("nodeIp").toString();
                        String port = nodeInfo.get("port").toString();
                        ArrayList efficientNodes = new ArrayList();
                        efficientNodes.addAll(GsonUtil.fromList(GsonUtil.toJson(nodeInfo.get("efficientNodes")), Object[].class));
                        String baseNodeName = this.constantBaseVersion.getWEB_NODES_HEARTBEAT() + clusterId + "-" + nodeIp + "-" + port;
                        if (Boolean.FALSE.equals(this.hashTags)) {
                            baseNodeName = baseNodeName.replace("{", "").replace("}", "");
                        }
                        for (Object efficientNode : efficientNodes) {
                            Map<String, Object> efficientNodeInfo = GsonUtil.toObjectMap(GsonUtil.toJson(efficientNode));
                            String nodeName = baseNodeName + "-" + efficientNodeInfo.get("name");
                            this.coreHeart.add(nodeName);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.info("\u975e\u4e3b\u8282\u70b9\u4eceRedis\u83b7\u53d6web\u63a8\u9001\u901a\u9053\u5f02\u5e38\uff01{}" + e.toString());
            }
        }
        return this.coreHeart;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMaster() {
        return this.master;
    }

    public Boolean getHashTags() {
        return this.hashTags;
    }

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public ConstantBaseVersion getConstantBaseVersion() {
        return this.constantBaseVersion;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void setHashTags(Boolean hashTags) {
        this.hashTags = hashTags;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void setConstantBaseVersion(ConstantBaseVersion constantBaseVersion) {
        this.constantBaseVersion = constantBaseVersion;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setCoreHeart(List<String> coreHeart) {
        this.coreHeart = coreHeart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminClusterConfig)) {
            return false;
        }
        AdminClusterConfig other = (AdminClusterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isMaster() != other.isMaster()) {
            return false;
        }
        Boolean this$hashTags = this.getHashTags();
        Boolean other$hashTags = other.getHashTags();
        if (this$hashTags == null ? other$hashTags != null : !((Object)this$hashTags).equals(other$hashTags)) {
            return false;
        }
        CacheClient this$cacheClient = this.getCacheClient();
        CacheClient other$cacheClient = other.getCacheClient();
        if (this$cacheClient == null ? other$cacheClient != null : !this$cacheClient.equals(other$cacheClient)) {
            return false;
        }
        ConstantBaseVersion this$constantBaseVersion = this.getConstantBaseVersion();
        ConstantBaseVersion other$constantBaseVersion = other.getConstantBaseVersion();
        if (this$constantBaseVersion == null ? other$constantBaseVersion != null : !((Object)this$constantBaseVersion).equals(other$constantBaseVersion)) {
            return false;
        }
        ServerProperties this$serverProperties = this.getServerProperties();
        ServerProperties other$serverProperties = other.getServerProperties();
        if (this$serverProperties == null ? other$serverProperties != null : !this$serverProperties.equals(other$serverProperties)) {
            return false;
        }
        List<String> this$coreHeart = this.getCoreHeart();
        List<String> other$coreHeart = other.getCoreHeart();
        return !(this$coreHeart == null ? other$coreHeart != null : !((Object)this$coreHeart).equals(other$coreHeart));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdminClusterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isMaster() ? 79 : 97);
        Boolean $hashTags = this.getHashTags();
        result = result * 59 + ($hashTags == null ? 43 : ((Object)$hashTags).hashCode());
        CacheClient $cacheClient = this.getCacheClient();
        result = result * 59 + ($cacheClient == null ? 43 : $cacheClient.hashCode());
        ConstantBaseVersion $constantBaseVersion = this.getConstantBaseVersion();
        result = result * 59 + ($constantBaseVersion == null ? 43 : ((Object)$constantBaseVersion).hashCode());
        ServerProperties $serverProperties = this.getServerProperties();
        result = result * 59 + ($serverProperties == null ? 43 : $serverProperties.hashCode());
        List<String> $coreHeart = this.getCoreHeart();
        result = result * 59 + ($coreHeart == null ? 43 : ((Object)$coreHeart).hashCode());
        return result;
    }

    public String toString() {
        return "AdminClusterConfig(name=" + this.getName() + ", master=" + this.isMaster() + ", hashTags=" + this.getHashTags() + ", cacheClient=" + this.getCacheClient() + ", constantBaseVersion=" + this.getConstantBaseVersion() + ", serverProperties=" + this.getServerProperties() + ", coreHeart=" + this.getCoreHeart() + ")";
    }
}

