/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.lang.ObjectId;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    private long workerId = 0L;
    private Snowflake snowflake = IdUtil.createSnowflake((long)this.workerId, (long)1L);

    @PostConstruct
    void init() {
        try {
            this.workerId = NetUtil.ipv4ToLong((String)NetUtil.getLocalhostStr());
            log.info("\u5f53\u524d\u673a\u5668 workerId: {}", (Object)this.workerId);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u673a\u5668 ID \u5931\u8d25", (Throwable)e);
            this.workerId = NetUtil.getLocalhost().hashCode();
            log.info("\u5f53\u524d\u673a\u5668 workerId: {}", (Object)this.workerId);
        }
    }

    public synchronized String batchId(int tenantId, int module) {
        String prefix = DateTime.now().toString("yyyyMMddHHmmssSSS");
        return prefix + tenantId + module + RandomUtil.randomNumbers((int)3);
    }

    @Deprecated
    public synchronized String getBatchId(int tenantId, int module) {
        return this.batchId(tenantId, module);
    }

    public String simpleUUID() {
        return IdUtil.simpleUUID();
    }

    public String randomUUID() {
        return IdUtil.randomUUID();
    }

    public synchronized long snowflakeId() {
        return this.snowflake.nextId();
    }

    public synchronized long snowflakeId(long workerId, long dataCenterId) {
        Snowflake snowflake = IdUtil.createSnowflake((long)workerId, (long)dataCenterId);
        return snowflake.nextId();
    }

    public String objectId() {
        return ObjectId.next();
    }
}

