/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.atp.auth.jwt;

import com.ohaotian.atp.auth.exception.InvalidJwtAuthenticationException;
import com.ohaotian.atp.auth.jwt.JwtTokenProvider;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JwtTokenAuthenticationFilter
extends GenericFilterBean {
    private final JwtTokenProvider jwtTokenProvider;

    public JwtTokenAuthenticationFilter(JwtTokenProvider jwtTokenProvider) {
        this.jwtTokenProvider = jwtTokenProvider;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Authentication auth;
            String token = this.jwtTokenProvider.resolveToken(request);
            if (token != null && this.jwtTokenProvider.validateToken(token) && (auth = this.jwtTokenProvider.getAuthentication(token)) != null) {
                SecurityContextHolder.getContext().setAuthentication(auth);
            }
        }
        catch (InvalidJwtAuthenticationException e) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write("{\"code\":\"1\",\"message\":\"token\u65e0\u6548\"}");
            response.getWriter().flush();
            return;
        }
        catch (Exception e) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write("{\"code\":\"1\",\"message\":\"token\u9a8c\u8bc1\u5f02\u5e38\"}");
            response.getWriter().flush();
            return;
        }
        filterChain.doFilter(req, res);
    }
}

