/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.atp.auth.security;

import com.ohaotian.atp.auth.security.User;
import com.ohaotian.atp.base.util.MD5Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepository {
    private static final Logger log = LoggerFactory.getLogger(UserRepository.class);
    private static final Map<String, User> ALL_USERS = new HashMap<String, User>();
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Value(value="${ability.auth.admin.account:}")
    private String adminAccount;

    @PostConstruct
    protected void init() {
        String[] account = this.adminAccount.split("@");
        try {
            ALL_USERS.put(account[0], new User(account[0], this.passwordEncoder.encode((CharSequence)MD5Util.md5((String)account[1])), Collections.singletonList("ROLE_ADMIN")));
        }
        catch (Exception e) {
            log.error("admin<{}>\u7528\u6237\u521b\u5efa\u5931\u8d25\uff01", (Object)this.adminAccount);
            e.printStackTrace();
        }
    }

    public Optional<User> findByUsername(String username) {
        return Optional.ofNullable(ALL_USERS.get(username));
    }
}

