/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginContainHpartyCheckMapper;
import com.ohaotian.plugin.mapper.ContainHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginContainHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.ContainHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTokenListTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTokenTaskReqBO;
import com.ohaotian.plugin.model.bo.rsp.ResponseVO;
import com.ohaotian.plugin.model.po.ContainHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginContainHpartyCheckPO;
import com.ohaotian.plugin.service.ContainHpartyCheckService;
import com.ohaotian.plugin.task.ContainTokenRefreshLogic;
import com.ohaotian.plugin.task.ContainTokenRefreshTask;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.redis.PubSubRedisBaseClient;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.retry.handler.QuartzScheduleManager;
import com.ohaotian.portalcommon.util.SqlUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContainHpartyCheckServiceImpl
implements ContainHpartyCheckService {
    private Logger log = LogManager.getLogger(ContainHpartyCheckServiceImpl.class);
    @Resource
    private PluginContainHpartyCheckMapper pluginContainHpartyCheckMapper;
    @Resource
    private ContainHpartyCheckTokenMapper containHpartyCheckTokenMapper;
    @Resource
    private AbilityPluginContainHpartyCheckMapper abilityPluginContainHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    QuartzScheduleManager quartzScheduleManager;
    @Autowired
    PubSubRedisBaseClient pubSubRedisBaseClient;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginAPI;

    @Override
    public RspBO executeAll(PluginContainHpartyCheckTaskReqBO pluginContainHpartyCheckTaskReqBO) {
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryByPluginId(pluginContainHpartyCheckTaskReqBO.getPluginId());
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = new ContainHpartyCheckTokenPO();
        containHpartyCheckTokenPO.setPluginId(pluginContainHpartyCheckTaskReqBO.getPluginId());
        List<ContainHpartyCheckTokenPO> containHpartyCheckTokenPOS = this.containHpartyCheckTokenMapper.queryByCond(containHpartyCheckTokenPO);
        ((Stream)containHpartyCheckTokenPOS.stream().parallel()).filter(multiHpartyCheckToken -> 1 == multiHpartyCheckToken.getIsRunning() || 2 == multiHpartyCheckToken.getIsRunning()).forEach(multiToken -> ContainTokenRefreshLogic.doLogic(this.containHpartyCheckTokenMapper, this.abilityPluginContainHpartyCheckMapper, this.abilityPluginDeployApi, this.pubSubRedisBaseClient, pluginContainHpartyCheckPO, multiToken, this.cacheClient, this.pluginAPI));
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO execute(PluginContainHpartyCheckTokenTaskReqBO pluginContainHpartyCheckTokenTaskReqBO) {
        ContainHpartyCheckTokenPO jdToken = this.containHpartyCheckTokenMapper.queryByHpartyCheckTokenId(pluginContainHpartyCheckTokenTaskReqBO.getHpartyCheckTokenId());
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        ContainTokenRefreshLogic.doLogic(this.containHpartyCheckTokenMapper, this.abilityPluginContainHpartyCheckMapper, this.abilityPluginDeployApi, this.pubSubRedisBaseClient, pluginContainHpartyCheckPO, jdToken, this.cacheClient, this.pluginAPI);
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO start(PluginContainHpartyCheckTaskReqBO pluginContainHpartyCheckTaskReqBO) {
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryByPluginId(pluginContainHpartyCheckTaskReqBO.getPluginId());
        Boolean aBoolean = this.quartzScheduleManager.checkJob(String.valueOf(pluginContainHpartyCheckPO.getPluginId()));
        if (!aBoolean.booleanValue()) {
            pluginContainHpartyCheckPO.setTaskSwitch(1);
            this.pluginContainHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginContainHpartyCheckPO);
            this.quartzScheduleManager.addJob(String.valueOf(pluginContainHpartyCheckPO.getPluginId()), ContainTokenRefreshTask.class, pluginContainHpartyCheckPO.getRefreshInterval(), (Object)pluginContainHpartyCheckPO.getPluginId());
        } else {
            pluginContainHpartyCheckPO.setTaskSwitch(1);
            this.pluginContainHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginContainHpartyCheckPO);
            this.quartzScheduleManager.removeJob(String.valueOf(pluginContainHpartyCheckPO.getPluginId()));
            this.quartzScheduleManager.addJob(String.valueOf(pluginContainHpartyCheckPO.getPluginId()), ContainTokenRefreshTask.class, pluginContainHpartyCheckPO.getRefreshInterval(), (Object)pluginContainHpartyCheckPO.getPluginId());
        }
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO stop(PluginContainHpartyCheckTaskReqBO pluginContainHpartyCheckTaskReqBO) {
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryByPluginId(pluginContainHpartyCheckTaskReqBO.getPluginId());
        Boolean aBoolean = this.quartzScheduleManager.checkJob(String.valueOf(pluginContainHpartyCheckPO.getPluginId()));
        if (aBoolean.booleanValue()) {
            pluginContainHpartyCheckPO.setTaskSwitch(0);
            this.pluginContainHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginContainHpartyCheckPO);
            this.quartzScheduleManager.removeJob(String.valueOf(pluginContainHpartyCheckPO.getPluginId()));
        } else {
            pluginContainHpartyCheckPO.setTaskSwitch(0);
            this.pluginContainHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginContainHpartyCheckPO);
        }
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO getPluginExtInfoList(PluginContainHpartyCheckTokenReqBO pluginContainHpartyCheckTokenReqBO) {
        StringBuilder order = new StringBuilder();
        if (pluginContainHpartyCheckTokenReqBO.getSortName() != null) {
            order.append(pluginContainHpartyCheckTokenReqBO.getSortName());
            if (pluginContainHpartyCheckTokenReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(pluginContainHpartyCheckTokenReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = PageMethod.startPage((int)pluginContainHpartyCheckTokenReqBO.getPageNo(), (int)pluginContainHpartyCheckTokenReqBO.getPageSize(), (String)order.toString());
        List<ContainHpartyCheckTokenPO> containHpartyCheckTokenPOS = this.containHpartyCheckTokenMapper.queryByPluginId(pluginContainHpartyCheckTokenReqBO.getPluginId());
        RspPage rspPage = new RspPage(Integer.valueOf(pluginContainHpartyCheckTokenReqBO.getPageSize()), Integer.valueOf(pluginContainHpartyCheckTokenReqBO.getPageNo()), containHpartyCheckTokenPOS, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        this.log.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @Override
    public ResponseVO put(ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        List<PluginContainHpartyCheckPO> pluginContainHpartyCheckPOS = this.pluginContainHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginContainHpartyCheckPOS.get(0).getPluginId();
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = this.containHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, containHpartyCheckTokenReqBO.getOrgId());
        if (containHpartyCheckTokenPO != null) {
            containHpartyCheckTokenPO = (ContainHpartyCheckTokenPO)BeanMapper.map((Object)containHpartyCheckTokenReqBO, ContainHpartyCheckTokenPO.class);
            containHpartyCheckTokenPO.setUpdateTime(new Date());
            containHpartyCheckTokenPO.setIsRunning(1);
            this.containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
        } else {
            containHpartyCheckTokenPO = (ContainHpartyCheckTokenPO)BeanMapper.map((Object)containHpartyCheckTokenReqBO, ContainHpartyCheckTokenPO.class);
            containHpartyCheckTokenPO.setPluginId(pluginId);
            containHpartyCheckTokenPO.setCreateTime(new Date());
            containHpartyCheckTokenPO.setOrgId(containHpartyCheckTokenReqBO.getOrgId());
            containHpartyCheckTokenPO.setCompanyName(containHpartyCheckTokenReqBO.getCompanyName());
            containHpartyCheckTokenPO.setIsRunning(1);
            this.containHpartyCheckTokenMapper.insertSelective(containHpartyCheckTokenPO);
        }
        ContainHpartyCheckTokenPO checkTokenPO = this.containHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, containHpartyCheckTokenReqBO.getOrgId());
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryByPluginId(checkTokenPO.getPluginId());
        ContainTokenRefreshLogic.doLogic(this.containHpartyCheckTokenMapper, this.abilityPluginContainHpartyCheckMapper, this.abilityPluginDeployApi, this.pubSubRedisBaseClient, pluginContainHpartyCheckPO, checkTokenPO, this.cacheClient, this.pluginAPI);
        return ResponseVO.success();
    }

    @Override
    public ResponseVO modify(ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        List<PluginContainHpartyCheckPO> pluginContainHpartyCheckPOS = this.pluginContainHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginContainHpartyCheckPOS.get(0).getPluginId();
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = this.containHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, containHpartyCheckTokenReqBO.getOrgId());
        if (containHpartyCheckTokenPO != null) {
            containHpartyCheckTokenPO = (ContainHpartyCheckTokenPO)BeanMapper.map((Object)containHpartyCheckTokenReqBO, ContainHpartyCheckTokenPO.class);
            containHpartyCheckTokenPO.setUpdateTime(new Date());
            this.containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
        } else {
            containHpartyCheckTokenPO = (ContainHpartyCheckTokenPO)BeanMapper.map((Object)containHpartyCheckTokenReqBO, ContainHpartyCheckTokenPO.class);
            containHpartyCheckTokenPO.setPluginId(pluginId);
            containHpartyCheckTokenPO.setCreateTime(new Date());
            containHpartyCheckTokenPO.setOrgId(containHpartyCheckTokenReqBO.getOrgId());
            containHpartyCheckTokenPO.setCompanyName(containHpartyCheckTokenReqBO.getCompanyName());
            containHpartyCheckTokenPO.setIsRunning(1);
            this.containHpartyCheckTokenMapper.insertSelective(containHpartyCheckTokenPO);
        }
        ContainHpartyCheckTokenPO checkTokenPO = this.containHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, containHpartyCheckTokenReqBO.getOrgId());
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryByPluginId(checkTokenPO.getPluginId());
        ContainTokenRefreshLogic.doLogic(this.containHpartyCheckTokenMapper, this.abilityPluginContainHpartyCheckMapper, this.abilityPluginDeployApi, this.pubSubRedisBaseClient, pluginContainHpartyCheckPO, checkTokenPO, this.cacheClient, this.pluginAPI);
        return ResponseVO.success();
    }

    @Override
    public ResponseVO delete(ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        List<PluginContainHpartyCheckPO> pluginContainHpartyCheckPOS = this.pluginContainHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginContainHpartyCheckPOS.get(0).getPluginId();
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = this.containHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, containHpartyCheckTokenReqBO.getOrgId());
        if (containHpartyCheckTokenPO != null) {
            containHpartyCheckTokenPO.setUpdateTime(new Date());
            containHpartyCheckTokenPO.setIsRunning(3);
            this.containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
        }
        return ResponseVO.success();
    }

    @Override
    public RspBO checkIn(PluginContainHpartyCheckTokenListTaskReqBO pluginContainHpartyCheckTokenListTaskReqBO) {
        pluginContainHpartyCheckTokenListTaskReqBO.getHpartyCheckTokenIds().stream().forEach(k -> {
            ContainHpartyCheckTokenPO containHpartyCheckTokenPO = new ContainHpartyCheckTokenPO();
            containHpartyCheckTokenPO.setIsRunning(1);
            containHpartyCheckTokenPO.setHpartyCheckTokenId((Long)k);
            this.containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
        });
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO checkOut(PluginContainHpartyCheckTokenListTaskReqBO pluginContainHpartyCheckTokenListTaskReqBO) {
        pluginContainHpartyCheckTokenListTaskReqBO.getHpartyCheckTokenIds().stream().forEach(k -> {
            ContainHpartyCheckTokenPO containHpartyCheckTokenPO = new ContainHpartyCheckTokenPO();
            containHpartyCheckTokenPO.setIsRunning(0);
            containHpartyCheckTokenPO.setHpartyCheckTokenId((Long)k);
            this.containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
        });
        return RspBO.success((Object)true);
    }
}

