/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.config;

import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.stereotype.Component;

@Component
public class QuartzScheduleManager {
    private static final Logger log = LogManager.getLogger(QuartzScheduleManager.class);
    @Resource
    private Scheduler scheduler;
    private static String JOB_GROUP_NAME = "JOB_GROUP_DEFAULT";
    private static String TRIGGER_GROUP_NAME = "TRIGGER_GROUP_DEFAULT";

    public void addJob(String jobName, Class<? extends Job> jobClass, String cron, Object parameter) {
        try {
            TriggerKey triggerKey_old = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            CronTrigger trigger_old = (CronTrigger)this.scheduler.getTrigger(triggerKey_old);
            if (trigger_old != null) {
                return;
            }
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, JOB_GROUP_NAME).build();
            jobDetail.getJobDataMap().put("parameterData", parameter);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!this.scheduler.isShutdown()) {
                this.scheduler.start();
                log.info("\u65b0\u5efa\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8,\u4efb\u52a1\u540d\u79f0: {}", (Object)jobName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void modifyJob(String jobName, Class<? extends Job> jobClass, String cron, Object parameter) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            this.removeJob(jobName);
            this.addJob(jobName, jobClass, cron, parameter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeJob(String jobName) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME);
            this.scheduler.pauseTrigger(triggerKey);
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(jobKey);
            log.info("\u5b9a\u65f6\u4efb\u52a1\u79fb\u9664,\u4efb\u52a1\u540d\u79f0: {}", (Object)jobName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean checkJob(String jobName) {
        try {
            TriggerKey triggerKey_old = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            CronTrigger trigger_old = (CronTrigger)this.scheduler.getTrigger(triggerKey_old);
            if (trigger_old != null) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

