/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.ContainHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginContainHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.ContainHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTokenListTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginContainHpartyCheckTokenTaskReqBO;
import com.ohaotian.plugin.model.bo.rsp.PluginContainHpartyCheckRspBO;
import com.ohaotian.plugin.model.bo.rsp.ResponseVO;
import com.ohaotian.plugin.model.po.ContainHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginContainHpartyCheckPO;
import com.ohaotian.plugin.service.ContainHpartyCheckService;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/containTokenHPC"})
public class ContainHpartyCheckController {
    private static Logger logger = LogManager.getLogger(ContainHpartyCheckController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AppAPI appAPI;
    @Resource
    RegionAPI regionAPI;
    @Resource
    PluginContainHpartyCheckMapper pluginContainHpartyCheckMapper;
    @Resource
    ContainHpartyCheckTokenMapper containHpartyCheckTokenMapper;
    @Resource
    private ContainHpartyCheckService containHpartyCheckService;
    private static final String INPUT = "\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}";
    private static final String OUTPUT = "\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}";

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug(INPUT, (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug(OUTPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO getPluginExtInfo(@RequestBody PluginContainHpartyCheckReqBO pluginContainHpartyCheckReqBO) {
        logger.debug(INPUT, (Object)pluginContainHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginContainHpartyCheckReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = new PluginContainHpartyCheckPO();
        pluginContainHpartyCheckPO.setPluginId(pluginContainHpartyCheckReqBO.getPluginId());
        pluginContainHpartyCheckPO = this.pluginContainHpartyCheckMapper.queryLimitOne(pluginContainHpartyCheckPO);
        PluginContainHpartyCheckRspBO pluginContainHpartyCheckRspBO = (PluginContainHpartyCheckRspBO)BeanMapper.map((Object)pluginContainHpartyCheckPO, PluginContainHpartyCheckRspBO.class);
        return RspBO.success((Object)pluginContainHpartyCheckRspBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody PluginContainHpartyCheckReqBO pluginContainHpartyCheckReqBO) {
        logger.debug(INPUT, (Object)pluginContainHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginContainHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginContainHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (pluginContainHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        PluginContainHpartyCheckPO pluginContainHpartyCheckPO = (PluginContainHpartyCheckPO)BeanMapper.map((Object)pluginContainHpartyCheckReqBO, PluginContainHpartyCheckPO.class);
        this.pluginContainHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginContainHpartyCheckPO);
        RspBO rspBO = RspBO.success(null);
        logger.debug(OUTPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/modTokenExt"})
    @BusiResponseBody
    public RspBO modTokenExt(@RequestBody ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        logger.debug(INPUT, (Object)containHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getHpartyCheckTokenId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getCompanyName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7\u540d");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getOrgId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7Id");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getAppKey())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9aappKey");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getReqMsg())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587");
        }
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = (ContainHpartyCheckTokenPO)BeanMapper.map((Object)containHpartyCheckTokenReqBO, ContainHpartyCheckTokenPO.class);
        containHpartyCheckTokenPO.setUpdateTime(new Date());
        this.containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
        RspBO rspBO = RspBO.success(null);
        logger.debug(OUTPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/addTokenExt"})
    @BusiResponseBody
    public RspBO addTokenExt(@RequestBody ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        logger.debug(INPUT, (Object)containHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getAppKey())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9aappKey");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getReqMsg())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getCompanyName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7\u540d");
        }
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getOrgId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7Id");
        }
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = (ContainHpartyCheckTokenPO)BeanMapper.map((Object)containHpartyCheckTokenReqBO, ContainHpartyCheckTokenPO.class);
        ContainHpartyCheckTokenPO judgePo = new ContainHpartyCheckTokenPO();
        judgePo.setOrgId(containHpartyCheckTokenPO.getOrgId());
        judgePo.setAppKey(containHpartyCheckTokenPO.getAppKey());
        ContainHpartyCheckTokenPO judge = this.containHpartyCheckTokenMapper.queryLimitOne(judgePo);
        if (judge == null) {
            containHpartyCheckTokenPO.setCreateTime(new Date());
            this.containHpartyCheckTokenMapper.insertSelective(containHpartyCheckTokenPO);
            RspBO rspBO = RspBO.success(null);
            logger.debug(OUTPUT, (Object)rspBO);
            return rspBO;
        }
        return RspBO.error((String)"appKey&&orgId \u5df2\u5b58\u5728");
    }

    @PostMapping(value={"/delTokenExt"})
    @BusiResponseBody
    public RspBO delTokenExt(@RequestBody ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        logger.debug(INPUT, (Object)containHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getHpartyCheckTokenId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        ContainHpartyCheckTokenPO containHpartyCheckTokenPO = new ContainHpartyCheckTokenPO();
        containHpartyCheckTokenPO.setHpartyCheckTokenId(containHpartyCheckTokenReqBO.getHpartyCheckTokenId());
        ContainHpartyCheckTokenPO judge = this.containHpartyCheckTokenMapper.queryLimitOne(containHpartyCheckTokenPO);
        logger.debug((Object)judge);
        if (judge == null) {
            return RspBO.error((String)"\u4e0d\u5b58\u5728");
        }
        this.containHpartyCheckTokenMapper.deleteHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO.getHpartyCheckTokenId());
        RspBO rspBO = RspBO.success(null);
        logger.debug(OUTPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"executeAll"})
    @BusiResponseBody
    public RspBO executeAll(@RequestBody PluginContainHpartyCheckTaskReqBO pluginContainHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginContainHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u63d2\u4ef6id");
        }
        return this.containHpartyCheckService.executeAll(pluginContainHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"execute"})
    @BusiResponseBody
    public RspBO execute(@RequestBody PluginContainHpartyCheckTokenTaskReqBO pluginContainHpartyCheckTokenTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginContainHpartyCheckTokenTaskReqBO.getHpartyCheckTokenId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atokenid");
        }
        return this.containHpartyCheckService.execute(pluginContainHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"start"})
    @BusiResponseBody
    public RspBO start(@RequestBody PluginContainHpartyCheckTaskReqBO pluginContainHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginContainHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u63d2\u4ef6id");
        }
        return this.containHpartyCheckService.start(pluginContainHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"stop"})
    @BusiResponseBody
    public RspBO stop(@RequestBody PluginContainHpartyCheckTaskReqBO pluginContainHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginContainHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u63d2\u4ef6id");
        }
        return this.containHpartyCheckService.stop(pluginContainHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"modifycompanymsg"})
    @BusiResponseBody
    public ResponseVO modifycompanymsg(@RequestBody ContainHpartyCheckTokenReqBO containHpartyCheckTokenReqBO) {
        if (StringUtils.isEmpty((Object)containHpartyCheckTokenReqBO.getOrgId())) {
            return ResponseVO.error("\u672a\u6307\u5b9aOrgid");
        }
        if (StringUtils.isEmpty((Object)((Object)containHpartyCheckTokenReqBO.getType()))) {
            return ResponseVO.error("\u672a\u6307\u5b9atype");
        }
        switch (containHpartyCheckTokenReqBO.getType()) {
            case put: {
                return this.containHpartyCheckService.put(containHpartyCheckTokenReqBO);
            }
            case delete: {
                return this.containHpartyCheckService.delete(containHpartyCheckTokenReqBO);
            }
            case modify: {
                return this.containHpartyCheckService.modify(containHpartyCheckTokenReqBO);
            }
        }
        throw new ZTBusinessException("\u672a\u6307\u5b9atype");
    }

    @PostMapping(value={"checkIn"})
    @BusiResponseBody
    public RspBO checkIn(@RequestBody PluginContainHpartyCheckTokenListTaskReqBO pluginMultiHpartyCheckTokenTaskReqBO) {
        if (pluginMultiHpartyCheckTokenTaskReqBO == null || pluginMultiHpartyCheckTokenTaskReqBO.getHpartyCheckTokenIds().size() < 1) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atokenid");
        }
        return this.containHpartyCheckService.checkIn(pluginMultiHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"checkOut"})
    @BusiResponseBody
    public RspBO checkOut(@RequestBody PluginContainHpartyCheckTokenListTaskReqBO pluginMultiHpartyCheckTokenTaskReqBO) {
        if (pluginMultiHpartyCheckTokenTaskReqBO == null || pluginMultiHpartyCheckTokenTaskReqBO.getHpartyCheckTokenIds().size() < 1) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atokenid");
        }
        return this.containHpartyCheckService.checkOut(pluginMultiHpartyCheckTokenTaskReqBO);
    }
}

