/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.alibaba.excel.metadata.Sheet;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.AbilityPluginG3PlusHpartyCheckMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.po.AbilityPluginG3PlusHpartyCheckPO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckTokenPO;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@PluginTypeHandlerType(value="g3PlusHPC", position=ExtensionPointPositionEnum.EXPORT_POSITION)
public class G3PlusHpartyCheckExportHandler
extends AbstractPluginHandler<List<ExportBO>> {
    private static final Logger logger = LogManager.getLogger(G3PlusHpartyCheckExportHandler.class);
    @Resource
    AbilityPluginG3PlusHpartyCheckMapper abilityPluginG3PlusHpartyCheckMapper;
    @Resource
    G3PlusHpartyCheckTokenMapper g3PlusHpartyCheckTokenMapper;

    public RspBO<List<ExportBO>> handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u63d2\u4ef6\u6269\u5c55\u8868\u5bfc\u51fa");
        ArrayList exportBOList = null;
        List abilityPluginDeployIds = abilityPluginReqBO.getAbilityPluginDeployIds();
        List<AbilityPluginG3PlusHpartyCheckPO> abilityPluginG3PlusHpartyCheckPOList = this.abilityPluginG3PlusHpartyCheckMapper.queryPluginByPluginDeployIds(abilityPluginDeployIds);
        if (!CollectionUtils.isEmpty(abilityPluginG3PlusHpartyCheckPOList)) {
            exportBOList = Lists.newArrayList();
            ArrayList provideDeployRows = Lists.newArrayList();
            Sheet sheet = new Sheet(1, 3);
            sheet.setSheetName("ability_plugin_g3plus_hparty_check");
            sheet.setAutoWidth(Boolean.TRUE);
            ArrayList header = Lists.newArrayList();
            ArrayList strs = Lists.newArrayList();
            strs.add("abilityPluginHpartyCheckId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("abilityPluginDeployId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("hpartyCheckTokenId");
            header.add(strs);
            sheet.setHead((List)header);
            for (AbilityPluginG3PlusHpartyCheckPO abilityPluginG3PlusHpartyCheckPO : abilityPluginG3PlusHpartyCheckPOList) {
                ArrayList objs = Lists.newArrayList();
                objs.add(abilityPluginG3PlusHpartyCheckPO.getAbilityPluginHpartyCheckId());
                objs.add(abilityPluginG3PlusHpartyCheckPO.getAbilityPluginDeployId());
                objs.add(abilityPluginG3PlusHpartyCheckPO.getHpartyCheckTokenId());
                provideDeployRows.add(objs);
            }
            ExportBO exportBO = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
            exportBOList.add(exportBO);
            List<Long> hpartyCheckTokenIds = abilityPluginG3PlusHpartyCheckPOList.stream().map(AbilityPluginG3PlusHpartyCheckPO::getHpartyCheckTokenId).collect(Collectors.toList());
            List<G3PlusHpartyCheckTokenPO> g3PlusHpartyCheckTokenPOList = this.g3PlusHpartyCheckTokenMapper.queryByHpartyCheckTokenIds(hpartyCheckTokenIds);
            sheet = new Sheet(2, 3);
            sheet.setSheetName("hparty_check_token");
            sheet.setAutoWidth(Boolean.TRUE);
            header = Lists.newArrayList();
            strs = Lists.newArrayList();
            strs.add("hpartyCheckTokenId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("pluginId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("clientId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("clientSecret");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("userName");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("userPassword");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("tokenPath");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("accessToken");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("expiresIn");
            header.add(strs);
            sheet.setHead((List)header);
            provideDeployRows = Lists.newArrayList();
            for (G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO : g3PlusHpartyCheckTokenPOList) {
                ArrayList objs = Lists.newArrayList();
                objs.add(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                objs.add(g3PlusHpartyCheckTokenPO.getPluginId());
                objs.add(g3PlusHpartyCheckTokenPO.getClientId());
                objs.add(g3PlusHpartyCheckTokenPO.getClientSecret());
                objs.add(g3PlusHpartyCheckTokenPO.getUserName());
                objs.add(g3PlusHpartyCheckTokenPO.getUserPassword());
                objs.add(g3PlusHpartyCheckTokenPO.getTokenPath());
                objs.add(g3PlusHpartyCheckTokenPO.getAccessToken());
                objs.add(g3PlusHpartyCheckTokenPO.getExpiresIn());
                provideDeployRows.add(objs);
            }
            logger.debug("G3PlusHpartyCheckExportHandler.handleGetAbilityPlugin strs={}", (Object)strs);
            logger.debug("G3PlusHpartyCheckExportHandler.handleGetAbilityPlugin header={}", (Object)header);
            logger.debug("G3PlusHpartyCheckExportHandler.handleGetAbilityPlugin sheet={}", (Object)sheet);
            logger.debug("G3PlusHpartyCheckExportHandler.handleGetAbilityPlugin provideDeployRows={}", (Object)provideDeployRows);
            ExportBO hpartyCheckToken = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
            exportBOList.add(hpartyCheckToken);
        }
        return RspBO.success((Object)exportBOList);
    }
}

