/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.config.QuartzG3PlusScheduleManager;
import com.ohaotian.plugin.mapper.AbilityPluginG3PlusHpartyCheckMapper;
import com.ohaotian.plugin.mapper.G3PlusAbilityProvideDeployMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginG3PlusHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.AbilityPluginG3PlusHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.req.PluginG3PlusHpartyCheckReqBO;
import com.ohaotian.plugin.model.po.AbilityPluginG3PlusHpartyCheckPO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginG3PlusHpartyCheckPO;
import com.ohaotian.plugin.model.vo.G3PlusHpartyCheckTokenVO;
import com.ohaotian.plugin.task.G3PLusTokenRefreshLogic;
import com.ohaotian.plugin.task.G3PlusTokenRefreshTask;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.AbilityPluginRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.QryPluginJsonService;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@PluginTypeHandlerType(value="g3PlusHPC", position=ExtensionPointPositionEnum.ABILITY_POSITION)
public class AbilityG3PlusHpartyCheckHandler
extends AbstractPluginHandler<Object> {
    private static final Logger logger = LogManager.getLogger(AbilityG3PlusHpartyCheckHandler.class);
    private static final String URL = "/ability/updatePluginG3PlusHpartyCheck";
    private static final String TITLE = "\u843d\u5730\u6821\u9a8c\u7ed1\u5b9a\u5173\u7cfb\u6269\u5c55\u4fe1\u606f";
    private static final String COMPONENT_TYPE = "plugin-binding-luodi";
    @Resource
    private QryPluginJsonService qryPluginJsonService;
    @Value(value="classpath:data/ability-plugin-hparty-check.json")
    private org.springframework.core.io.Resource hpartyCheckJson;
    @Resource
    AbilityPluginG3PlusHpartyCheckMapper abilityPluginG3PlusHpartyCheckMapper;
    @Resource
    PluginG3PlusHpartyCheckMapper pluginG3PlusHpartyCheckMapper;
    @Resource
    G3PlusAbilityProvideDeployMapper g3PlusAbilityProvideDeployMapper;
    @Resource
    G3PlusHpartyCheckTokenMapper g3PlusHpartyCheckTokenMapper;
    @Resource
    QuartzG3PlusScheduleManager quartzG3PlusScheduleManager;
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    G3PlusHpartyCheckAppendMapper g3PlusHpartyCheckAppendMapper;
    @Resource
    CacheClient cacheClient;

    @Transactional
    public RspBO handleAdd(Object object) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u5904\u7406\u63d2\u4ef6\u4fdd\u5b58\u64cd\u4f5c");
        try {
            AbilityPluginG3PlusHpartyCheckPO abilityPluginG3PlusHpartyCheckPO;
            Map objectMap = (Map)object;
            Long abilityPluginDeployId = Long.parseLong(objectMap.get("abilityPluginDeployId") + "");
            Long pluginId = Long.parseLong(objectMap.get("pluginId") + "");
            PluginG3PlusHpartyCheckPO pluginG3PlusHpartyCheckPO = new PluginG3PlusHpartyCheckPO();
            pluginG3PlusHpartyCheckPO.setPluginId(pluginId);
            pluginG3PlusHpartyCheckPO = this.pluginG3PlusHpartyCheckMapper.queryLimitOne(pluginG3PlusHpartyCheckPO);
            G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = this.isExist(pluginId, pluginG3PlusHpartyCheckPO.getClientId(), pluginG3PlusHpartyCheckPO.getClientSecret(), pluginG3PlusHpartyCheckPO.getUserName(), pluginG3PlusHpartyCheckPO.getUserPassword(), pluginG3PlusHpartyCheckPO.getTokenPath());
            if (g3PlusHpartyCheckTokenPO == null) {
                g3PlusHpartyCheckTokenPO = (G3PlusHpartyCheckTokenPO)BeanMapper.map((Object)pluginG3PlusHpartyCheckPO, G3PlusHpartyCheckTokenPO.class);
                g3PlusHpartyCheckTokenPO.setIsRunning(1);
                this.g3PlusHpartyCheckTokenMapper.insertSelective(g3PlusHpartyCheckTokenPO);
                abilityPluginG3PlusHpartyCheckPO = new AbilityPluginG3PlusHpartyCheckPO();
                abilityPluginG3PlusHpartyCheckPO.setAbilityPluginDeployId(abilityPluginDeployId);
                abilityPluginG3PlusHpartyCheckPO.setHpartyCheckTokenId(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginG3PlusHpartyCheckMapper.insertSelective(abilityPluginG3PlusHpartyCheckPO);
            } else {
                abilityPluginG3PlusHpartyCheckPO = new AbilityPluginG3PlusHpartyCheckPO();
                abilityPluginG3PlusHpartyCheckPO.setAbilityPluginDeployId(abilityPluginDeployId);
                abilityPluginG3PlusHpartyCheckPO.setHpartyCheckTokenId(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginG3PlusHpartyCheckMapper.insertSelective(abilityPluginG3PlusHpartyCheckPO);
            }
            if (pluginG3PlusHpartyCheckPO.getTaskSwitch().equals(Constants.Switch.ON) && !this.quartzG3PlusScheduleManager.checkJob(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId() + "").booleanValue()) {
                G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO = this.g3PlusHpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                G3PLusTokenRefreshLogic.doLogic(this.g3PlusHpartyCheckTokenMapper, this.abilityPluginG3PlusHpartyCheckMapper, this.g3PlusAbilityProvideDeployMapper, this.g3PlusHpartyCheckAppendMapper, this.cacheClient, g3PlusHpartyCheckTokenVO, this.pluginAPI);
                this.startTask(g3PlusHpartyCheckTokenVO);
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u83b7\u53d6\u80fd\u529b\u843d\u5730\u6821\u9a8c\u63d2\u4ef6\u4fe1\u606f");
        logger.debug("\u67e5\u8be2G3PlusHpartyCheck\u63d2\u4ef6\u4fe1\u606f");
        String template = this.qryPluginJsonService.getAbilityPlugin(abilityPluginReqBO, this.hpartyCheckJson);
        HashMap jsonMap = Maps.newHashMap();
        jsonMap.put("pluginName", abilityPluginReqBO.getPluginName());
        jsonMap.put("abilityName", abilityPluginReqBO.getAbilityName());
        if (!StringUtils.isEmpty((Object)abilityPluginReqBO.getAbilityPluginDeployId())) {
            AbilityPluginG3PlusHpartyCheckPO abilityPluginG3PlusHpartyCheckPO = new AbilityPluginG3PlusHpartyCheckPO();
            abilityPluginG3PlusHpartyCheckPO.setAbilityPluginDeployId(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginG3PlusHpartyCheckPO = this.abilityPluginG3PlusHpartyCheckMapper.queryLimitOne(abilityPluginG3PlusHpartyCheckPO);
            G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = new G3PlusHpartyCheckTokenPO();
            g3PlusHpartyCheckTokenPO.setHpartyCheckTokenId(abilityPluginG3PlusHpartyCheckPO.getHpartyCheckTokenId());
            g3PlusHpartyCheckTokenPO = this.g3PlusHpartyCheckTokenMapper.queryLimitOne(g3PlusHpartyCheckTokenPO);
            jsonMap.put("clientId", g3PlusHpartyCheckTokenPO.getClientId());
            jsonMap.put("clientSecret", g3PlusHpartyCheckTokenPO.getClientSecret());
            jsonMap.put("userName", g3PlusHpartyCheckTokenPO.getUserName());
            jsonMap.put("userPassword", g3PlusHpartyCheckTokenPO.getUserPassword());
            jsonMap.put("tokenPath", g3PlusHpartyCheckTokenPO.getTokenPath());
            ArrayList list = Lists.newArrayList();
            list.add(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginReqBO.setAbilityPluginDeployIds((List)list);
        } else {
            jsonMap.put("clientId", "");
            jsonMap.put("clientSecret", "");
            jsonMap.put("userName", "");
            jsonMap.put("userPassword", "");
            jsonMap.put("tokenPath", "");
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("abilityPluginDeployId", abilityPluginReqBO.getAbilityPluginDeployId());
        if (abilityPluginReqBO.getNextStep() == null) {
            return RspBO.success((Object)new AbilityPluginRspBO(TITLE, StepEnum.NEXT.getCode(), URL, (Map)paramMap, (Map)jsonMap, COMPONENT_TYPE));
        }
        return RspBO.success((Object)new AbilityPluginRspBO(TITLE, abilityPluginReqBO.getNextStep(), URL, (Map)paramMap, (Map)jsonMap, COMPONENT_TYPE));
    }

    public RspBO handleDelete(Object object) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u5220\u9664\u63d2\u4ef6");
        Long abilityPluginDeployId = (Long)object;
        Long hpartyCheckTokenId = this.abilityPluginG3PlusHpartyCheckMapper.queryByAbilityPluginDeployId(abilityPluginDeployId).getHpartyCheckTokenId();
        this.abilityPluginG3PlusHpartyCheckMapper.deleteHpartyCheckByPluginDeployId(abilityPluginDeployId);
        AbilityPluginG3PlusHpartyCheckPO temp_query = new AbilityPluginG3PlusHpartyCheckPO();
        temp_query.setHpartyCheckTokenId(hpartyCheckTokenId);
        List<AbilityPluginG3PlusHpartyCheckPO> temp_query_result = this.abilityPluginG3PlusHpartyCheckMapper.queryByCond(temp_query);
        if (temp_query_result == null || temp_query_result.size() < 1) {
            this.g3PlusHpartyCheckTokenMapper.deleteHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenId);
            this.quartzG3PlusScheduleManager.removeJob(hpartyCheckTokenId + "");
        }
        return RspBO.success((Object)true);
    }

    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO handleModify(Object object) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u5904\u7406\u63d2\u4ef6\u4fee\u6539\u64cd\u4f5c ");
        try {
            AbilityPluginG3PlusHpartyCheckPO abilityPluginG3PlusHpartyCheckPO;
            logger.debug("AbilityG3PlusHpartyCheckHandler.handleModify\uff1a" + object);
            AbilityPluginG3PlusHpartyCheckReqBO abilityPluginG3PlusHpartyCheckReqBO = (AbilityPluginG3PlusHpartyCheckReqBO)object;
            ValidBatchUtils.isNotEmpty((Object)abilityPluginG3PlusHpartyCheckReqBO, (String[])new String[]{"clientId", "clientSecret", "userName", "userPassword", "tokenPath", "abilityPluginDeployId"});
            Long hpartyCheckTokenId = this.abilityPluginG3PlusHpartyCheckMapper.queryByAbilityPluginDeployId(abilityPluginG3PlusHpartyCheckReqBO.getAbilityPluginDeployId()).getHpartyCheckTokenId();
            PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfoByAbilityPluginDeployId(abilityPluginG3PlusHpartyCheckReqBO.getAbilityPluginDeployId());
            Long pluginId = pluginRspBO.getPluginId();
            G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = this.isExist(pluginId, abilityPluginG3PlusHpartyCheckReqBO.getClientId(), abilityPluginG3PlusHpartyCheckReqBO.getClientSecret(), abilityPluginG3PlusHpartyCheckReqBO.getUserName(), abilityPluginG3PlusHpartyCheckReqBO.getUserPassword(), abilityPluginG3PlusHpartyCheckReqBO.getTokenPath());
            if (g3PlusHpartyCheckTokenPO == null) {
                g3PlusHpartyCheckTokenPO = (G3PlusHpartyCheckTokenPO)BeanMapper.map((Object)abilityPluginG3PlusHpartyCheckReqBO, G3PlusHpartyCheckTokenPO.class);
                g3PlusHpartyCheckTokenPO.setPluginId(pluginId);
                g3PlusHpartyCheckTokenPO.setCreateTime(new Date());
                g3PlusHpartyCheckTokenPO.setIsRunning(1);
                this.g3PlusHpartyCheckTokenMapper.insertSelective(g3PlusHpartyCheckTokenPO);
                abilityPluginG3PlusHpartyCheckPO = new AbilityPluginG3PlusHpartyCheckPO();
                abilityPluginG3PlusHpartyCheckPO.setAbilityPluginDeployId(abilityPluginG3PlusHpartyCheckReqBO.getAbilityPluginDeployId());
                abilityPluginG3PlusHpartyCheckPO.setHpartyCheckTokenId(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginG3PlusHpartyCheckMapper.updateByAbilityPluginDeployId(abilityPluginG3PlusHpartyCheckPO);
                G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO = this.g3PlusHpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                G3PLusTokenRefreshLogic.doLogic(this.g3PlusHpartyCheckTokenMapper, this.abilityPluginG3PlusHpartyCheckMapper, this.g3PlusAbilityProvideDeployMapper, this.g3PlusHpartyCheckAppendMapper, this.cacheClient, g3PlusHpartyCheckTokenVO, this.pluginAPI);
                this.startTask(g3PlusHpartyCheckTokenVO);
            } else {
                abilityPluginG3PlusHpartyCheckPO = new AbilityPluginG3PlusHpartyCheckPO();
                abilityPluginG3PlusHpartyCheckPO.setAbilityPluginDeployId(abilityPluginG3PlusHpartyCheckReqBO.getAbilityPluginDeployId());
                abilityPluginG3PlusHpartyCheckPO.setHpartyCheckTokenId(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginG3PlusHpartyCheckMapper.updateByAbilityPluginDeployId(abilityPluginG3PlusHpartyCheckPO);
            }
            AbilityPluginG3PlusHpartyCheckPO temp_query = new AbilityPluginG3PlusHpartyCheckPO();
            temp_query.setHpartyCheckTokenId(hpartyCheckTokenId);
            List<AbilityPluginG3PlusHpartyCheckPO> temp_query_result = this.abilityPluginG3PlusHpartyCheckMapper.queryByCond(temp_query);
            if (temp_query_result == null || temp_query_result.size() < 1) {
                this.g3PlusHpartyCheckTokenMapper.deleteHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenId);
                this.quartzG3PlusScheduleManager.removeJob(hpartyCheckTokenId + "");
            }
            return RspBO.success((Object)new AbilityPluginRspBO(StepEnum.END.getCode()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    private G3PlusHpartyCheckTokenPO isExist(Long pluginId, String clientId, String clientSecret, String userName, String userPassword, String tokenPath) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u67e5\u8be2token\u8bb0\u5f55\u8868\u662f\u5426\u5b58\u5728\uff0c\u5982\u679c\u5b58\u5728\u8fd4\u56de\u5b9e\u4f53\uff0c\u4e0d\u5b58\u5728\u8fd4\u56de\u7a7a");
        G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = new G3PlusHpartyCheckTokenPO();
        g3PlusHpartyCheckTokenPO.setPluginId(pluginId);
        g3PlusHpartyCheckTokenPO.setClientId(clientId);
        g3PlusHpartyCheckTokenPO.setUserName(userName);
        g3PlusHpartyCheckTokenPO.setUserPassword(userPassword);
        g3PlusHpartyCheckTokenPO.setTokenPath(tokenPath);
        g3PlusHpartyCheckTokenPO.setClientSecret(clientSecret);
        return this.g3PlusHpartyCheckTokenMapper.queryLimitOne(g3PlusHpartyCheckTokenPO);
    }

    private void startTask(G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u542f\u52a8\u5b9a\u65f6\u4efb\u52a1");
        this.quartzG3PlusScheduleManager.addJob(g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId() + "", G3PlusTokenRefreshTask.class, g3PlusHpartyCheckTokenVO.getRefreshInterval(), g3PlusHpartyCheckTokenVO);
    }

    public void execute(PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u6838\u5fc3execute");
        G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = this.isExist(pluginG3PlusHpartyCheckReqBO.getPluginId(), pluginG3PlusHpartyCheckReqBO.getClientId(), pluginG3PlusHpartyCheckReqBO.getClientSecret(), pluginG3PlusHpartyCheckReqBO.getUserName(), pluginG3PlusHpartyCheckReqBO.getUserPassword(), pluginG3PlusHpartyCheckReqBO.getTokenPath());
        if (g3PlusHpartyCheckTokenPO == null) {
            g3PlusHpartyCheckTokenPO = (G3PlusHpartyCheckTokenPO)BeanMapper.map((Object)pluginG3PlusHpartyCheckReqBO, G3PlusHpartyCheckTokenPO.class);
            g3PlusHpartyCheckTokenPO.setIsRunning(0);
            this.g3PlusHpartyCheckTokenMapper.insertSelective(g3PlusHpartyCheckTokenPO);
        }
        G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO = this.g3PlusHpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
        G3PLusTokenRefreshLogic.doLogic(this.g3PlusHpartyCheckTokenMapper, this.abilityPluginG3PlusHpartyCheckMapper, this.g3PlusAbilityProvideDeployMapper, this.g3PlusHpartyCheckAppendMapper, this.cacheClient, g3PlusHpartyCheckTokenVO, this.pluginAPI);
    }

    public void dealTask(PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO) {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u5904\u7406\u4efb\u52a1");
        G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = this.isExist(pluginG3PlusHpartyCheckReqBO.getPluginId(), pluginG3PlusHpartyCheckReqBO.getClientId(), pluginG3PlusHpartyCheckReqBO.getClientSecret(), pluginG3PlusHpartyCheckReqBO.getUserName(), pluginG3PlusHpartyCheckReqBO.getUserPassword(), pluginG3PlusHpartyCheckReqBO.getTokenPath());
        if (pluginG3PlusHpartyCheckReqBO.getTaskSwitch().equals(Constants.Switch.OFF)) {
            if (g3PlusHpartyCheckTokenPO != null) {
                this.quartzG3PlusScheduleManager.removeJob(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId() + "");
            }
        } else if (g3PlusHpartyCheckTokenPO != null) {
            G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO = this.g3PlusHpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(g3PlusHpartyCheckTokenPO.getHpartyCheckTokenId());
            if (this.quartzG3PlusScheduleManager.checkJob(g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId() + "").booleanValue()) {
                this.quartzG3PlusScheduleManager.modifyJob(g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId() + "", G3PlusTokenRefreshTask.class, g3PlusHpartyCheckTokenVO.getRefreshInterval(), g3PlusHpartyCheckTokenVO);
            } else if (g3PlusHpartyCheckTokenPO.getIsRunning().equals(1)) {
                this.quartzG3PlusScheduleManager.addJob(g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId() + "", G3PlusTokenRefreshTask.class, g3PlusHpartyCheckTokenVO.getRefreshInterval(), g3PlusHpartyCheckTokenVO);
            }
        }
    }
}

