/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.HpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.rsp.SyncHpartyCheckAppendBO;
import com.ohaotian.plugin.model.bo.rsp.SyncHpartyCheckTokenBO;
import com.ohaotian.plugin.service.HpartyCheckSyncDataService;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.bo.SyncDataReqBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HpartyCheckSyncDataServiceImpl
implements HpartyCheckSyncDataService {
    private Logger log = LogManager.getLogger(HpartyCheckSyncDataService.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    private HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    private HpartyCheckAppendMapper hpartyCheckAppendMapper;
    private static final String HPARTY_CHECK_TOKEN = "hparty_check_token";
    private static final String HPARTY_CHECK_APPEND = "hparty_check_append";
    private static final String CLUSTER_ID = "clusterId";
    private static final String HIRER_ID = "hirerId";
    private static final String FIRST_LEVEL = "firstLevel";
    private static final String SECOND_LEVEL = "secondLevel";

    @Override
    public RspBO syncAllData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{CLUSTER_ID, HIRER_ID, FIRST_LEVEL, SECOND_LEVEL});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 0);
        return RspBO.success(map);
    }

    private Map<String, Object> qryPlugin(SyncDataReqBO syncDataBO, int type) {
        HashMap map = Maps.newHashMap();
        String firstLevel = syncDataBO.getFirstLevel();
        String secondLevel = syncDataBO.getSecondLevel();
        Long primaryId = syncDataBO.getPrimaryId();
        if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel) && SecondLevelEnum.PLUGIN_PLUGIN.getCode().equals(secondLevel)) {
            List<SyncHpartyCheckAppendBO> hpartyCheckAppendBOList;
            List pluginIds = this.pluginAPI.getPluginIds(syncDataBO);
            if (type == 0) {
                this.log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)HPARTY_CHECK_APPEND);
            } else {
                this.log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)HPARTY_CHECK_APPEND, (Object)primaryId);
            }
            if (!CollectionUtils.isEmpty((Collection)pluginIds) && !CollectionUtils.isEmpty(hpartyCheckAppendBOList = this.hpartyCheckAppendMapper.queryByPluginIds(pluginIds))) {
                map.put(HPARTY_CHECK_APPEND, hpartyCheckAppendBOList);
            }
        } else if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel) && SecondLevelEnum.PLUGIN_PLUGIN_EXT.getCode().equals(secondLevel)) {
            List<SyncHpartyCheckTokenBO> hpartyCheckTokenBOList;
            List abilityPluginDeployIds = null;
            if (type == 1 || type == 0) {
                abilityPluginDeployIds = this.pluginAPI.getAbilityPluginDeployIds(syncDataBO.getClusterId(), syncDataBO.getHirerId(), null, syncDataBO.getPrimaryId());
            } else if (type == 2) {
                abilityPluginDeployIds = this.pluginAPI.getAbilityPluginDeployIds(syncDataBO.getClusterId(), syncDataBO.getHirerId(), syncDataBO.getPrimaryId(), null);
            }
            if (type == 0) {
                this.log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)HPARTY_CHECK_TOKEN);
            } else {
                this.log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)HPARTY_CHECK_TOKEN, (Object)primaryId);
            }
            if (!CollectionUtils.isEmpty((Collection)abilityPluginDeployIds) && !CollectionUtils.isEmpty(hpartyCheckTokenBOList = this.hpartyCheckTokenMapper.queryByDeployIds(abilityPluginDeployIds))) {
                map.put(HPARTY_CHECK_TOKEN, hpartyCheckTokenBOList);
            }
        } else {
            this.log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)firstLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{firstLevel}).getMessage());
        }
        return map;
    }

    @Override
    public RspBO syncIncrementData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{CLUSTER_ID, HIRER_ID, FIRST_LEVEL, SECOND_LEVEL, "primaryId"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 1);
        return RspBO.success(map);
    }

    @Override
    public RspBO syncIncrementDataByAbility(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{CLUSTER_ID, HIRER_ID, FIRST_LEVEL, SECOND_LEVEL, "primaryId"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 2);
        return RspBO.success(map);
    }
}

