/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.model.vo.HpartyCheckTokenVO;
import com.ohaotian.plugin.task.TokenRefreshLogic;
import javax.annotation.Resource;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@DisallowConcurrentExecution
public class TokenRefreshTask
implements Job {
    private static final Logger log = LoggerFactory.getLogger(TokenRefreshTask.class);
    @Autowired
    private TokenRefreshLogic tokenRefreshLogic;
    @Resource
    private HpartyCheckTokenMapper hpartyCheckTokenMapper;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Long hpartyCheckTokenId = (Long)jobExecutionContext.getMergedJobDataMap().get((Object)"parameterData");
        HpartyCheckTokenVO hpartyCheckTokenVO = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(hpartyCheckTokenId);
        if (!ObjectUtils.isEmpty((Object)hpartyCheckTokenVO)) {
            this.tokenRefreshLogic.doLogic(hpartyCheckTokenVO);
        } else {
            log.error("\u975e\u4eac\u4e1c hpartyCheckTokenId\uff1a{} \u6570\u636e\u67e5\u8be2\u5f02\u5e38\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01", (Object)hpartyCheckTokenId);
        }
    }
}

