/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.enums.AppendEnum;
import com.ohaotian.plugin.enums.CallProtocolEnum;
import com.ohaotian.plugin.mapper.HpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.PluginHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.rsp.AppendRspBO;
import com.ohaotian.plugin.model.bo.rsp.CallProtocolRspBO;
import com.ohaotian.plugin.model.bo.rsp.PluginHpartyCheckRspBO;
import com.ohaotian.plugin.model.po.HpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginHpartyCheckPO;
import com.ohaotian.plugin.service.AbilityHpartyCheckHandler;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/hpartyCheck"})
public class HpartyCheckController {
    private static Logger logger = LogManager.getLogger(HpartyCheckController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AppAPI appAPI;
    @Resource
    RegionAPI regionAPI;
    @Resource
    PluginHpartyCheckMapper pluginHpartyCheckMapper;
    @Resource
    HpartyCheckAppendMapper hpartyCheckAppendMapper;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    AbilityHpartyCheckHandler abilityHpartyCheckHandler;
    @Resource
    private AuthorityService authorityService;
    private static final String INPUT = "\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}";
    private static final String UNSPECIFIED = "\u672a\u6307\u5b9a\u62fc\u88c5\u5185\u5bb9";

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug(INPUT, (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO getPluginExtInfo(@RequestBody PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        logger.debug(INPUT, (Object)pluginHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginHpartyCheckPO pluginHpartyCheckPO = new PluginHpartyCheckPO();
        pluginHpartyCheckPO.setPluginId(pluginHpartyCheckReqBO.getPluginId());
        pluginHpartyCheckPO = this.pluginHpartyCheckMapper.queryLimitOne(pluginHpartyCheckPO);
        PluginHpartyCheckRspBO pluginHpartyCheckRspBO = (PluginHpartyCheckRspBO)BeanMapper.map((Object)pluginHpartyCheckPO, PluginHpartyCheckRspBO.class);
        AppBO appBO = this.appAPI.queryAppByRegionCode(tenantId, pluginHpartyCheckPO.getRegionCode());
        RegionBO regionBO = this.regionAPI.queryRegionByAppIdAndRegionCode(appBO.getAppId(), pluginHpartyCheckPO.getRegionCode());
        pluginHpartyCheckRspBO.setAppId(appBO.getAppId());
        pluginHpartyCheckRspBO.setAppRegionName(appBO.getAppName() + "/" + regionBO.getRegionName());
        String[] appRegion = new String[]{appBO.getAppId().toString(), regionBO.getRegionCode()};
        pluginHpartyCheckRspBO.setAppRegion(appRegion);
        List<HpartyCheckAppendPO> hpartyCheckAppendPOS = this.hpartyCheckAppendMapper.queryByPluginId(pluginHpartyCheckReqBO.getPluginId());
        ArrayList<String> appends = new ArrayList<String>();
        for (HpartyCheckAppendPO hpartyCheckAppendPO : hpartyCheckAppendPOS) {
            appends.add(hpartyCheckAppendPO.getAppendContent());
        }
        pluginHpartyCheckRspBO.setAppendContents(appends);
        return RspBO.success((Object)pluginHpartyCheckRspBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        logger.debug(INPUT, (Object)pluginHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginHpartyCheckReqBO.getAppRegion() == null || pluginHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getUserName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getUserPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginHpartyCheckReqBO.getAppendContents() == null || pluginHpartyCheckReqBO.getAppendContents().size() < 1) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getCallProtocol())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u534f\u8bae");
        }
        if (pluginHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        PluginHpartyCheckPO oldPo = new PluginHpartyCheckPO();
        oldPo.setPluginId(pluginHpartyCheckReqBO.getPluginId());
        oldPo = this.pluginHpartyCheckMapper.queryLimitOne(oldPo);
        PluginHpartyCheckPO pluginHpartyCheckPO = (PluginHpartyCheckPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, PluginHpartyCheckPO.class);
        pluginHpartyCheckPO.setRegionCode(pluginHpartyCheckReqBO.getAppRegion()[1]);
        this.pluginHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginHpartyCheckPO);
        PluginHpartyCheckPO pluginHpartyCheckPO1 = new PluginHpartyCheckPO();
        pluginHpartyCheckPO1.setPluginHpartyCheckId(pluginHpartyCheckPO.getPluginHpartyCheckId());
        pluginHpartyCheckPO1 = this.pluginHpartyCheckMapper.queryLimitOne(pluginHpartyCheckPO1);
        Long pluginId = pluginHpartyCheckPO1.getPluginId();
        this.hpartyCheckAppendMapper.deleteByPluginId(pluginId);
        List appends = pluginHpartyCheckReqBO.getAppendContents();
        ArrayList<HpartyCheckAppendPO> hpartyCheckAppendPOS = new ArrayList<HpartyCheckAppendPO>();
        for (String append : appends) {
            HpartyCheckAppendPO hpartyCheckAppendPO = new HpartyCheckAppendPO();
            hpartyCheckAppendPO.setPluginId(pluginId);
            hpartyCheckAppendPO.setAppendContent(append);
            hpartyCheckAppendPOS.add(hpartyCheckAppendPO);
        }
        this.hpartyCheckAppendMapper.insertRecords(hpartyCheckAppendPOS);
        HpartyCheckTokenPO hpartyCheckTokenPO = new HpartyCheckTokenPO();
        hpartyCheckTokenPO.setPluginId(pluginId);
        hpartyCheckTokenPO.setClientId(oldPo.getClientId());
        hpartyCheckTokenPO.setUserName(oldPo.getUserName());
        hpartyCheckTokenPO.setUserPassword(oldPo.getUserPassword());
        hpartyCheckTokenPO.setTokenPath(oldPo.getTokenPath());
        hpartyCheckTokenPO.setClientSecret(oldPo.getClientSecret());
        HpartyCheckTokenPO oldTokenPO = this.hpartyCheckTokenMapper.queryLimitOne(hpartyCheckTokenPO);
        hpartyCheckTokenPO = (HpartyCheckTokenPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, HpartyCheckTokenPO.class);
        hpartyCheckTokenPO.setHpartyCheckTokenId(oldTokenPO.getHpartyCheckTokenId());
        this.hpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenPO);
        this.abilityHpartyCheckHandler.dealTask(pluginHpartyCheckReqBO);
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"allCallProtocol"})
    @BusiResponseBody
    public RspBO allCallProtocol() {
        ArrayList<CallProtocolRspBO> callProtocolRspBOS = new ArrayList<CallProtocolRspBO>();
        CallProtocolRspBO callProtocolRspBO_json = new CallProtocolRspBO("json", CallProtocolEnum.JSON.getCode());
        CallProtocolRspBO callProtocolRspBO_form = new CallProtocolRspBO("form", CallProtocolEnum.FROM.getCode());
        callProtocolRspBOS.add(callProtocolRspBO_json);
        callProtocolRspBOS.add(callProtocolRspBO_form);
        return RspBO.success(callProtocolRspBOS);
    }

    @PostMapping(value={"allAppend"})
    @BusiResponseBody
    public RspBO allAppend() {
        ArrayList<AppendRspBO> appendRspBOS = new ArrayList<AppendRspBO>();
        AppendRspBO appendRspBO_token = new AppendRspBO("token", AppendEnum.TOKEN.getCode());
        AppendRspBO appendRspBO_type = new AppendRspBO("\u56fa\u5b9a\u503c", AppendEnum.TYPE.getCode());
        AppendRspBO appendRspBO_appkey = new AppendRspBO("clientId", AppendEnum.APPKEY.getCode());
        appendRspBOS.add(appendRspBO_token);
        appendRspBOS.add(appendRspBO_type);
        appendRspBOS.add(appendRspBO_appkey);
        return RspBO.success(appendRspBOS);
    }

    @PostMapping(value={"execute"})
    @BusiResponseBody
    public RspBO execute(@RequestBody PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginHpartyCheckReqBO.getAppRegion() == null || pluginHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getUserName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getUserPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginHpartyCheckReqBO.getAppendContents() == null || pluginHpartyCheckReqBO.getAppendContents().size() < 1) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (StringUtils.isEmpty((Object)pluginHpartyCheckReqBO.getCallProtocol())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u534f\u8bae");
        }
        if (pluginHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        this.abilityHpartyCheckHandler.execute(pluginHpartyCheckReqBO);
        return RspBO.success((Object)true);
    }
}

