/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.alibaba.excel.metadata.Sheet;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.AbilityPluginHpartyCheckMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.model.po.AbilityPluginHpartyCheckPO;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import com.ohaotian.plugin.service.HpartyCheckPluginHandler;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@PluginTypeHandlerType(value="hpartyCheck", position=ExtensionPointPositionEnum.EXPORT_POSITION)
public class HpartyCheckExportHandler
extends AbstractPluginHandler<List<ExportBO>> {
    private static final Logger log = LogManager.getLogger(HpartyCheckPluginHandler.class);
    @Resource
    AbilityPluginHpartyCheckMapper abilityPluginHpartyCheckMapper;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;

    public RspBO<List<ExportBO>> handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        ArrayList exportBOList = null;
        List abilityPluginDeployIds = abilityPluginReqBO.getAbilityPluginDeployIds();
        List<AbilityPluginHpartyCheckPO> abilityPluginHpartyCheckPOList = this.abilityPluginHpartyCheckMapper.queryPluginByPluginDeployIds(abilityPluginDeployIds);
        if (!CollectionUtils.isEmpty(abilityPluginHpartyCheckPOList)) {
            exportBOList = Lists.newArrayList();
            ArrayList provideDeployRows = Lists.newArrayList();
            Sheet sheet = new Sheet(1, 3);
            sheet.setSheetName("ability_plugin_hparty_check");
            sheet.setAutoWidth(Boolean.TRUE);
            ArrayList header = Lists.newArrayList();
            ArrayList strs = Lists.newArrayList();
            strs.add("abilityPluginHpartyCheckId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("abilityPluginDeployId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("hpartyCheckTokenId");
            header.add(strs);
            sheet.setHead((List)header);
            for (AbilityPluginHpartyCheckPO abilityPluginHpartyCheckPO : abilityPluginHpartyCheckPOList) {
                ArrayList objs = Lists.newArrayList();
                objs.add(abilityPluginHpartyCheckPO.getAbilityPluginHpartyCheckId());
                objs.add(abilityPluginHpartyCheckPO.getAbilityPluginDeployId());
                objs.add(abilityPluginHpartyCheckPO.getHpartyCheckTokenId());
                provideDeployRows.add(objs);
            }
            ExportBO exportBO = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
            exportBOList.add(exportBO);
            List<Long> hpartyCheckTokenIds = abilityPluginHpartyCheckPOList.stream().map(AbilityPluginHpartyCheckPO::getHpartyCheckTokenId).collect(Collectors.toList());
            List<HpartyCheckTokenPO> hpartyCheckTokenPOList = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIds(hpartyCheckTokenIds);
            sheet = new Sheet(2, 3);
            sheet.setSheetName("hparty_check_token");
            sheet.setAutoWidth(Boolean.TRUE);
            header = Lists.newArrayList();
            strs = Lists.newArrayList();
            strs.add("hpartyCheckTokenId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("pluginId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("clientId");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("clientSecret");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("userName");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("userPassword");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("tokenPath");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("accessToken");
            header.add(strs);
            strs = Lists.newArrayList();
            strs.add("expiresIn");
            header.add(strs);
            sheet.setHead((List)header);
            provideDeployRows = Lists.newArrayList();
            for (HpartyCheckTokenPO hpartyCheckTokenPO : hpartyCheckTokenPOList) {
                ArrayList objs = Lists.newArrayList();
                objs.add(hpartyCheckTokenPO.getHpartyCheckTokenId());
                objs.add(hpartyCheckTokenPO.getPluginId());
                objs.add(hpartyCheckTokenPO.getClientId());
                objs.add(hpartyCheckTokenPO.getClientSecret());
                objs.add(hpartyCheckTokenPO.getUserName());
                objs.add(hpartyCheckTokenPO.getUserPassword());
                objs.add(hpartyCheckTokenPO.getTokenPath());
                objs.add(hpartyCheckTokenPO.getAccessToken());
                objs.add(hpartyCheckTokenPO.getExpiresIn());
                provideDeployRows.add(objs);
            }
            ExportBO hpartyCheckToken = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
            exportBOList.add(hpartyCheckToken);
        }
        return RspBO.success((Object)exportBOList);
    }
}

