/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.atp.base.model.TokenRefreshBo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.config.QuartzScheduleManager;
import com.ohaotian.plugin.mapper.AbilityPluginHpartyCheckMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.AbilityPluginHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.req.PluginHpartyCheckReqBO;
import com.ohaotian.plugin.model.po.AbilityPluginHpartyCheckPO;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginHpartyCheckPO;
import com.ohaotian.plugin.model.vo.HpartyCheckTokenVO;
import com.ohaotian.plugin.task.TokenRefreshLogic;
import com.ohaotian.plugin.task.TokenRefreshTask;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.AbilityPluginRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.QryPluginJsonService;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
@PluginTypeHandlerType(value="hpartyCheck", position=ExtensionPointPositionEnum.ABILITY_POSITION)
public class AbilityHpartyCheckHandler
extends AbstractPluginHandler<Object> {
    private static final Logger log = LogManager.getLogger(AbilityHpartyCheckHandler.class);
    private static final String URL = "/ability/updatePluginHpartyCheck";
    private static final String TITLE = "\u843d\u5730\u6821\u9a8c\u7ed1\u5b9a\u5173\u7cfb\u6269\u5c55\u4fe1\u606f";
    private static final String COMPONENT_TYPE = "plugin-binding-luodi";
    private static final String ABILITYPLUGINDEPLOYID = "abilityPluginDeployId";
    private static final String CLIENTID = "clientId";
    private static final String CLIENTSECRET = "clientSecret";
    private static final String USERNAME = "userName";
    private static final String USERPASSWORD = "userPassword";
    private static final String TOKENPATH = "tokenPath";
    @Resource
    private QryPluginJsonService qryPluginJsonService;
    @Value(value="classpath:static/data/ability-plugin-hparty-check.json")
    private org.springframework.core.io.Resource hpartyCheckJson;
    @Resource
    AbilityPluginHpartyCheckMapper abilityPluginHpartyCheckMapper;
    @Resource
    PluginHpartyCheckMapper pluginHpartyCheckMapper;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    QuartzScheduleManager quartzScheduleManager;
    @Resource
    PluginAPI pluginAPI;
    @Autowired
    private TokenRefreshLogic tokenRefreshLogic;

    @Transactional
    public RspBO handleAdd(Object object) throws ZTBusinessException {
        try {
            AbilityPluginHpartyCheckPO abilityPluginHpartyCheckPO;
            Map objectMap = (Map)object;
            Long abilityPluginDeployId = Long.parseLong(objectMap.get(ABILITYPLUGINDEPLOYID) + "");
            Long pluginId = Long.parseLong(objectMap.get("pluginId") + "");
            PluginHpartyCheckPO pluginHpartyCheckPO = new PluginHpartyCheckPO();
            pluginHpartyCheckPO.setPluginId(pluginId);
            pluginHpartyCheckPO = this.pluginHpartyCheckMapper.queryLimitOne(pluginHpartyCheckPO);
            HpartyCheckTokenPO hpartyCheckTokenPO = this.isExist(pluginId, pluginHpartyCheckPO.getClientId(), pluginHpartyCheckPO.getClientSecret(), pluginHpartyCheckPO.getUserName(), pluginHpartyCheckPO.getUserPassword(), pluginHpartyCheckPO.getTokenPath());
            if (hpartyCheckTokenPO == null) {
                hpartyCheckTokenPO = (HpartyCheckTokenPO)BeanMapper.map((Object)pluginHpartyCheckPO, HpartyCheckTokenPO.class);
                hpartyCheckTokenPO.setIsRunning(1);
                this.hpartyCheckTokenMapper.insertSelective(hpartyCheckTokenPO);
                abilityPluginHpartyCheckPO = new AbilityPluginHpartyCheckPO();
                abilityPluginHpartyCheckPO.setAbilityPluginDeployId(abilityPluginDeployId);
                abilityPluginHpartyCheckPO.setHpartyCheckTokenId(hpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginHpartyCheckMapper.insertSelective(abilityPluginHpartyCheckPO);
            } else {
                abilityPluginHpartyCheckPO = new AbilityPluginHpartyCheckPO();
                abilityPluginHpartyCheckPO.setAbilityPluginDeployId(abilityPluginDeployId);
                abilityPluginHpartyCheckPO.setHpartyCheckTokenId(hpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginHpartyCheckMapper.insertSelective(abilityPluginHpartyCheckPO);
            }
            if (pluginHpartyCheckPO.getTaskSwitch().equals(Constants.Switch.ON) && !this.quartzScheduleManager.checkJob(hpartyCheckTokenPO.getHpartyCheckTokenId() + "").booleanValue()) {
                HpartyCheckTokenVO hpartyCheckTokenVO = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(hpartyCheckTokenPO.getHpartyCheckTokenId());
                this.tokenRefreshLogic.doLogic(hpartyCheckTokenVO);
                this.startTask(hpartyCheckTokenVO);
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        log.debug("\u67e5\u8be2HpartyCheck\u63d2\u4ef6\u4fe1\u606f");
        String template = this.qryPluginJsonService.getAbilityPlugin(abilityPluginReqBO, this.hpartyCheckJson);
        HashMap jsonMap = Maps.newHashMap();
        jsonMap.put("pluginName", abilityPluginReqBO.getPluginName());
        jsonMap.put("abilityName", abilityPluginReqBO.getAbilityName());
        if (!StringUtils.isEmpty((Object)abilityPluginReqBO.getAbilityPluginDeployId())) {
            AbilityPluginHpartyCheckPO abilityPluginHpartyCheckPO = new AbilityPluginHpartyCheckPO();
            abilityPluginHpartyCheckPO.setAbilityPluginDeployId(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginHpartyCheckPO = this.abilityPluginHpartyCheckMapper.queryLimitOne(abilityPluginHpartyCheckPO);
            HpartyCheckTokenPO hpartyCheckTokenPO = new HpartyCheckTokenPO();
            hpartyCheckTokenPO.setHpartyCheckTokenId(abilityPluginHpartyCheckPO.getHpartyCheckTokenId());
            hpartyCheckTokenPO = this.hpartyCheckTokenMapper.queryLimitOne(hpartyCheckTokenPO);
            jsonMap.put(CLIENTID, hpartyCheckTokenPO.getClientId());
            jsonMap.put(CLIENTSECRET, hpartyCheckTokenPO.getClientSecret());
            jsonMap.put(USERNAME, hpartyCheckTokenPO.getUserName());
            jsonMap.put(USERPASSWORD, hpartyCheckTokenPO.getUserPassword());
            jsonMap.put(TOKENPATH, hpartyCheckTokenPO.getTokenPath());
            ArrayList list = Lists.newArrayList();
            list.add(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginReqBO.setAbilityPluginDeployIds((List)list);
        } else {
            jsonMap.put(CLIENTID, "");
            jsonMap.put(CLIENTSECRET, "");
            jsonMap.put(USERNAME, "");
            jsonMap.put(USERPASSWORD, "");
            jsonMap.put(TOKENPATH, "");
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put(ABILITYPLUGINDEPLOYID, abilityPluginReqBO.getAbilityPluginDeployId());
        if (abilityPluginReqBO.getNextStep() == null) {
            return RspBO.success((Object)new AbilityPluginRspBO(TITLE, StepEnum.NEXT.getCode(), URL, (Map)paramMap, (Map)jsonMap, COMPONENT_TYPE));
        }
        return RspBO.success((Object)new AbilityPluginRspBO(TITLE, abilityPluginReqBO.getNextStep(), URL, (Map)paramMap, (Map)jsonMap, COMPONENT_TYPE));
    }

    public RspBO handleDelete(Object object) throws ZTBusinessException {
        Long abilityPluginDeployId = (Long)object;
        Long hpartyCheckTokenId = this.abilityPluginHpartyCheckMapper.queryByAbilityPluginDeployId(abilityPluginDeployId).getHpartyCheckTokenId();
        this.abilityPluginHpartyCheckMapper.deleteHpartyCheckByPluginDeployId(abilityPluginDeployId);
        AbilityPluginHpartyCheckPO temp_query = new AbilityPluginHpartyCheckPO();
        temp_query.setHpartyCheckTokenId(hpartyCheckTokenId);
        List<AbilityPluginHpartyCheckPO> temp_query_result = this.abilityPluginHpartyCheckMapper.queryByCond(temp_query);
        if (temp_query_result == null || temp_query_result.size() < 1) {
            this.hpartyCheckTokenMapper.deleteHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenId);
            this.quartzScheduleManager.removeJob(hpartyCheckTokenId + "");
        }
        return RspBO.success((Object)true);
    }

    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO handleModify(Object object) throws ZTBusinessException {
        try {
            AbilityPluginHpartyCheckPO abilityPluginHpartyCheckPO;
            log.debug("HpartyCheckPluginHandler.handleModify\uff1a" + object);
            AbilityPluginHpartyCheckReqBO abilityPluginHpartyCheckReqBO = (AbilityPluginHpartyCheckReqBO)object;
            ValidBatchUtils.isNotEmpty((Object)abilityPluginHpartyCheckReqBO, (String[])new String[]{CLIENTID, CLIENTSECRET, USERNAME, USERPASSWORD, TOKENPATH, ABILITYPLUGINDEPLOYID});
            Long hpartyCheckTokenId = this.abilityPluginHpartyCheckMapper.queryByAbilityPluginDeployId(abilityPluginHpartyCheckReqBO.getAbilityPluginDeployId()).getHpartyCheckTokenId();
            PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfoByAbilityPluginDeployId(abilityPluginHpartyCheckReqBO.getAbilityPluginDeployId());
            Long pluginId = pluginRspBO.getPluginId();
            HpartyCheckTokenPO hpartyCheckTokenPO = this.isExist(pluginId, abilityPluginHpartyCheckReqBO.getClientId(), abilityPluginHpartyCheckReqBO.getClientSecret(), abilityPluginHpartyCheckReqBO.getUserName(), abilityPluginHpartyCheckReqBO.getUserPassword(), abilityPluginHpartyCheckReqBO.getTokenPath());
            if (hpartyCheckTokenPO == null) {
                hpartyCheckTokenPO = (HpartyCheckTokenPO)BeanMapper.map((Object)abilityPluginHpartyCheckReqBO, HpartyCheckTokenPO.class);
                hpartyCheckTokenPO.setPluginId(pluginId);
                hpartyCheckTokenPO.setCreateTime(new Date());
                hpartyCheckTokenPO.setIsRunning(1);
                this.hpartyCheckTokenMapper.insertSelective(hpartyCheckTokenPO);
                abilityPluginHpartyCheckPO = new AbilityPluginHpartyCheckPO();
                abilityPluginHpartyCheckPO.setAbilityPluginDeployId(abilityPluginHpartyCheckReqBO.getAbilityPluginDeployId());
                abilityPluginHpartyCheckPO.setHpartyCheckTokenId(hpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginHpartyCheckMapper.updateByAbilityPluginDeployId(abilityPluginHpartyCheckPO);
                HpartyCheckTokenVO hpartyCheckTokenVO = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(hpartyCheckTokenPO.getHpartyCheckTokenId());
                this.tokenRefreshLogic.doLogic(hpartyCheckTokenVO);
                this.startTask(hpartyCheckTokenVO);
            } else {
                abilityPluginHpartyCheckPO = new AbilityPluginHpartyCheckPO();
                abilityPluginHpartyCheckPO.setAbilityPluginDeployId(abilityPluginHpartyCheckReqBO.getAbilityPluginDeployId());
                abilityPluginHpartyCheckPO.setHpartyCheckTokenId(hpartyCheckTokenPO.getHpartyCheckTokenId());
                this.abilityPluginHpartyCheckMapper.updateByAbilityPluginDeployId(abilityPluginHpartyCheckPO);
            }
            AbilityPluginHpartyCheckPO temp_query = new AbilityPluginHpartyCheckPO();
            temp_query.setHpartyCheckTokenId(hpartyCheckTokenId);
            List<AbilityPluginHpartyCheckPO> temp_query_result = this.abilityPluginHpartyCheckMapper.queryByCond(temp_query);
            if (temp_query_result == null || temp_query_result.size() < 1) {
                this.hpartyCheckTokenMapper.deleteHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenId);
                this.quartzScheduleManager.removeJob(hpartyCheckTokenId + "");
            }
            return RspBO.success((Object)new AbilityPluginRspBO(StepEnum.END.getCode()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleTokenRefresh(Object data) throws ZTBusinessException {
        try {
            TokenRefreshBo tokenRefreshBo = (TokenRefreshBo)GsonUtil.fromJson((String)GsonUtil.toJson((Object)data), TokenRefreshBo.class);
            for (Long pluginId : tokenRefreshBo.getPluginIds()) {
                HpartyCheckTokenPO tokenPo;
                PluginHpartyCheckPO entity = new PluginHpartyCheckPO();
                entity.setPluginId(pluginId);
                if (!(entity = this.pluginHpartyCheckMapper.queryLimitOne(entity)).getTaskSwitch().equals(Constants.Switch.ON) || ObjectUtils.isEmpty((Object)(tokenPo = this.isExist(pluginId, entity.getClientId(), entity.getClientSecret(), entity.getUserName(), entity.getUserPassword(), entity.getTokenPath()))) || !this.quartzScheduleManager.checkJob(tokenPo.getHpartyCheckTokenId() + "").booleanValue()) continue;
                HpartyCheckTokenVO hpartyCheckTokenVO = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(tokenPo.getHpartyCheckTokenId());
                this.tokenRefreshLogic.doLogic(hpartyCheckTokenVO);
                log.info("\u63d2\u4ef6:{}  \u843d\u5730\u6821\u9a8ctokenId:{} \u5237\u65b0\u5b8c\u6210!", (Object)entity.getPluginId(), (Object)tokenPo.getHpartyCheckTokenId());
            }
            return RspBO.success((Object)"\u5237\u65b0\u5b8c\u6210");
        }
        catch (Exception e) {
            return RspBO.error((String)("\u5237\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private HpartyCheckTokenPO isExist(Long pluginId, String clientId, String clientSecret, String userName, String userPassword, String tokenPath) {
        HpartyCheckTokenPO hpartyCheckTokenPO = new HpartyCheckTokenPO();
        hpartyCheckTokenPO.setPluginId(pluginId);
        return this.hpartyCheckTokenMapper.queryLimitOne(hpartyCheckTokenPO);
    }

    private void startTask(HpartyCheckTokenVO hpartyCheckTokenVO) {
        this.quartzScheduleManager.addJob(hpartyCheckTokenVO.getHpartyCheckTokenId() + "", TokenRefreshTask.class, hpartyCheckTokenVO.getRefreshInterval(), hpartyCheckTokenVO);
    }

    public void execute(PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        HpartyCheckTokenPO hpartyCheckTokenPO = this.isExist(pluginHpartyCheckReqBO.getPluginId(), pluginHpartyCheckReqBO.getClientId(), pluginHpartyCheckReqBO.getClientSecret(), pluginHpartyCheckReqBO.getUserName(), pluginHpartyCheckReqBO.getUserPassword(), pluginHpartyCheckReqBO.getTokenPath());
        PluginHpartyCheckPO pluginHpartyCheckPO = new PluginHpartyCheckPO();
        pluginHpartyCheckPO.setPluginId(pluginHpartyCheckReqBO.getPluginId());
        pluginHpartyCheckPO = this.pluginHpartyCheckMapper.queryLimitOne(pluginHpartyCheckPO);
        if (!ObjectUtils.isEmpty((Object)hpartyCheckTokenPO)) {
            Long hpartyCheckTokenId = hpartyCheckTokenPO.getHpartyCheckTokenId();
            hpartyCheckTokenPO = (HpartyCheckTokenPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, HpartyCheckTokenPO.class);
            hpartyCheckTokenPO.setTokenPath(pluginHpartyCheckPO.getTokenPath());
            hpartyCheckTokenPO.setIsRunning(1);
            hpartyCheckTokenPO.setHpartyCheckTokenId(hpartyCheckTokenId);
            this.hpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenPO);
        } else {
            hpartyCheckTokenPO = (HpartyCheckTokenPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, HpartyCheckTokenPO.class);
            hpartyCheckTokenPO.setIsRunning(1);
            hpartyCheckTokenPO.setCreateTime(new Date());
            this.hpartyCheckTokenMapper.insertSelective(hpartyCheckTokenPO);
        }
        HpartyCheckTokenVO hpartyCheckTokenVO = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(hpartyCheckTokenPO.getHpartyCheckTokenId());
        this.tokenRefreshLogic.doLogic(hpartyCheckTokenVO);
    }

    public void dealTask(PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        HpartyCheckTokenPO hpartyCheckTokenPO = this.isExist(pluginHpartyCheckReqBO.getPluginId(), pluginHpartyCheckReqBO.getClientId(), pluginHpartyCheckReqBO.getClientSecret(), pluginHpartyCheckReqBO.getUserName(), pluginHpartyCheckReqBO.getUserPassword(), pluginHpartyCheckReqBO.getTokenPath());
        if (pluginHpartyCheckReqBO.getTaskSwitch().equals(Constants.Switch.OFF)) {
            if (hpartyCheckTokenPO != null) {
                this.quartzScheduleManager.removeJob(hpartyCheckTokenPO.getHpartyCheckTokenId() + "");
            }
        } else if (hpartyCheckTokenPO != null) {
            HpartyCheckTokenVO hpartyCheckTokenVO = this.hpartyCheckTokenMapper.queryByHpartyCheckTokenIdForTask(hpartyCheckTokenPO.getHpartyCheckTokenId());
            if (this.quartzScheduleManager.checkJob(hpartyCheckTokenVO.getHpartyCheckTokenId() + "").booleanValue()) {
                this.quartzScheduleManager.modifyJob(hpartyCheckTokenVO.getHpartyCheckTokenId() + "", TokenRefreshTask.class, hpartyCheckTokenVO.getRefreshInterval(), hpartyCheckTokenVO);
            } else if (hpartyCheckTokenPO.getIsRunning().equals(1)) {
                this.quartzScheduleManager.addJob(hpartyCheckTokenVO.getHpartyCheckTokenId() + "", TokenRefreshTask.class, hpartyCheckTokenVO.getRefreshInterval(), hpartyCheckTokenVO);
            }
        }
    }
}

