/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.model.bo.req.AbilityPluginExtIpReqBO;
import com.ohaotian.plugin.model.bo.req.DelExtIpReqBO;
import com.ohaotian.plugin.model.bo.req.QueryWaitListReqBO;
import com.ohaotian.plugin.model.bo.req.SaveExtIpReqBO;
import com.ohaotian.plugin.model.bo.rsp.AbilityPluginExtIpRspBO;
import com.ohaotian.plugin.model.po.AbilityPluginExtIpPO;
import com.ohaotian.plugin.service.AbilityPluginExtIpService;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.IpCheckUtil;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/ip"})
public class IpController {
    private static Logger logger = LogManager.getLogger(IpController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AppAPI appAPI;
    @Resource
    AbilityPluginExtIpService abilityPluginExtIpService;
    @Resource
    private AuthorityService authorityService;
    private static final String INPUT = "\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}";
    private static final String OUPUT = "\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}";

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug(INPUT, (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug(OUPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfoList"})
    @BusiResponseBody
    public RspBO pluginExtInfoList(@RequestBody QueryWaitListReqBO queryWaitListReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long hirerId = Long.valueOf(authorityUserInfoBO.getTenantId());
        logger.debug(INPUT, (Object)queryWaitListReqBO);
        if (StringUtils.isEmpty((Object)queryWaitListReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        List appBOList = this.appAPI.queryAppByAppNameAndAppCode(queryWaitListReqBO.getAppName(), queryWaitListReqBO.getAppCode(), hirerId);
        List<Object> abilityPluginExtIpRspBOList = new ArrayList();
        if (appBOList != null && appBOList.size() > 0) {
            StringBuilder order = new StringBuilder();
            if (queryWaitListReqBO.getSortName() != null) {
                order.append(queryWaitListReqBO.getSortName());
                if (queryWaitListReqBO.getSortOrder() != null) {
                    order.append(" ");
                    order.append(queryWaitListReqBO.getSortOrder());
                }
            } else {
                order.append(SqlUtil.getDefaultOrderBy());
            }
            Page page = PageMethod.startPage((int)queryWaitListReqBO.getPageNo(), (int)queryWaitListReqBO.getPageSize(), (String)order.toString());
            abilityPluginExtIpRspBOList = this.abilityPluginExtIpService.queryIpWhiteList(queryWaitListReqBO.getPluginId(), queryWaitListReqBO.getClusterId(), appBOList);
            RspPage rspPage = new RspPage(Integer.valueOf(queryWaitListReqBO.getPageSize()), Integer.valueOf(queryWaitListReqBO.getPageNo()), abilityPluginExtIpRspBOList, Long.valueOf(page.getTotal()));
            RspBO rspBO = RspBO.success((Object)rspPage);
            logger.debug(OUPUT, (Object)rspBO);
            return rspBO;
        }
        RspPage rspPage = new RspPage(Integer.valueOf(queryWaitListReqBO.getPageSize()), Integer.valueOf(queryWaitListReqBO.getPageNo()), abilityPluginExtIpRspBOList, Long.valueOf(0L));
        RspBO rspBO = RspBO.success((Object)rspPage);
        logger.debug(OUPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO pluginExtInfo(@RequestBody QueryWaitListReqBO queryWaitListReqBO) {
        logger.debug(INPUT, (Object)queryWaitListReqBO);
        if (StringUtils.isEmpty((Object)queryWaitListReqBO.getPluginIpId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        AbilityPluginExtIpRspBO abilityPluginExtIpRspBO = this.abilityPluginExtIpService.queryPluginExtInfo(queryWaitListReqBO.getPluginIpId());
        RspBO rspBO = RspBO.success((Object)abilityPluginExtIpRspBO);
        logger.debug(OUPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/addPluginExt"})
    @BusiResponseBody
    public RspBO addPluginExt(@RequestBody SaveExtIpReqBO saveExtIpReqBO) {
        return this.abilityPluginExtIpService.addPluginExt(saveExtIpReqBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody SaveExtIpReqBO saveExtIpReqBO) {
        return this.abilityPluginExtIpService.modPluginExt(saveExtIpReqBO);
    }

    @PostMapping(value={"/delPluginExt"})
    @BusiResponseBody
    public RspBO delPluginExt(@RequestBody DelExtIpReqBO delExtIpReqBO) {
        logger.debug(INPUT, (Object)delExtIpReqBO);
        if (delExtIpReqBO.getPluginIpIds().size() < 1) {
            return RspBO.error((String)"\u8bf7\u6307\u5b9a\u9700\u8981\u5220\u9664\u7684\u8bb0\u5f55");
        }
        Integer count = this.abilityPluginExtIpService.deleteAbilityPluginExtIpByIds(delExtIpReqBO.getPluginIpIds());
        if (count < delExtIpReqBO.getPluginIpIds().size()) {
            throw new ZTBusinessException("\u5220\u9664\u5931\u8d25");
        }
        RspBO rspBO = RspBO.success(null);
        logger.debug(OUPUT, (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/qryIpListPage"})
    @BusiResponseBody
    public RspBO qryIpListPage(@RequestBody AbilityPluginExtIpReqBO abilityPluginExtIpReqBO) {
        return this.abilityPluginExtIpService.qryIpListPage(abilityPluginExtIpReqBO);
    }

    @PostMapping(value={"/addIp"})
    @BusiResponseBody
    public RspBO addIp(@RequestBody AbilityPluginExtIpPO abilityPluginExtIpPO, HttpServletRequest httpServletRequest) {
        ValidBatchUtils.isNotEmpty((Object)abilityPluginExtIpPO, (String[])new String[]{"appId", "ipWhileList", "projectId", "environmentId"});
        if (!IpCheckUtil.isIPAddress((String)abilityPluginExtIpPO.getIpWhileList())) {
            throw new ZTBusinessException("ip\u4e0d\u5408\u6cd5");
        }
        abilityPluginExtIpPO.setCreateUserId((Long)httpServletRequest.getSession().getAttribute("userId"));
        abilityPluginExtIpPO.setCreateTime(new Date());
        this.abilityPluginExtIpService.insertSelective(abilityPluginExtIpPO);
        return RspBO.success(null);
    }

    @PostMapping(value={"/deleteIp"})
    @BusiResponseBody
    public RspBO deleteIp(@RequestBody AbilityPluginExtIpPO abilityPluginExtIpPO) {
        ValidBatchUtils.isNotEmpty((Object)abilityPluginExtIpPO, (String[])new String[]{"pluginIpIds"});
        this.abilityPluginExtIpService.deleteAbilityPluginExtIpByIds(abilityPluginExtIpPO.getPluginIpIds());
        return RspBO.success(null);
    }

    @PostMapping(value={"/updateIp"})
    @BusiResponseBody
    public RspBO updateIp(@RequestBody AbilityPluginExtIpPO abilityPluginExtIpPO, HttpServletRequest httpServletRequest) {
        ValidBatchUtils.isNotEmpty((Object)abilityPluginExtIpPO, (String[])new String[]{"pluginIpId", "appId", "ipWhileList", "projectId", "environmentId"});
        abilityPluginExtIpPO.setUpdateUserId((Long)httpServletRequest.getSession().getAttribute("userId"));
        abilityPluginExtIpPO.setUpdateTime(new Date());
        int i = this.abilityPluginExtIpService.updateAbilityPluginExtIpByPluginIpId(abilityPluginExtIpPO);
        if (i < 1) {
            throw new ZTBusinessException("\u4fee\u6539ip\u5931\u8d25");
        }
        return RspBO.success(null);
    }
}

