/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mapper.AbilityPluginJdHpartyCheckMapper;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.task.JdTokenRefreshLogic;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class JdTokenRefreshTask
implements Job {
    private static final Logger log = LogManager.getLogger(JdTokenRefreshTask.class);
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginAPI;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    AdminClusterConfig adminClusterConfig;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (Boolean.FALSE.equals(this.adminClusterConfig.isMaster())) {
            return;
        }
        Long pluginId = (Long)jobExecutionContext.getMergedJobDataMap().get((Object)"parameterData");
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(pluginId);
        JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
        jdHpartyCheckTokenPO.setPluginId(pluginId);
        List<JdHpartyCheckTokenPO> jdHpartyCheckTokenPOS = this.jdHpartyCheckTokenMapper.queryByCond(jdHpartyCheckTokenPO);
        ((Stream)jdHpartyCheckTokenPOS.stream().parallel()).filter(jd -> 1 == jd.getIsRunning() || 2 == jd.getIsRunning()).forEach(jdToken -> JdTokenRefreshLogic.doLogic(this.jdHpartyCheckTokenMapper, this.abilityPluginJdHpartyCheckMapper, this.abilityPluginDeployApi, this.constantBaseVersion, pluginJdHpartyCheckPO, jdToken, this.cacheClient, this.pluginAPI));
    }
}

