/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mapper.AbilityPluginJdHpartyCheckMapper;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.task.JdTokenRefreshLogic;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.ExecutorProcessPool;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class JdTokenRefreshTask
implements Job {
    private static final Logger log = LogManager.getLogger(JdTokenRefreshTask.class);
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginAPI;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    AdminClusterConfig adminClusterConfig;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (Boolean.FALSE.equals(this.adminClusterConfig.isMaster())) {
            return;
        }
        final Long pluginId = (Long)jobExecutionContext.getMergedJobDataMap().get((Object)"parameterData");
        final String now = DateUtil.formatDateWithMS((Date)new Date());
        log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u5f00\u542f\uff01", (Object)now);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PluginJdHpartyCheckPO pluginJdHpartyCheckPO = JdTokenRefreshTask.this.pluginJdHpartyCheckMapper.queryByPluginId(pluginId);
                JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
                jdHpartyCheckTokenPO.setPluginId(pluginId);
                List<JdHpartyCheckTokenPO> jdHpartyCheckTokenPOS = JdTokenRefreshTask.this.jdHpartyCheckTokenMapper.queryByCond(jdHpartyCheckTokenPO);
                ((Stream)jdHpartyCheckTokenPOS.stream().parallel()).filter(jd -> 1 == jd.getIsRunning() || 2 == jd.getIsRunning()).forEach(jdToken -> JdTokenRefreshLogic.doLogic(JdTokenRefreshTask.this.jdHpartyCheckTokenMapper, JdTokenRefreshTask.this.abilityPluginJdHpartyCheckMapper, JdTokenRefreshTask.this.abilityPluginDeployApi, JdTokenRefreshTask.this.constantBaseVersion, pluginJdHpartyCheckPO, jdToken, JdTokenRefreshTask.this.cacheClient, JdTokenRefreshTask.this.pluginAPI));
                log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u7ed3\u675f\uff01", (Object)now);
            }
        };
        ExecutorProcessPool.getInstance().executeByCustomThread(run);
        log.info("{} JD Token \u5f02\u6b65\u7ebf\u7a0b\u6c60\u653e\u5165\uff01", (Object)now);
    }
}

