/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.task.JdTokenRefreshLogic;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.util.DateUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class JdTokenRefreshTask
implements Job {
    private static final Logger log = LogManager.getLogger(JdTokenRefreshTask.class);
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Autowired
    AdminClusterConfig adminClusterConfig;
    @Autowired
    private JdTokenRefreshLogic jdTokenRefreshLogic;
    @Autowired
    private AbilityGeminiService abilityGeminiService;
    @Resource
    PluginAPI pluginAPI;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Long pluginId = (Long)jobExecutionContext.getMergedJobDataMap().get((Object)"parameterData");
        String now = DateUtil.formatDateWithMS((Date)new Date());
        log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u5f00\u542f\uff01", (Object)now);
        CompletableFuture<Void> runFuture = CompletableFuture.runAsync(() -> {
            PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(pluginId);
            JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPO.setPluginId(pluginId);
            List<JdHpartyCheckTokenPO> jdHpartyCheckTokenPOS = this.jdHpartyCheckTokenMapper.queryByCond(jdHpartyCheckTokenPO);
            ((Stream)jdHpartyCheckTokenPOS.stream().parallel()).filter(jd -> 1 == jd.getIsRunning() || 2 == jd.getIsRunning()).forEach(jdToken -> {
                try {
                    this.jdTokenRefreshLogic.doLogic(pluginJdHpartyCheckPO, (JdHpartyCheckTokenPO)jdToken);
                }
                catch (Exception e) {
                    log.error("\u5355\u6b21\u5f02\u5e38\uff01");
                    e.printStackTrace();
                }
            });
            log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u7ed3\u675f\uff01", (Object)now);
            PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginJdHpartyCheckPO.getPluginId());
            if (pluginRspBO.getPluginNotice().equals(1)) {
                AbilityGeminiSendMsgReqBo abilityGeminiSendMsgReqBo = new AbilityGeminiSendMsgReqBo();
                abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
                abilityGeminiSendMsgReqBo.setData("{} JD Token \u5b9a\u65f6\u5237\u65b0\u7ed3\u675f\uff01" + now);
                this.abilityGeminiService.sendMessage(abilityGeminiSendMsgReqBo);
            }
        });
        runFuture.whenComplete((result, e) -> {
            log.error("{} JD Token \u5f02\u6b65\u6267\u884c\u5f02\u5e38\uff01 ex:{}", (Object)now, (Object)e.getMessage());
            e.printStackTrace();
        });
        log.info("{} JD Token \u5f02\u6b65\u6267\u884c\uff01", (Object)now);
    }
}

