/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.rsp.CnncEstoreQryJdPinListRspBO;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.util.HpartyCheckHttpUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class JdHpartyCheckSyncTokenDataHandler {
    private static final Logger log = LogManager.getLogger(JdHpartyCheckSyncTokenDataHandler.class);
    @Value(value="${jd.token.path:http://39.96.39.0/umc/users/signup/login}")
    private String jdTokenPath;
    @Value(value="${jd.token.body:{\"userId\": \"1\",\"vfCode\": \"1111\",\"loginSource\": \"ability\"}}")
    private String jdTokenReqBody;
    @Value(value="${jd.token.account.path:http://39.96.39.0/dyc/common/user/dic/qryOpdcJdPINListPage}")
    private String jdTokenAccountPath;
    @Value(value="${jd.token.account.body:{\"pageNo\":-1,\"orgIdWeb\":\"305775845729763327\",\"publicDicCode\":\"JD_PIN_APP_MODE\"}}")
    private String jdTokenAccountReqBody;
    @Resource
    private JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    private PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;

    @Transactional(rollbackFor={Exception.class})
    public void doLogic() throws Exception {
        List<PluginJdHpartyCheckPO> pluginJdHpartyCheckPOS = this.pluginJdHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginJdHpartyCheckPOS.get(0).getPluginId();
        String authToken = HpartyCheckHttpUtil.doPostJson(this.jdTokenPath, this.jdTokenReqBody, (status, map) -> {
            if (status != 200) {
                log.error("\u8d26\u53f7Token\u83b7\u53d6\u5931\u8d25");
                return "";
            }
            JSONObject rsp = JSON.parseObject((String)map);
            return JSONPath.eval((Object)rsp, (String)"$.data.token").toString();
        });
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        headerMap.put("auth-token", authToken);
        HttpUtil.doPostJson((String)this.jdTokenAccountPath, (String)this.jdTokenAccountReqBody, (status, map) -> {
            if (status != 200) {
                log.error("\u521d\u59cb\u5316\u540c\u6b65\u6570\u636e\u5931\u8d25");
                return null;
            }
            CnncEstoreQryJdPinListRspBO cnncEstoreQryJdPinListRspBO = (CnncEstoreQryJdPinListRspBO)GsonUtil.fromJson((String)map, CnncEstoreQryJdPinListRspBO.class);
            if (Boolean.FALSE.equals(cnncEstoreQryJdPinListRspBO.isSuccess())) {
                log.error("\u521d\u59cb\u5316\u540c\u6b65\u6570\u636e\u5931\u8d25");
                return null;
            }
            List<CnncEstoreQryJdPinListRspBO.CnncEstoreJdPinBO> rows = cnncEstoreQryJdPinListRspBO.getData().getRows();
            log.info("\u6e05\u9664\u5386\u53f2\u83b7\u53d6Pin\u6570\u636e");
            this.jdHpartyCheckTokenMapper.truncate();
            ((Stream)rows.stream().parallel()).forEach(s -> {
                if (StringUtils.isNotBlank((CharSequence)s.getJdPin()) && StringUtils.isNotBlank((CharSequence)s.getJdPinPassword())) {
                    JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
                    jdHpartyCheckTokenPO.setOrgid(s.getOrgId());
                    jdHpartyCheckTokenPO.setCompanyName(s.getOrgName());
                    jdHpartyCheckTokenPO.setUserName(s.getJdPin());
                    jdHpartyCheckTokenPO.setUserPassword(s.getJdPinPassword());
                    jdHpartyCheckTokenPO.setCreateTime(new Date());
                    jdHpartyCheckTokenPO.setPluginId(pluginId);
                    this.jdHpartyCheckTokenMapper.insertSelective(jdHpartyCheckTokenPO);
                }
            });
            log.info("Pin\u6570\u636e\u66f4\u65b0\u5b8c\u6210");
            return null;
        }, headerMap);
    }
}

