/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.task.JdTokenRefreshLogic;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.util.DateUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JdTokenRefresh {
    private static final Logger log = LoggerFactory.getLogger(JdTokenRefresh.class);
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Autowired
    AdminClusterConfig adminClusterConfig;
    @Autowired
    private JdTokenRefreshLogic jdTokenRefreshLogic;
    @Autowired
    private AbilityGeminiService abilityGeminiService;
    @Resource
    private PluginAPI pluginApi;

    public void doRefresh(String pluginIdAndOrgId) {
        String orgId;
        long pluginId;
        String now = DateUtil.formatDateWithMS((Date)new Date());
        if (pluginIdAndOrgId.contains("_")) {
            String[] splits = pluginIdAndOrgId.split("_");
            pluginId = Long.parseLong(splits[0]);
            orgId = splits[1];
        } else {
            pluginId = Long.parseLong(pluginIdAndOrgId);
            orgId = null;
        }
        log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u5f00\u542f\uff01plugin:{} orgId:{}", new Object[]{now, pluginId, orgId});
        CompletableFuture<Void> runFuture = CompletableFuture.runAsync(() -> {
            PluginJdHpartyCheckPO pluginJdHpartyCheckPo = this.pluginJdHpartyCheckMapper.queryByPluginId(pluginId);
            JdHpartyCheckTokenPO jdHpartyCheckTokenPo = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPo.setPluginId(pluginId);
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                jdHpartyCheckTokenPo.setOrgid(orgId);
            }
            List<JdHpartyCheckTokenPO> jdHpartyCheckTokenPos = this.jdHpartyCheckTokenMapper.queryByCond(jdHpartyCheckTokenPo);
            ((Stream)jdHpartyCheckTokenPos.stream().parallel()).filter(jd -> 1 == jd.getIsRunning() || 2 == jd.getIsRunning()).forEach(jdToken -> {
                try {
                    this.jdTokenRefreshLogic.doLogic(pluginJdHpartyCheckPo, (JdHpartyCheckTokenPO)jdToken);
                }
                catch (Exception e) {
                    log.error("\u5355\u6b21\u5f02\u5e38\uff01plugin:{} orgId:{}", (Object)pluginId, (Object)jdToken.getOrgid());
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
            log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u7ed3\u675f\uff01plugin:{} orgId:{}", new Object[]{now, pluginId, orgId});
            PluginRspBO pluginRspBO = this.pluginApi.getPluginInfo(pluginJdHpartyCheckPo.getPluginId());
            if (pluginRspBO.getPluginNotice().equals(1)) {
                AbilityGeminiSendMsgReqBo abilityGeminiSendMsgReqBo = new AbilityGeminiSendMsgReqBo();
                abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
                log.info("{} JD Token \u5b9a\u65f6\u5237\u65b0\u7ed3\u675f\uff01plugin:{} orgId:{}", new Object[]{now, pluginId, orgId});
                this.abilityGeminiService.sendMessage(abilityGeminiSendMsgReqBo);
            }
        });
        runFuture.whenComplete((result, e) -> {
            log.error("{} JD Token \u5f02\u6b65\u6267\u884c\u5f02\u5e38\uff01  plugin:{} orgId:{} ex:{}", new Object[]{now, pluginId, orgId, e.getMessage()});
            log.error(e.getMessage(), e);
        });
        log.info("{} JD Token \u5f02\u6b65\u6267\u884c\uff01plugin:{} orgId:{}", new Object[]{now, pluginId, orgId});
    }
}

