/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginJdHpartyCheckMapper;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBO;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.SyncJdHpartyCheckTokenBO;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.task.JdTokenRefreshTask;
import com.ohaotian.plugin.util.JDToken;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.retry.RetryTokenRefreshService;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GetRandomPwd;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class JdTokenRefreshLogic {
    private static final Logger log = LoggerFactory.getLogger(JdTokenRefreshLogic.class);
    private static final String ACCESS_TOKEN = "access_token";
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Value(value="${jd.token.temporary.cache:180}")
    private int defaultCacheTokenTime;
    @Value(value="${jd.token.auto.refresh.blacklist:\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef,\u672a\u67e5\u8be2\u5230userName\u76f8\u5173\u4fe1\u606f,userName\u4e0eclientId\u4e0d\u5339\u914d}")
    private String autoRefreshBlacklist;
    @Resource
    AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginApi;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    private AbilityGeminiService abilityGeminiService;
    @Autowired
    private RetryTokenRefreshService retryTokenRefreshService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLogic(PluginJdHpartyCheckPO pluginJdHpartyCheckPo, JdHpartyCheckTokenPO jdToken) {
        AbilityGeminiSendMsgReqBo abilityGeminiSendMsgReqBo = new AbilityGeminiSendMsgReqBo();
        PluginRspBO pluginRspBO = this.pluginApi.getPluginInfo(pluginJdHpartyCheckPo.getPluginId());
        String abilityNameAll = pluginRspBO.getPluginName() + "|" + pluginRspBO.getPluginEname() + "|" + pluginRspBO.getPluginNotice();
        abilityGeminiSendMsgReqBo.setPluginName(abilityNameAll.split("\\|")[0] + " " + jdToken.getOrgid());
        String jdResultMap = "";
        try {
            log.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####### jdHpartyCheck ###### START", (Object)abilityNameAll);
            String cacheTokenSuffix = pluginJdHpartyCheckPo.getRegionCode() + "-" + jdToken.getUserName();
            String cacheTokenKey = this.constantBaseVersion.getATP() + "JdTokenCache-" + cacheTokenSuffix;
            Object cacheTokenValue = this.cacheClient.get(cacheTokenKey);
            String cacheTokenDurationKey = this.constantBaseVersion.getATP() + "JdTokenDurationCache-" + cacheTokenSuffix;
            Object cacheTokenDurationValue = this.cacheClient.get(cacheTokenDurationKey);
            if (ObjectUtils.isEmpty((Object)cacheTokenValue) || ObjectUtils.isEmpty((Object)cacheTokenDurationValue)) {
                RefreshTokenReqBO refreshTokenReqBO = (RefreshTokenReqBO)BeanMapper.map((Object)pluginJdHpartyCheckPo, RefreshTokenReqBO.class);
                refreshTokenReqBO.setUserName(jdToken.getUserName());
                refreshTokenReqBO.setUserPassword(jdToken.getUserPassword());
                LocalDateTime now = LocalDateTime.now();
                DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                refreshTokenReqBO.setTimestamp(now.format(ofPattern));
                refreshTokenReqBO.setGrantType(ACCESS_TOKEN);
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("Content-Type", "application/x-www-form-urlencoded");
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("client_id", refreshTokenReqBO.getClientId());
                paramsMap.put("client_secret", refreshTokenReqBO.getClientSecret());
                paramsMap.put("username", refreshTokenReqBO.getUserName());
                paramsMap.put("grant_type", ACCESS_TOKEN);
                paramsMap.put("timestamp", refreshTokenReqBO.getTimestamp());
                String password = JDToken.getMD5Str(refreshTokenReqBO.getUserPassword());
                String sign = refreshTokenReqBO.getClientSecret() + refreshTokenReqBO.getTimestamp() + refreshTokenReqBO.getClientId() + refreshTokenReqBO.getUserName() + password + ACCESS_TOKEN + refreshTokenReqBO.getClientSecret();
                sign = JDToken.getMD5Str(sign).toUpperCase();
                paramsMap.put("sign", sign);
                paramsMap.put("password", password);
                paramsMap.put("reStr", GetRandomPwd.makeRandomPwd((int)8));
                log.info("\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson((Object)pluginJdHpartyCheckPo));
                log.info("\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson(paramsMap));
                HttpUtil.doPost((String)pluginJdHpartyCheckPo.getTokenPath(), (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)jdToken));
                        throw new RuntimeException("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0c\u72b6\u6001\uff1a" + status + " \u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c\uff1a" + map);
                    }
                    RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                    log.info("token\u5237\u65b0\u6210\u529f: \u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                    if (!refreshTokenRspBO.isSuccess()) {
                        log.error("token\u5237\u65b0\u9519\u8bef: token\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)jdToken));
                        throw new RuntimeException("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0c\u72b6\u6001\uff1a" + status + " \u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c\uff1a" + map);
                    }
                    long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = refreshTokenRspBO.getResult().getAccess_token();
                    if (this.defaultCacheTokenTime > 0) {
                        this.cacheClient.set(cacheTokenKey, (Object)token, this.defaultCacheTokenTime);
                        this.cacheClient.set(cacheTokenDurationKey, (Object)duration, this.defaultCacheTokenTime);
                    } else {
                        log.warn("\u4eac\u4e1c\u9274\u6743\u5237\u65b0\u7f13\u5b58\u4fdd\u5b58\u65f6\u95f4({}s) \u6709\u95ee\u9898\uff0c\u8df3\u8fc7\u4fdd\u5b58\u7f13\u5b58\uff01", (Object)this.defaultCacheTokenTime);
                    }
                    jdToken.setAccessToken(token);
                    this.updateToken(jdToken, new Date(time.getTime() + duration));
                    this.setTokenToRedisAndVerification(pluginJdHpartyCheckPo, jdToken, token);
                    abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
                    return status;
                }, paramsMap);
            } else {
                String token = String.valueOf(cacheTokenValue);
                long duration = Long.parseLong(String.valueOf(cacheTokenDurationValue));
                log.info("token\u7f13\u5b58\u83b7\u53d6\u6210\u529f\uff0ctoken\u503c:{}", (Object)token);
                jdToken.setAccessToken(token);
                Date time = new Date();
                this.updateToken(jdToken, new Date(time.getTime() + duration));
                this.setTokenToRedisAndVerification(pluginJdHpartyCheckPo, jdToken, token);
                abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
            }
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5f02\u5e38: token\u8bb0\u5f55id:{},ex:{}", (Object)JSON.toJSONString((Object)jdToken), (Object)e);
            jdToken.setAccessToken(e.getMessage());
            this.updateErrorToken(jdToken);
            abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
            abilityGeminiSendMsgReqBo.setErrorMsg(e.getMessage());
            if (Objects.equals(abilityNameAll.split("\\|")[2], String.valueOf(1))) {
                RspBO rspBO = (RspBO)this.abilityGeminiService.sendMessage(abilityGeminiSendMsgReqBo);
                log.info("\u901a\u77e5\u7ed3\u679c\uff1a{}", (Object)rspBO);
            }
        }
        finally {
            List<String> blacklists = Arrays.asList(this.autoRefreshBlacklist.split(","));
            AtomicReference<Boolean> autoRefreshFlag = new AtomicReference<Boolean>(Boolean.TRUE);
            Optional.ofNullable(abilityGeminiSendMsgReqBo.getErrorMsg()).map(errorMsg -> blacklists.stream().filter(black -> black != null && errorMsg.contains((CharSequence)black)).findFirst()).orElse(Optional.of("")).flatMap(black -> {
                if (StringUtils.isNotBlank((CharSequence)black)) {
                    autoRefreshFlag.set(Boolean.FALSE);
                    log.warn("\u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c\u5305\u542b:{} \u8df3\u8fc7\u9274\u6743\u5931\u8d25\u81ea\u52a8\u91cd\u5237", black);
                }
                return Optional.empty();
            });
            if (Boolean.FALSE.equals(abilityGeminiSendMsgReqBo.isStatus()) && Boolean.TRUE.equals(autoRefreshFlag.get())) {
                this.retryTokenRefreshService.startJob(pluginJdHpartyCheckPo.getPluginId(), jdToken.getOrgid(), (Object)(pluginJdHpartyCheckPo.getPluginId() + "_" + jdToken.getOrgid()), JdTokenRefreshTask.class);
            } else {
                this.retryTokenRefreshService.closeJob(pluginJdHpartyCheckPo.getPluginId(), jdToken.getOrgid(), JdTokenRefreshTask.class);
            }
            log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
        }
    }

    private void setTokenToRedisAndVerification(PluginJdHpartyCheckPO pluginJdHpartyCheckPo, JdHpartyCheckTokenPO jdToken, String token) {
        List abilityPluginDeployRspBOList;
        log.info("token\u5237\u65b0\u6210\u529f: \u63d2\u4ef6\u5206\u533a:{}", (Object)pluginJdHpartyCheckPo.getRegionCode());
        log.info("token\u5237\u65b0\u6210\u529f: token\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)jdToken));
        log.info("token\u5237\u65b0\u6210\u529f: token\u503c:{}", (Object)token);
        this.setRedis(pluginJdHpartyCheckPo, jdToken);
        List<Long> abilityPluginDeployIds = this.abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
        if (!abilityPluginDeployIds.isEmpty() && (abilityPluginDeployRspBOList = this.abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && !abilityPluginDeployRspBOList.isEmpty()) {
            abilityPluginDeployRspBOList.stream().map(AbilityPluginDeployRspBO::getClusterId).forEach(i -> {
                String key = this.getRedisKey((Long)i, jdToken.getOrgid());
                if (ObjectUtils.isEmpty((Object)this.cacheClient.get(key))) {
                    log.error("redis\u5237\u65b0\u9519\u8bef:\u65e0\u6cd5\u83b7\u53d6\u5237\u5165\u6570\u636e\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)jdToken));
                    throw new RuntimeException("redis\u5237\u65b0\u9519\u8bef: \u65e0\u6cd5\u83b7\u53d6\u5237\u5165\u6570\u636e key: " + key);
                }
            });
        }
    }

    private void updateToken(JdHpartyCheckTokenPO jdHpartyCheckTokenPo, Date expiresIn) {
        jdHpartyCheckTokenPo.setIsRunning(1);
        jdHpartyCheckTokenPo.setExpiresIn(expiresIn);
        jdHpartyCheckTokenPo.setUpdateTime(new Date());
        this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPo);
    }

    private void updateErrorToken(JdHpartyCheckTokenPO jdHpartyCheckTokenPo) {
        jdHpartyCheckTokenPo.setIsRunning(2);
        jdHpartyCheckTokenPo.setUpdateTime(new Date());
        jdHpartyCheckTokenPo.setCreateTime(new Date());
        this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPo);
    }

    private void setRedis(PluginJdHpartyCheckPO pluginJdHpartyCheckPo, JdHpartyCheckTokenPO jdHpartyCheckTokenPo) {
        List abilityPluginDeployRspBos;
        List<Long> abilityPluginDeployIds = this.abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
        SyncJdHpartyCheckTokenBO syncJdHpartyCheckTokenBO = (SyncJdHpartyCheckTokenBO)BeanMapper.map((Object)jdHpartyCheckTokenPo, SyncJdHpartyCheckTokenBO.class);
        syncJdHpartyCheckTokenBO.setClientId(pluginJdHpartyCheckPo.getClientId());
        syncJdHpartyCheckTokenBO.setRegionCode(pluginJdHpartyCheckPo.getRegionCode());
        if (!abilityPluginDeployIds.isEmpty() && (abilityPluginDeployRspBos = this.abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && !abilityPluginDeployRspBos.isEmpty()) {
            abilityPluginDeployRspBos.stream().map(AbilityPluginDeployRspBO::getClusterId).distinct().forEach(i -> {
                String key = this.getRedisKey((Long)i, jdHpartyCheckTokenPo.getOrgid());
                AbilityRedisTokenDataBo abilityRedisTokenDataBo = new AbilityRedisTokenDataBo();
                abilityRedisTokenDataBo.setPluginId(syncJdHpartyCheckTokenBO.getPluginId().toString());
                abilityRedisTokenDataBo.setClientId(syncJdHpartyCheckTokenBO.getClientId());
                abilityRedisTokenDataBo.setClientSecret("");
                abilityRedisTokenDataBo.setAccName("");
                abilityRedisTokenDataBo.setCallProtocol(pluginJdHpartyCheckPo.getCallProtocol());
                abilityRedisTokenDataBo.setTokenPath("");
                abilityRedisTokenDataBo.setToken(syncJdHpartyCheckTokenBO.getAccessToken());
                abilityRedisTokenDataBo.setRefreshInterval("");
                abilityRedisTokenDataBo.setTokenPosition(Integer.valueOf(0));
                abilityRedisTokenDataBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
                abilityRedisTokenDataBo.setHsn("");
                abilityRedisTokenDataBo.setOrgId(jdHpartyCheckTokenPo.getOrgid());
                abilityRedisTokenDataBo.setCompanyName("");
                abilityRedisTokenDataBo.setRegionCode(syncJdHpartyCheckTokenBO.getRegionCode());
                abilityRedisTokenDataBo.setAppends("");
                String value = GsonUtil.toJson((Object)abilityRedisTokenDataBo);
                this.cacheClient.set(key, (Object)value);
                this.cacheClient.expire(key, 86400);
                log.info("redis\u5199\u5165\uff0ckey\uff1a{}", (Object)key);
            });
        }
    }

    private String getRedisKey(Long clusterId, String orgId) {
        return this.constantBaseVersion.getATP() + "jdHpartyCheck-" + clusterId + "-" + orgId;
    }
}

