/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.atp.base.model.TokenRefreshBo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mapper.AbilityPluginJdHpartyCheckMapper;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.po.AbilityPluginJdHpartyCheckPO;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.task.JdTokenRefreshLogic;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
@PluginTypeHandlerType(value="jdHpartyCheck", position=ExtensionPointPositionEnum.ABILITY_POSITION)
public class AbilityJdHpartyCheckHandler
extends AbstractPluginHandler<Object> {
    private static final Logger log = LogManager.getLogger(AbilityJdHpartyCheckHandler.class);
    private static final String URL = "/ability/updatePluginHpartyCheck";
    private static final String TITLE = "\u843d\u5730\u6821\u9a8c\u7ed1\u5b9a\u5173\u7cfb\u6269\u5c55\u4fe1\u606f";
    private static final String COMPONENT_TYPE = "plugin-binding-luodi";
    @Resource
    AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Autowired
    CacheClient cacheClient;
    @Autowired
    private JdTokenRefreshLogic jdTokenRefreshLogic;

    @Transactional
    public RspBO handleAdd(Object object) throws ZTBusinessException {
        try {
            Map objectMap = (Map)object;
            Long abilityPluginDeployId = Long.parseLong(objectMap.get("abilityPluginDeployId") + "");
            Long pluginId = Long.parseLong(objectMap.get("pluginId") + "");
            AbilityPluginJdHpartyCheckPO abilityPluginJdHpartyCheckPO = new AbilityPluginJdHpartyCheckPO();
            abilityPluginJdHpartyCheckPO.setAbilityPluginDeployId(abilityPluginDeployId);
            this.abilityPluginJdHpartyCheckMapper.insertSelective(abilityPluginJdHpartyCheckPO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO<Object> handleDelete(Object object) {
        Long abilityPluginDeployId = (Long)object;
        this.abilityPluginJdHpartyCheckMapper.deleteHpartyCheckByPluginDeployId(abilityPluginDeployId);
        return RspBO.success((Object)true);
    }

    public RspBO handleTokenRefresh(Object data) throws ZTBusinessException {
        try {
            TokenRefreshBo tokenRefreshBo = (TokenRefreshBo)GsonUtil.fromJson((String)GsonUtil.toJson((Object)data), TokenRefreshBo.class);
            for (Long pluginId : tokenRefreshBo.getPluginIds()) {
                JdHpartyCheckTokenPO tokenPo;
                PluginJdHpartyCheckPO entity = new PluginJdHpartyCheckPO();
                entity.setPluginId(pluginId);
                if (!(entity = this.pluginJdHpartyCheckMapper.queryLimitOne(entity)).getTaskSwitch().equals(Constants.Switch.ON) || ObjectUtils.isEmpty((Object)(tokenPo = this.isExist(pluginId, tokenRefreshBo.getOrgId())))) continue;
                this.jdTokenRefreshLogic.doLogic(entity, tokenPo);
                log.info("\u63d2\u4ef6:{}  orgId:{} \u5237\u65b0\u5b8c\u6210!", (Object)entity.getPluginId(), (Object)tokenRefreshBo.getOrgId());
            }
            return RspBO.success((Object)"\u5237\u65b0\u5b8c\u6210");
        }
        catch (Exception e) {
            return RspBO.error((String)("\u5237\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private JdHpartyCheckTokenPO isExist(Long pluginId, String orgId) {
        JdHpartyCheckTokenPO hpartyCheckTokenPO = new JdHpartyCheckTokenPO();
        hpartyCheckTokenPO.setPluginId(pluginId);
        hpartyCheckTokenPO.setOrgid(orgId);
        return this.jdHpartyCheckTokenMapper.queryLimitOne(hpartyCheckTokenPO);
    }
}

