/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.JdHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTokenListTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTokenTaskReqBO;
import com.ohaotian.plugin.model.bo.rsp.PluginJdHpartyCheckRspBO;
import com.ohaotian.plugin.model.bo.rsp.ResponseVO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.service.JdHpartyCheckService;
import com.ohaotian.plugin.service.JdHpartyCheckSyncTokenDataHandler;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.RefreshTokenPath;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/jdHpartyCheck"})
public class JdHpartyCheckController {
    private static Logger logger = LogManager.getLogger(JdHpartyCheckController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AppAPI appAPI;
    @Resource
    RegionAPI regionAPI;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Resource
    private AuthorityService authorityService;
    @Resource
    private JdHpartyCheckService jdHpartyCheckService;
    @Resource
    private JdHpartyCheckSyncTokenDataHandler jdHpartyCheckSyncTokenDataHandler;
    @Autowired
    private RefreshTokenPath refreshTokenPath;
    private static final String INPUT = "\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}";
    private static final String PLUGIN_IP = "\u672a\u6307\u5b9a\u63d2\u4ef6id";
    private static final String TOKEN_ID = "\u672a\u6307\u5b9atokenid";

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug(INPUT, (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO getPluginExtInfo(@RequestBody PluginJdHpartyCheckReqBO pluginJdHpartyCheckReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        logger.debug(INPUT, (Object)pluginJdHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = new PluginJdHpartyCheckPO();
        pluginJdHpartyCheckPO.setPluginId(pluginJdHpartyCheckReqBO.getPluginId());
        pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryLimitOne(pluginJdHpartyCheckPO);
        PluginJdHpartyCheckRspBO pluginJdHpartyCheckRspBO = (PluginJdHpartyCheckRspBO)BeanMapper.map((Object)pluginJdHpartyCheckPO, PluginJdHpartyCheckRspBO.class);
        AppBO appBO = this.appAPI.queryAppByRegionCode(tenantId, pluginJdHpartyCheckPO.getRegionCode());
        RegionBO regionBO = this.regionAPI.queryRegionByAppIdAndRegionCode(appBO.getAppId(), pluginJdHpartyCheckPO.getRegionCode());
        pluginJdHpartyCheckRspBO.setAppId(appBO.getAppId());
        pluginJdHpartyCheckRspBO.setAppRegionName(appBO.getAppName() + "/" + regionBO.getRegionName());
        String[] appRegion = new String[]{appBO.getAppId().toString(), regionBO.getRegionCode()};
        pluginJdHpartyCheckRspBO.setAppRegion(appRegion);
        pluginJdHpartyCheckRspBO.setTokenPath(this.refreshTokenPath.getAll(pluginJdHpartyCheckRspBO.getTokenPath(), "/plat/template/noauth/jdHpartyCheck/accessToken", pluginJdHpartyCheckPO.getRegionCode()));
        return RspBO.success((Object)pluginJdHpartyCheckRspBO);
    }

    @PostMapping(value={"/pluginExtInfoList"})
    @BusiResponseBody
    public RspBO getPluginExtInfoList(@RequestBody PluginJdHpartyCheckTokenReqBO pluginJdHpartyCheckTokenReqBO) {
        logger.debug(INPUT, (Object)pluginJdHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckTokenReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        return this.jdHpartyCheckService.getPluginExtInfoList(pluginJdHpartyCheckTokenReqBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody PluginJdHpartyCheckReqBO pluginJdHpartyCheckReqBO) {
        logger.debug(INPUT, (Object)pluginJdHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginJdHpartyCheckReqBO.getAppRegion() == null || pluginJdHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aefid");
        }
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginJdHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginJdHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = (PluginJdHpartyCheckPO)BeanMapper.map((Object)pluginJdHpartyCheckReqBO, PluginJdHpartyCheckPO.class);
        pluginJdHpartyCheckPO.setRegionCode(pluginJdHpartyCheckReqBO.getAppRegion()[1]);
        pluginJdHpartyCheckPO.setCallProtocol(0);
        this.pluginJdHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginJdHpartyCheckPO);
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"executeAll"})
    @BusiResponseBody
    public RspBO executeAll(@RequestBody PluginJdHpartyCheckTaskReqBO pluginJdHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException(PLUGIN_IP);
        }
        return this.jdHpartyCheckService.executeAll(pluginJdHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"execute"})
    @BusiResponseBody
    public RspBO execute(@RequestBody PluginJdHpartyCheckTokenTaskReqBO pluginJdHpartyCheckTokenTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckTokenTaskReqBO.getJdHpartyCheckTokenId())) {
            throw new ZTBusinessException(TOKEN_ID);
        }
        return this.jdHpartyCheckService.execute(pluginJdHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"start"})
    @BusiResponseBody
    public RspBO start(@RequestBody PluginJdHpartyCheckTaskReqBO pluginJdHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException(PLUGIN_IP);
        }
        return this.jdHpartyCheckService.start(pluginJdHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"stop"})
    @BusiResponseBody
    public RspBO stop(@RequestBody PluginJdHpartyCheckTaskReqBO pluginJdHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginJdHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException(PLUGIN_IP);
        }
        return this.jdHpartyCheckService.stop(pluginJdHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"modifycompanymsg"})
    @BusiResponseBody
    public ResponseVO modifycompanymsg(@RequestBody JdHpartyCheckTokenReqBO jdHpartyCheckTokenReqBO) {
        if (StringUtils.isEmpty((Object)jdHpartyCheckTokenReqBO.getOrgid())) {
            return ResponseVO.error("\u672a\u6307\u5b9aOrgid");
        }
        if (StringUtils.isEmpty((Object)((Object)jdHpartyCheckTokenReqBO.getType()))) {
            return ResponseVO.error("\u672a\u6307\u5b9atype");
        }
        switch (jdHpartyCheckTokenReqBO.getType()) {
            case put: {
                return this.jdHpartyCheckService.put(jdHpartyCheckTokenReqBO);
            }
            case delete: {
                return this.jdHpartyCheckService.delete(jdHpartyCheckTokenReqBO);
            }
            case modify: {
                return this.jdHpartyCheckService.modify(jdHpartyCheckTokenReqBO);
            }
        }
        throw new ZTBusinessException("\u672a\u6307\u5b9atype");
    }

    @PostMapping(value={"checkIn"})
    @BusiResponseBody
    public RspBO checkIn(@RequestBody PluginJdHpartyCheckTokenListTaskReqBO pluginJdHpartyCheckTokenTaskReqBO) {
        if (pluginJdHpartyCheckTokenTaskReqBO == null || pluginJdHpartyCheckTokenTaskReqBO.getJdHpartyCheckTokenIds().size() < 1) {
            throw new ZTBusinessException(TOKEN_ID);
        }
        return this.jdHpartyCheckService.checkIn(pluginJdHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"checkOut"})
    @BusiResponseBody
    public RspBO checkOut(@RequestBody PluginJdHpartyCheckTokenListTaskReqBO pluginJdHpartyCheckTokenTaskReqBO) {
        if (pluginJdHpartyCheckTokenTaskReqBO == null || pluginJdHpartyCheckTokenTaskReqBO.getJdHpartyCheckTokenIds().size() < 1) {
            throw new ZTBusinessException(TOKEN_ID);
        }
        return this.jdHpartyCheckService.checkOut(pluginJdHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"update"})
    @BusiResponseBody
    public RspBO update(@RequestBody PluginJdHpartyCheckTokenListTaskReqBO pluginJdHpartyCheckTokenTaskReqBO) {
        logger.info("\u521d\u59cb\u5316\u540c\u6b65\u6570\u636e\uff01\uff01\uff01");
        try {
            this.jdHpartyCheckSyncTokenDataHandler.doLogic();
            return RspBO.success((Object)"\u89e6\u53d1\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return RspBO.error((String)"\u6267\u884c\u5931\u8d25\uff01");
        }
    }
}

