/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.service.impl;

import com.alibaba.excel.util.ObjectUtils;
import com.ohaotian.logplatform.config.ElasticSearchConfig;
import com.ohaotian.logplatform.model.req.QueryDataReqBO;
import com.ohaotian.logplatform.model.rsp.CalculatTimeBO;
import com.ohaotian.logplatform.model.rsp.CaluclatTimeListBO;
import com.ohaotian.logplatform.model.rsp.ExceptionLogRspBo;
import com.ohaotian.logplatform.model.rsp.GetAvgTimeBO;
import com.ohaotian.logplatform.model.rsp.GetErrorMessageBO;
import com.ohaotian.logplatform.model.rsp.GetLogBO;
import com.ohaotian.logplatform.model.rsp.GetTimeBO;
import com.ohaotian.logplatform.service.LogTransactionService;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.DateUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogTransactionServiceImpl
implements LogTransactionService {
    private static final Logger log = LoggerFactory.getLogger(LogTransactionServiceImpl.class);
    @Autowired
    private RestHighLevelClient client;
    private final RequestOptions options = RequestOptions.DEFAULT;
    @Autowired
    private ElasticSearchConfig elasticSearchConfig;

    public boolean checkIndex(String index) throws Exception {
        try {
            return this.client.indices().exists(new GetIndexRequest(new String[]{index}), this.options);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private BoolQueryBuilder buildBoolQuery(String indexName, QueryDataReqBO queryDataReqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getAbilityName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"abilityName", (Object)queryDataReqBO.getAbilityName()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getAbilityEname())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"abilityEname", (Object)queryDataReqBO.getAbilityEname()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getInputProtocal())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"inputProtocal", (Object)queryDataReqBO.getInputProtocal()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getOutputProtocal())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"outputProtocal", (Object)queryDataReqBO.getOutputProtocal()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getTraceId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"traceId", (Object)queryDataReqBO.getTraceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getBusinessCenterCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"businessCenterCode", (Object)queryDataReqBO.getBusinessCenterCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getEnTering())) {
            queryDataReqBO.setEnTering(queryDataReqBO.getEnTering().replace("\"", "'"));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"requestMessage.keyword", (String)("*" + queryDataReqBO.getEnTering() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getGinSeng())) {
            queryDataReqBO.setGinSeng(queryDataReqBO.getGinSeng().replace("\"", "'"));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"respondMessage.keyword", (String)("*" + queryDataReqBO.getGinSeng() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getErrorType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"errorType", (Object)queryDataReqBO.getErrorType()));
        }
        if (queryDataReqBO.getTimes() != null) {
            if (indexName.equals(this.elasticSearchConfig.getReqInIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"joinTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            } else if (indexName.equals(this.elasticSearchConfig.getReqOutIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"respondTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            } else if (indexName.equals(this.elasticSearchConfig.getRspInIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"sendTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            } else if (indexName.equals(this.elasticSearchConfig.getRspOutIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"receiveTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            }
        }
        if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getStarTime()) && !ObjectUtils.isEmpty((Object)queryDataReqBO.getEndTime())) {
            if (indexName.equals(this.elasticSearchConfig.getExceptionIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"joinTime.keyword").gte((Object)queryDataReqBO.getStarTime()).lte((Object)queryDataReqBO.getEndTime()));
            } else if (indexName.equals(this.elasticSearchConfig.getReqInIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"joinTime.keyword").gte((Object)queryDataReqBO.getStarTime()).lte((Object)queryDataReqBO.getEndTime()));
            }
        }
        if (queryDataReqBO.getTraceIds() != null) {
            if (queryDataReqBO.getTraceIds().size() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"traceId", (Object)queryDataReqBO.getTraceIds().get(0)));
            } else if (queryDataReqBO.getTraceIds().size() > 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"traceId.keyword").gte((Object)queryDataReqBO.getTraceIds().get(0)).lte((Object)queryDataReqBO.getTraceIds().get(1)));
            }
        }
        return boolQueryBuilder;
    }

    @Override
    public RspBO getIndex(String indexName, QueryDataReqBO queryDataReqBO) throws Exception {
        int pageNo = queryDataReqBO.getPageNo();
        int pageSize = queryDataReqBO.getPageSize();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.explain(Boolean.TRUE).from((pageNo - 1) * pageSize).size(pageSize);
        BoolQueryBuilder boolQueryBuilder = this.buildBoolQuery(indexName, queryDataReqBO);
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.sort("@timestamp", SortOrder.DESC);
        sourceBuilder.trackTotalHits(true);
        searchRequest.source(sourceBuilder);
        try {
            SearchHit[] searchHitArr;
            SearchResponse searchResp = this.client.search(searchRequest, this.options);
            ArrayList<Map> data = new ArrayList<Map>();
            for (SearchHit searchHit : searchHitArr = searchResp.getHits().getHits()) {
                Map temp = searchHit.getSourceAsMap();
                temp.put("id", searchHit.getId());
                data.add(temp);
            }
            RspPage rspPage = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), data, Long.valueOf(searchResp.getHits().getTotalHits().value));
            return RspBO.success((Object)rspPage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RspBO.error((String)"\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    @Override
    public RspBO getReqIn(QueryDataReqBO queryDataReqBO) throws Exception {
        return this.getIndex(this.elasticSearchConfig.getReqInIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getReqOut(QueryDataReqBO queryDataReqBO) throws Exception {
        return this.getIndex(this.elasticSearchConfig.getReqOutIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getRspIn(QueryDataReqBO queryDataReqBO) throws Exception {
        return this.getIndex(this.elasticSearchConfig.getRspInIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getRspOut(QueryDataReqBO queryDataReqBO) throws Exception {
        return this.getIndex(this.elasticSearchConfig.getRspOutIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getAvgTime(QueryDataReqBO queryDataReqBO) throws Exception {
        ArrayList<GetAvgTimeBO> list = new ArrayList<GetAvgTimeBO>();
        Double total = 0.0;
        Double totalReq = 0.0;
        Double totalRsp = 0.0;
        int n = 0;
        ArrayList<GetTimeBO> list1 = new ArrayList<GetTimeBO>();
        for (String traceId : queryDataReqBO.getTraceIds()) {
            QueryDataReqBO queryDataReqBO1 = new QueryDataReqBO();
            queryDataReqBO1.setTraceId(traceId);
            CalculatTimeBO calculatTimeBO = new CalculatTimeBO();
            GetAvgTimeBO getAvgTimeBO = new GetAvgTimeBO();
            RspPage rspPage1 = (RspPage)this.getReqIn(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage1.getRows())) continue;
            HashMap hashMap1 = (HashMap)rspPage1.getRows().get(0);
            calculatTimeBO.setJoinTime(hashMap1.get("joinTime").toString());
            getAvgTimeBO.setTraceId(hashMap1.get("traceId").toString());
            RspPage rspPage2 = (RspPage)this.getRspIn(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage2.getRows())) continue;
            HashMap hashMap2 = (HashMap)rspPage2.getRows().get(0);
            calculatTimeBO.setSendTime(hashMap2.get("sendTime").toString());
            RspPage rspPage3 = (RspPage)this.getReqOut(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage3.getRows())) continue;
            HashMap hashMap3 = (HashMap)rspPage3.getRows().get(0);
            calculatTimeBO.setRespondTime(hashMap3.get("respondTime").toString());
            RspPage rspPage4 = (RspPage)this.getRspOut(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage4.getRows())) continue;
            HashMap hashMap4 = (HashMap)rspPage4.getRows().get(0);
            calculatTimeBO.setReceiveTime(hashMap4.get("receiveTime").toString());
            getAvgTimeBO.setBigTotalTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getRespondTime()));
            total = total + (double)getAvgTimeBO.getBigTotalTime().longValue();
            getAvgTimeBO.setReqTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getReceiveTime()));
            totalReq = totalReq + (double)getAvgTimeBO.getReqTime().longValue();
            getAvgTimeBO.setRspTime(this.TimeDifference(calculatTimeBO.getSendTime(), calculatTimeBO.getReceiveTime()));
            totalRsp = totalRsp + (double)getAvgTimeBO.getRspTime().longValue();
            list.add(getAvgTimeBO);
            ++n;
        }
        if (!ObjectUtils.isEmpty(list)) {
            GetTimeBO getTimeBO = new GetTimeBO();
            getTimeBO.setAvgTotalTime(total / (double)n);
            getTimeBO.setAvgReqTime(totalReq / (double)n);
            getTimeBO.setAvgRspTime(totalRsp / (double)n);
            list1.add(getTimeBO);
            list.sort(Comparator.comparing(GetAvgTimeBO::getBigTotalTime));
            list1.add((GetTimeBO)list.get(0));
            list1.add((GetTimeBO)list.get(list.size() - 1));
        }
        return RspBO.success(list1);
    }

    @Override
    public RspBO getErrorData(QueryDataReqBO queryDataReqBO) throws Exception {
        HashMap hashMap;
        RspPage rspPage;
        if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getEnTering()) && !ObjectUtils.isEmpty((Object)(rspPage = (RspPage)this.getReqIn(queryDataReqBO).getData()).getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            queryDataReqBO.setTraceId(hashMap.get("traceId").toString());
        }
        if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getGinSeng()) && !ObjectUtils.isEmpty((Object)(rspPage = (RspPage)this.getReqOut(queryDataReqBO).getData()).getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            queryDataReqBO.setTraceId(hashMap.get("traceId").toString());
        }
        rspPage = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
        ArrayList<GetLogBO> list = new ArrayList<GetLogBO>();
        for (int i = 0; i < rspPage.getPageCout(); ++i) {
            RspPage rspPage4;
            RspPage rspPage3;
            RspPage rspPage2;
            GetLogBO getLogBO = new GetLogBO();
            HashMap hashMap2 = (HashMap)rspPage.getRows().get(i);
            QueryDataReqBO queryDataReqBO1 = new QueryDataReqBO();
            queryDataReqBO1.setTraceId(hashMap2.get("traceId").toString());
            getLogBO.setErrorType(hashMap2.get("errorType").toString());
            RspPage rspPage1 = (RspPage)this.getReqIn(queryDataReqBO1).getData();
            if (!ObjectUtils.isEmpty((Object)rspPage1.getRows())) {
                HashMap hashMap1 = (HashMap)rspPage1.getRows().get(0);
                getLogBO.setTraceId(hashMap1.get("traceId").toString());
                getLogBO.setRequestMessage(hashMap1.get("requestMessage").toString());
                getLogBO.setRequestMessage(getLogBO.getRequestMessage());
                getLogBO.setJoinTime(hashMap1.get("joinTime").toString());
                getLogBO.setBusinessCenterCode(hashMap1.get("businessCenterCode").toString());
            }
            if (!ObjectUtils.isEmpty((Object)(rspPage2 = (RspPage)this.getRspIn(queryDataReqBO1).getData()).getRows())) {
                HashMap hashMap22 = (HashMap)rspPage2.getRows().get(0);
                getLogBO.setSendMessage(hashMap22.get("sendMessage").toString());
                getLogBO.setSendMessage(getLogBO.getSendMessage());
            }
            if (!ObjectUtils.isEmpty((Object)(rspPage3 = (RspPage)this.getReqOut(queryDataReqBO1).getData()).getRows())) {
                HashMap hashMap3 = (HashMap)rspPage3.getRows().get(0);
                getLogBO.setRespondMessage(hashMap3.get("respondMessage").toString());
                getLogBO.setRespondMessage(getLogBO.getRespondMessage());
                getLogBO.setRespondTime(hashMap3.get("respondTime").toString());
            }
            if (!ObjectUtils.isEmpty((Object)(rspPage4 = (RspPage)this.getRspOut(queryDataReqBO1).getData()).getRows())) {
                HashMap hashMap4 = (HashMap)rspPage4.getRows().get(0);
                getLogBO.setRecieveMessage(hashMap4.get("recieveMessage").toString());
                getLogBO.setRecieveMessage(getLogBO.getRecieveMessage());
            }
            list.add(getLogBO);
        }
        RspPage rspPage2 = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), list, rspPage.getRecordsTotal());
        return RspBO.success((Object)rspPage2);
    }

    @Override
    public RspBO queryExcept(QueryDataReqBO queryDataReqBO) throws Exception {
        GetErrorMessageBO getErrorMessageBO = new GetErrorMessageBO();
        RspPage rspPage = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
        if (ObjectUtils.isEmpty((Object)rspPage.getRows())) {
            return RspBO.success((Object)getErrorMessageBO);
        }
        HashMap hashMap = (HashMap)rspPage.getRows().get(0);
        getErrorMessageBO.setResultMessage(hashMap.get("resultMessage").toString());
        getErrorMessageBO.setResultMessage(getErrorMessageBO.getResultMessage());
        return RspBO.success((Object)getErrorMessageBO);
    }

    @Override
    public RspBO getLogData(QueryDataReqBO queryDataReqBO) throws Exception {
        ArrayList<GetLogBO> list = new ArrayList<GetLogBO>();
        RspPage rspPage = (RspPage)this.getReqIn(queryDataReqBO).getData();
        for (int i = 0; i < rspPage.getRows().size(); ++i) {
            RspPage rspPage4;
            RspPage rspPage3;
            RspPage rspPage2;
            HashMap hashMap = (HashMap)rspPage.getRows().get(i);
            QueryDataReqBO queryDataReqBO1 = new QueryDataReqBO();
            queryDataReqBO1.setTraceId(hashMap.get("traceId").toString());
            GetLogBO getLogBO = new GetLogBO();
            RspPage rspPage1 = (RspPage)this.getReqIn(queryDataReqBO1).getData();
            if (!ObjectUtils.isEmpty((Object)rspPage1.getRows())) {
                HashMap hashMap1 = (HashMap)rspPage1.getRows().get(0);
                getLogBO.setTraceId(hashMap1.get("traceId").toString());
                getLogBO.setRequestMessage(hashMap1.get("requestMessage").toString());
                getLogBO.setRequestMessage(getLogBO.getRequestMessage());
                getLogBO.setJoinTime(hashMap1.get("joinTime").toString());
                getLogBO.setBusinessCenterCode(hashMap1.get("businessCenterCode").toString());
            }
            if (!ObjectUtils.isEmpty((Object)(rspPage2 = (RspPage)this.getRspIn(queryDataReqBO1).getData()).getRows())) {
                HashMap hashMap2 = (HashMap)rspPage2.getRows().get(0);
                getLogBO.setSendMessage(hashMap2.get("sendMessage").toString());
                getLogBO.setSendMessage(getLogBO.getSendMessage());
            }
            if (!ObjectUtils.isEmpty((Object)(rspPage3 = (RspPage)this.getReqOut(queryDataReqBO1).getData()).getRows())) {
                HashMap hashMap3 = (HashMap)rspPage3.getRows().get(0);
                getLogBO.setRespondMessage(hashMap3.get("respondMessage").toString());
                getLogBO.setRespondMessage(getLogBO.getRespondMessage());
                getLogBO.setRespondTime(hashMap3.get("respondTime").toString());
                getLogBO.setTotalTime(this.TimeDifference(getLogBO.getJoinTime(), getLogBO.getRespondTime()));
            }
            if (!ObjectUtils.isEmpty((Object)(rspPage4 = (RspPage)this.getRspOut(queryDataReqBO1).getData()).getRows())) {
                HashMap hashMap4 = (HashMap)rspPage4.getRows().get(0);
                getLogBO.setRecieveMessage(hashMap4.get("recieveMessage").toString());
                getLogBO.setRecieveMessage(getLogBO.getRecieveMessage());
            }
            list.add(getLogBO);
        }
        RspPage rspPage2 = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), list, rspPage.getRecordsTotal());
        return RspBO.success((Object)rspPage2);
    }

    @Override
    public RspBO calculatingTime(String traceId) throws Exception {
        CalculatTimeBO calculatTimeBO = new CalculatTimeBO();
        calculatTimeBO.setESB(traceId);
        QueryDataReqBO queryDataReqBO = new QueryDataReqBO();
        queryDataReqBO.setTraceId(traceId);
        RspPage rspPage = (RspPage)this.getReqIn(queryDataReqBO).getData();
        if (rspPage.getRows().size() == 0) {
            return RspBO.error((CodeMsg)new CodeMsg("9999", "\u4e0d\u5b58\u5728\uff01"), (Object)rspPage);
        }
        HashMap hashMap = (HashMap)rspPage.getRows().get(0);
        calculatTimeBO.setJoinTime(hashMap.get("joinTime").toString());
        rspPage = (RspPage)this.getReqOut(queryDataReqBO).getData();
        if (rspPage.getRows().size() == 0) {
            return RspBO.error((CodeMsg)new CodeMsg("9999", "\u843d\u5730\u4e0d\u6210\u529f\uff01\u6570\u636e\u65e0\u6548\uff01"), (Object)rspPage);
        }
        if (!ObjectUtils.isEmpty((Object)rspPage.getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            calculatTimeBO.setRespondTime(hashMap.get("respondTime").toString());
            calculatTimeBO.setTotalTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getRespondTime()));
        }
        if (!ObjectUtils.isEmpty((Object)(rspPage = (RspPage)this.getRspIn(queryDataReqBO).getData()).getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            calculatTimeBO.setSendTime(hashMap.get("sendTime").toString());
            calculatTimeBO.setReqTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getSendTime()));
        }
        if (!ObjectUtils.isEmpty((Object)(rspPage = (RspPage)this.getRspOut(queryDataReqBO).getData()).getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            calculatTimeBO.setReceiveTime(hashMap.get("receiveTime").toString());
            calculatTimeBO.setRspTime(this.TimeDifference(calculatTimeBO.getSendTime(), calculatTimeBO.getReceiveTime()));
        }
        calculatTimeBO.setStatus("\u6709\u6548");
        return RspBO.success((Object)calculatTimeBO);
    }

    @Override
    public RspBO calculatingTimeList(QueryDataReqBO queryDataReqBO) throws Exception {
        ArrayList<CalculatTimeBO> calculatTimeBOS = new ArrayList<CalculatTimeBO>();
        HashMap<String, ArrayList> averageTime = new HashMap<String, ArrayList>();
        RspPage reqInRspPage = (RspPage)this.getReqIn(queryDataReqBO).getData();
        List reqInHashMapLIst = reqInRspPage.getRows();
        HashMap<String, Integer> invalidRecord = new HashMap<String, Integer>();
        ArrayList<String> traceIds = new ArrayList<String>();
        for (HashMap map : reqInHashMapLIst) {
            traceIds.add((String)map.get("traceId"));
        }
        Collections.sort(traceIds);
        while (traceIds.size() > 2) {
            traceIds.remove(1);
        }
        QueryDataReqBO dataReqBO = new QueryDataReqBO();
        dataReqBO.setPageNo(1);
        dataReqBO.setPageSize(queryDataReqBO.getPageSize() * 2);
        dataReqBO.setTraceIds(traceIds);
        RspPage reqOutRsp = (RspPage)this.getReqOut(dataReqBO).getData();
        List reqOutHashMapLIst = reqOutRsp.getRows();
        RspPage rspInRsp = (RspPage)this.getRspIn(dataReqBO).getData();
        List rspInHashMapLIst = rspInRsp.getRows();
        RspPage rspOutRsp = (RspPage)this.getRspOut(dataReqBO).getData();
        List rspOutHashMapLIst = rspOutRsp.getRows();
        for (Object map : reqInHashMapLIst) {
            CalculatTimeBO calculatTimeBO = new CalculatTimeBO();
            calculatTimeBO.setESB((String)((HashMap)map).get("traceId"));
            calculatTimeBO.setAbilityName((String)((HashMap)map).get("abilityName"));
            calculatTimeBO.setAbilityEname((String)((HashMap)map).get("abilityEname"));
            calculatTimeBO.setJoinTime((String)((HashMap)map).get("joinTime"));
            for (HashMap tmpMap : reqOutHashMapLIst) {
                if (!tmpMap.get("traceId").equals(calculatTimeBO.getESB())) continue;
                calculatTimeBO.setRespondTime((String)tmpMap.get("respondTime"));
            }
            for (HashMap tmpMap : rspInHashMapLIst) {
                if (!tmpMap.get("traceId").equals(calculatTimeBO.getESB())) continue;
                calculatTimeBO.setSendTime((String)tmpMap.get("sendTime"));
            }
            for (HashMap tmpMap : rspOutHashMapLIst) {
                if (!tmpMap.get("traceId").equals(calculatTimeBO.getESB())) continue;
                calculatTimeBO.setReceiveTime((String)tmpMap.get("receiveTime"));
            }
            invalidRecord.put(calculatTimeBO.getAbilityEname(), 0);
            if (calculatTimeBO.getRespondTime() == null || calculatTimeBO.getReceiveTime() == null || calculatTimeBO.getSendTime() == null) {
                calculatTimeBO.setStatus("\u65e0\u6548");
                if (invalidRecord.containsKey(calculatTimeBO.getAbilityEname())) {
                    invalidRecord.put(calculatTimeBO.getAbilityEname(), (Integer)invalidRecord.get(calculatTimeBO.getAbilityEname()) + 1);
                }
            } else {
                calculatTimeBO.setReqTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getRespondTime()));
                calculatTimeBO.setRspTime(this.TimeDifference(calculatTimeBO.getSendTime(), calculatTimeBO.getReceiveTime()));
                calculatTimeBO.setStatus("\u6709\u6548");
                ArrayList old = null;
                ArrayList<Long> list = new ArrayList<Long>();
                if (averageTime.containsKey(calculatTimeBO.getAbilityEname())) {
                    list.add(calculatTimeBO.getReqTime());
                    list.add(calculatTimeBO.getRspTime());
                    old = (ArrayList)averageTime.get(calculatTimeBO.getAbilityEname());
                    old.add(list);
                    averageTime.put(calculatTimeBO.getAbilityEname(), old);
                } else {
                    list.add(calculatTimeBO.getReqTime());
                    list.add(calculatTimeBO.getRspTime());
                    old = new ArrayList();
                    old.add(list);
                    averageTime.put(calculatTimeBO.getAbilityEname(), old);
                }
            }
            calculatTimeBOS.add(calculatTimeBO);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        for (Map.Entry entry : averageTime.entrySet()) {
            Long req = 0L;
            Long rsp = 0L;
            for (ArrayList list : (ArrayList)entry.getValue()) {
                req = req + (Long)list.get(0);
                rsp = rsp + (Long)list.get(1);
            }
            HashMap node = new HashMap();
            node.put("reqTime", req / (long)((ArrayList)entry.getValue()).size() + "");
            node.put("rspTime", rsp / (long)((ArrayList)entry.getValue()).size() + "");
            node.put("effective", (long)((ArrayList)entry.getValue()).size() + "");
            node.put("invalid", (long)((Integer)invalidRecord.get(entry.getKey())).intValue() + "");
            node.put("abilityEname", entry.getKey());
            result.add(node);
        }
        CaluclatTimeListBO caluclatTimeListBO = new CaluclatTimeListBO(queryDataReqBO.getPageSize(), queryDataReqBO.getPageNo(), calculatTimeBOS, reqInRspPage.getRecordsTotal());
        caluclatTimeListBO.setAvgTimeMap(result);
        return RspBO.success((Object)((Object)caluclatTimeListBO));
    }

    private Long TimeDifference(String start, String end) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date d1 = df.parse(start);
        Date d2 = df.parse(end);
        return (d2.getTime() - d1.getTime()) % 1000L;
    }

    @Override
    public RspBO getExceptionLogData(QueryDataReqBO queryDataReqBO) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.elasticSearchConfig.getExceptionIndexName()});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(0);
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            BoolQueryBuilder boolQueryBuilder = this.buildBoolQuery(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO);
            TermsAggregationBuilder errorTypeGroup = (TermsAggregationBuilder)AggregationBuilders.terms((String)"errorTypeGroup").field("errorType.keyword");
            TermsAggregationBuilder abilityNameGroup = (TermsAggregationBuilder)AggregationBuilders.terms((String)"abilityNameGroup").field("abilityName.keyword");
            TermsAggregationBuilder abilityEnameGroup = ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"abilityEnameGroup").field("abilityEname.keyword")).subAggregation((AggregationBuilder)errorTypeGroup)).subAggregation((AggregationBuilder)abilityNameGroup)).size(Integer.MAX_VALUE);
            TermsAggregationBuilder joinTimeGroup = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"joinTimeGroup").field("joinTime.keyword")).order(BucketOrder.key((boolean)Boolean.FALSE));
            abilityEnameGroup.subAggregation((AggregationBuilder)joinTimeGroup);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)abilityEnameGroup);
            searchRequest.source(searchSourceBuilder);
            List<Object> exceptionLogRspBoList = new LinkedList();
            try {
                SearchResponse searchResponse = this.client.search(searchRequest, this.options);
                Aggregations aggregations = searchResponse.getAggregations();
                Terms aggrAbilityException = (Terms)aggregations.get("abilityEnameGroup");
                List buckets = aggrAbilityException.getBuckets();
                for (Terms.Bucket bucket : buckets) {
                    Terms rspAbilityNameGroup = (Terms)bucket.getAggregations().get("abilityNameGroup");
                    List abilityNameBuckets = rspAbilityNameGroup.getBuckets();
                    Terms rspErrorTypeGroup = (Terms)bucket.getAggregations().get("errorTypeGroup");
                    List errorTypeBuckets = rspErrorTypeGroup.getBuckets();
                    long programErrorNum = 0L;
                    long landingReturnNum = 0L;
                    for (Terms.Bucket errorTypeBucket : errorTypeBuckets) {
                        if (errorTypeBucket.getKey().equals("\u7a0b\u5e8f\u62a5\u9519")) {
                            programErrorNum = errorTypeBucket.getDocCount();
                        }
                        if (!errorTypeBucket.getKey().equals("\u5f02\u5e38\u8fd4\u56de")) continue;
                        landingReturnNum = errorTypeBucket.getDocCount();
                    }
                    Terms rspJoinTimeGroup = (Terms)bucket.getAggregations().get("joinTimeGroup");
                    List joinTimeBuckets = rspJoinTimeGroup.getBuckets();
                    exceptionLogRspBoList.add(ExceptionLogRspBo.builder().abilityEname(bucket.getKey().toString()).abilityName(((Terms.Bucket)abilityNameBuckets.get(0)).getKey().toString()).programErrorNum(programErrorNum).landingReturnNum(landingReturnNum).earliestTime(((Terms.Bucket)joinTimeBuckets.get(joinTimeBuckets.size() - 1)).getKey().toString()).latestTime(((Terms.Bucket)joinTimeBuckets.get(0)).getKey().toString()).build());
                }
                if (queryDataReqBO.getErrorSortType().equals("\u65f6\u95f4\u964d\u5e8f")) {
                    exceptionLogRspBoList = exceptionLogRspBoList.stream().sorted(new Comparator<ExceptionLogRspBo>(){

                        @Override
                        public int compare(ExceptionLogRspBo o1, ExceptionLogRspBo o2) {
                            Date d1 = DateUtil.getStringToLocalDate((String)o1.getLatestTime());
                            Date d2 = DateUtil.getStringToLocalDate((String)o2.getLatestTime());
                            return d1.compareTo(d2);
                        }
                    }.reversed()).collect(Collectors.toList());
                } else if (queryDataReqBO.getErrorSortType().equals("\u6b21\u6570\u964d\u5e8f")) {
                    exceptionLogRspBoList = exceptionLogRspBoList.stream().sorted(new Comparator<ExceptionLogRspBo>(){

                        @Override
                        public int compare(ExceptionLogRspBo o1, ExceptionLogRspBo o2) {
                            Long num1 = o1.getProgramErrorNum() + o1.getLandingReturnNum();
                            Long num2 = o2.getProgramErrorNum() + o2.getLandingReturnNum();
                            return num1.compareTo(num2);
                        }
                    }.reversed()).collect(Collectors.toList());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int start = (queryDataReqBO.getPageNo() - 1) * queryDataReqBO.getPageSize();
            int end = Math.min(queryDataReqBO.getPageNo() * queryDataReqBO.getPageSize(), exceptionLogRspBoList.size());
            start = start > end ? (queryDataReqBO.getPageNo() - 2) * queryDataReqBO.getPageSize() : start;
            List logRspBoList = exceptionLogRspBoList.subList(start, end);
            RspPage rspPage = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), logRspBoList, Long.valueOf(Long.parseLong(String.valueOf(exceptionLogRspBoList.size()))));
            return RspBO.success((Object)rspPage);
        }
        catch (Exception e) {
            return RspBO.error((String)e.getMessage());
        }
    }
}

