/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.logplatform.config.ElasticSearchConfig;
import com.ohaotian.logplatform.model.req.QueryDataReqBO;
import com.ohaotian.logplatform.model.rsp.CalculatTimeBO;
import com.ohaotian.logplatform.model.rsp.CaluclatTimeListBO;
import com.ohaotian.logplatform.model.rsp.ExceptionLogRspBo;
import com.ohaotian.logplatform.model.rsp.GetAvgTimeBO;
import com.ohaotian.logplatform.model.rsp.GetErrorMessageBO;
import com.ohaotian.logplatform.model.rsp.GetLogBO;
import com.ohaotian.logplatform.model.rsp.GetTimeBO;
import com.ohaotian.logplatform.service.LogTransactionService;
import com.ohaotian.logplatform.util.GzipUtil;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.DateUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class LogTransactionServiceImpl
implements LogTransactionService {
    private static final Logger log = LoggerFactory.getLogger(LogTransactionServiceImpl.class);
    @Value(value="${log.platform.query.opera:OR}")
    private String operation;
    @Value(value="${log.platform.query.mumShouldMatch:80%}")
    private String mumShouldMatch;
    @Autowired
    private RestHighLevelClient client;
    private final RequestOptions options = RequestOptions.DEFAULT;
    @Autowired
    private ElasticSearchConfig elasticSearchConfig;
    private ExecutorService executorService;

    @PostConstruct
    public void initAbilityLogListExecutor() {
        this.executorService = new ThreadPoolExecutor(50, 100, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(@NotNull Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("AbilityLog_TNO_" + this.sn.incrementAndGet());
                return t;
            }
        });
        log.info("initAbilityLogListExecutor \u521d\u59cb\u5316......");
    }

    public boolean checkIndex(String index) throws Exception {
        try {
            return this.client.indices().exists(new GetIndexRequest(new String[]{index}), this.options);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private BoolQueryBuilder buildBoolQuery(String indexName, QueryDataReqBO queryDataReqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getAbilityName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"abilityName", (Object)queryDataReqBO.getAbilityName()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getAbilityEname())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"abilityEname", (Object)queryDataReqBO.getAbilityEname()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getInputProtocal())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"inputProtocal", (Object)queryDataReqBO.getInputProtocal()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getOutputProtocal())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"outputProtocal", (Object)queryDataReqBO.getOutputProtocal()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getTraceId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"traceId", (Object)queryDataReqBO.getTraceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getBusinessCenterCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"businessCenterCode", (Object)queryDataReqBO.getBusinessCenterCode()));
        }
        Operator operator = Operator.OR;
        if ("AND".equals(this.operation)) {
            operator = Operator.AND;
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getRequestMessage())) {
            boolQueryBuilder.must((QueryBuilder)((BoolQueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)"requestMessage.keyword", (String)("*" + queryDataReqBO.getRequestMessage() + "*")).boost(10.0f)).should((QueryBuilder)QueryBuilders.matchQuery((String)"requestMessage", (Object)queryDataReqBO.getRequestMessage()).operator(operator)).boost(2.0f)).minimumShouldMatch(this.mumShouldMatch));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getRespondMessage())) {
            boolQueryBuilder.must((QueryBuilder)((BoolQueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)"respondMessage.keyword", (String)("*" + queryDataReqBO.getRespondMessage() + "*")).boost(10.0f)).should((QueryBuilder)QueryBuilders.matchQuery((String)"respondMessage", (Object)queryDataReqBO.getRespondMessage()).operator(operator)).boost(2.0f)).minimumShouldMatch(this.mumShouldMatch));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getErrorType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"errorType", (Object)queryDataReqBO.getErrorType()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDataReqBO.getHsn())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"hsn", (Object)queryDataReqBO.getHsn()));
        }
        if (queryDataReqBO.getTimes() != null) {
            if (indexName.equals(this.elasticSearchConfig.getReqInIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"joinTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            } else if (indexName.equals(this.elasticSearchConfig.getReqOutIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"respondTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            } else if (indexName.equals(this.elasticSearchConfig.getRspInIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"sendTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            } else if (indexName.equals(this.elasticSearchConfig.getRspOutIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"receiveTime.keyword").gte((Object)queryDataReqBO.getTimes().get(0)).lte((Object)queryDataReqBO.getTimes().get(1)));
            }
        }
        if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getStarTime()) && !ObjectUtils.isEmpty((Object)queryDataReqBO.getEndTime())) {
            if (indexName.equals(this.elasticSearchConfig.getExceptionIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"joinTime.keyword").gte((Object)queryDataReqBO.getStarTime()).lte((Object)queryDataReqBO.getEndTime()));
            } else if (indexName.equals(this.elasticSearchConfig.getReqInIndexName())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"joinTime.keyword").gte((Object)queryDataReqBO.getStarTime()).lte((Object)queryDataReqBO.getEndTime()));
            }
        }
        if (queryDataReqBO.getTraceIds() != null) {
            if (queryDataReqBO.getTraceIds().size() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"traceId", (Object)queryDataReqBO.getTraceIds().get(0)));
            } else if (queryDataReqBO.getTraceIds().size() > 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"traceId.keyword").gte((Object)queryDataReqBO.getTraceIds().get(0)).lte((Object)queryDataReqBO.getTraceIds().get(1)));
            }
        }
        return boolQueryBuilder;
    }

    private JSONObject singleSearch(String indexName, QueryDataReqBO queryDataReqBO) {
        int pageNo = queryDataReqBO.getPageNo();
        int pageSize = queryDataReqBO.getPageSize();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from((pageNo - 1) * pageSize).size(pageSize);
        BoolQueryBuilder boolQueryBuilder = this.buildBoolQuery(indexName, queryDataReqBO);
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.explain(Boolean.FALSE);
        sourceBuilder.sort("@timestamp", SortOrder.DESC);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.fetchSource(new String[0], new String[0]);
        searchRequest.source(sourceBuilder);
        try {
            SearchHit[] searchHitArr;
            SearchResponse searchResp = this.client.search(searchRequest, this.options);
            ArrayList<Map> data = new ArrayList<Map>();
            for (SearchHit searchHit : searchHitArr = searchResp.getHits().getHits()) {
                Map temp = searchHit.getSourceAsMap();
                temp.put("id", searchHit.getId());
                data.add(temp);
            }
            JSONObject rsp = new JSONObject();
            rsp.put("data", data);
            rsp.put("totalHits", (Object)searchResp.getHits().getTotalHits().value);
            return rsp;
        }
        catch (Exception e) {
            log.error(indexName + "\u6570\u636e\u67e5\u8be2\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public RspBO getIndex(String indexName, QueryDataReqBO queryDataReqBO) {
        try {
            Request request = new Request("GET", "/_cat/indices/" + indexName + "?h=i,v&s=index:desc");
            String indicesListStr = "";
            try {
                indicesListStr = EntityUtils.toString((HttpEntity)this.client.getLowLevelClient().performRequest(request).getEntity());
            }
            catch (IOException e2) {
                log.error("\u7d22\u5f15\u83b7\u53d6\u5f02\u5e38\uff1a" + e2.getMessage(), (Throwable)e2);
            }
            Boolean flag = Boolean.TRUE;
            List<Object> data = new LinkedList();
            long totalHits = 0L;
            List<Object> indicesList = new LinkedList();
            int length = 1;
            if (StringUtils.isNotBlank((CharSequence)indicesListStr)) {
                indicesList = Arrays.stream(indicesListStr.trim().split("\\n")).collect(Collectors.toList());
                length = Math.min(indicesList.size(), this.elasticSearchConfig.getIndexSearchNum());
                if (this.elasticSearchConfig.getReqInIndexName().equals(indexName)) {
                    flag = Boolean.FALSE;
                }
                if (this.elasticSearchConfig.getReqOutIndexName().equals(indexName)) {
                    flag = Boolean.FALSE;
                }
                if (StringUtils.isBlank((CharSequence)queryDataReqBO.getStarTime()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getEndTime()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getBusinessCenterCode()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getTraceId()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getHsn()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getRequestMessage()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getRespondMessage())) {
                    flag = Boolean.TRUE;
                }
                if (StringUtils.isBlank((CharSequence)queryDataReqBO.getStarTime()) && StringUtils.isBlank((CharSequence)queryDataReqBO.getEndTime())) {
                    flag = Boolean.FALSE;
                }
                if (length == -1) {
                    flag = Boolean.TRUE;
                }
            }
            if (Boolean.TRUE.equals(flag)) {
                JSONObject singleData = this.singleSearch(indexName, queryDataReqBO);
                if (!ObjectUtils.isEmpty((Object)singleData)) {
                    data = (List)JSON.parseObject((String)JSON.toJSONString((Object)singleData.get((Object)"data")), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                    totalHits = Long.parseLong(singleData.getString("totalHits"));
                }
            } else {
                ConcurrentSkipListMap searchData = new ConcurrentSkipListMap();
                ConcurrentSkipListMap searchDataTotalHits = new ConcurrentSkipListMap();
                CountDownLatch countDownLatch = new CountDownLatch(length);
                int i = 0;
                while (i < length) {
                    int finalI = i++;
                    List<Object> finalIndicesList = indicesList;
                    CompletionStage getReqInFuture = CompletableFuture.runAsync(() -> {
                        JSONObject singleData;
                        QueryDataReqBO changedData = (QueryDataReqBO)BeanMapper.map((Object)queryDataReqBO, QueryDataReqBO.class);
                        if (finalI != 0) {
                            changedData.setPageNo(1);
                        }
                        if (!ObjectUtils.isEmpty((Object)(singleData = this.singleSearch((String)finalIndicesList.get(finalI), changedData)))) {
                            searchData.put(finalI, JSON.parseObject((String)JSON.toJSONString((Object)singleData.get((Object)"data")), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]));
                            searchDataTotalHits.put(finalI, Long.parseLong(singleData.getString("totalHits")));
                        }
                    }, this.executorService).exceptionally(e -> {
                        log.info("\u80fd\u529b\u8c03\u7528\u5e73\u53f0\u5165\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                        log.error(e.getMessage(), e);
                        return null;
                    });
                    ((CompletableFuture)getReqInFuture).whenComplete((result, e) -> countDownLatch.countDown());
                }
                countDownLatch.await();
                data = searchData.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
                totalHits = searchDataTotalHits.values().stream().mapToLong(l -> l).sum();
            }
            data = data.stream().limit(queryDataReqBO.getPageSize()).collect(Collectors.toList());
            RspPage rspPage = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), data, Long.valueOf(totalHits));
            return RspBO.success((Object)rspPage);
        }
        catch (Exception e3) {
            log.error(indexName + "\u67e5\u8be2\u5f02\u5e38: " + e3.getMessage(), (Throwable)e3);
            return RspBO.error((String)"\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    @Override
    public RspBO getReqIn(QueryDataReqBO queryDataReqBO) {
        return this.getIndex(this.elasticSearchConfig.getReqInIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getReqOut(QueryDataReqBO queryDataReqBO) {
        return this.getIndex(this.elasticSearchConfig.getReqOutIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getRspIn(QueryDataReqBO queryDataReqBO) {
        return this.getIndex(this.elasticSearchConfig.getRspInIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getRspOut(QueryDataReqBO queryDataReqBO) {
        return this.getIndex(this.elasticSearchConfig.getRspOutIndexName(), queryDataReqBO);
    }

    @Override
    public RspBO getAvgTime(QueryDataReqBO queryDataReqBO) throws Exception {
        ArrayList<GetAvgTimeBO> list = new ArrayList<GetAvgTimeBO>();
        Double total = 0.0;
        Double totalReq = 0.0;
        Double totalRsp = 0.0;
        int n = 0;
        ArrayList<GetTimeBO> list1 = new ArrayList<GetTimeBO>();
        for (String traceId : queryDataReqBO.getTraceIds()) {
            QueryDataReqBO queryDataReqBO1 = new QueryDataReqBO();
            queryDataReqBO1.setTraceId(traceId);
            CalculatTimeBO calculatTimeBO = new CalculatTimeBO();
            GetAvgTimeBO getAvgTimeBO = new GetAvgTimeBO();
            RspPage rspPage1 = (RspPage)this.getReqIn(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage1.getRows())) continue;
            HashMap hashMap1 = (HashMap)rspPage1.getRows().get(0);
            calculatTimeBO.setJoinTime(hashMap1.get("joinTime").toString());
            getAvgTimeBO.setTraceId(hashMap1.get("traceId").toString());
            RspPage rspPage2 = (RspPage)this.getRspIn(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage2.getRows())) continue;
            HashMap hashMap2 = (HashMap)rspPage2.getRows().get(0);
            calculatTimeBO.setSendTime(hashMap2.get("sendTime").toString());
            RspPage rspPage3 = (RspPage)this.getReqOut(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage3.getRows())) continue;
            HashMap hashMap3 = (HashMap)rspPage3.getRows().get(0);
            calculatTimeBO.setRespondTime(hashMap3.get("respondTime").toString());
            RspPage rspPage4 = (RspPage)this.getRspOut(queryDataReqBO1).getData();
            if (ObjectUtils.isEmpty((Object)rspPage4.getRows())) continue;
            HashMap hashMap4 = (HashMap)rspPage4.getRows().get(0);
            calculatTimeBO.setReceiveTime(hashMap4.get("receiveTime").toString());
            getAvgTimeBO.setBigTotalTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getRespondTime()));
            total = total + (double)getAvgTimeBO.getBigTotalTime().longValue();
            getAvgTimeBO.setReqTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getReceiveTime()));
            totalReq = totalReq + (double)getAvgTimeBO.getReqTime().longValue();
            getAvgTimeBO.setRspTime(this.TimeDifference(calculatTimeBO.getSendTime(), calculatTimeBO.getReceiveTime()));
            totalRsp = totalRsp + (double)getAvgTimeBO.getRspTime().longValue();
            list.add(getAvgTimeBO);
            ++n;
        }
        if (!ObjectUtils.isEmpty(list)) {
            GetTimeBO getTimeBO = new GetTimeBO();
            getTimeBO.setAvgTotalTime(total / (double)n);
            getTimeBO.setAvgReqTime(totalReq / (double)n);
            getTimeBO.setAvgRspTime(totalRsp / (double)n);
            list1.add(getTimeBO);
            list.sort(Comparator.comparing(GetAvgTimeBO::getBigTotalTime));
            list1.add((GetTimeBO)list.get(0));
            list1.add((GetTimeBO)list.get(list.size() - 1));
        }
        return RspBO.success(list1);
    }

    public RspPage<GetLogBO> getAllTraceIdsWithParams(QueryDataReqBO queryDataReqBO) throws Exception {
        Long recordsTotal;
        ArrayList<GetLogBO> getLogBOList;
        block6: {
            block9: {
                block8: {
                    block7: {
                        getLogBOList = new ArrayList<GetLogBO>();
                        recordsTotal = 0L;
                        if (ObjectUtils.isEmpty((Object)queryDataReqBO.getRequestMessage()) || ObjectUtils.isEmpty((Object)queryDataReqBO.getRespondMessage())) break block7;
                        String requestMessage = queryDataReqBO.getRequestMessage();
                        String respondMessage = queryDataReqBO.getRespondMessage();
                        while (getLogBOList.size() < queryDataReqBO.getPageSize()) {
                            queryDataReqBO.setRequestMessage(requestMessage);
                            queryDataReqBO.setRespondMessage(null);
                            RspPage rspPageWithRequestMessage = (RspPage)this.getReqIn(queryDataReqBO).getData();
                            recordsTotal = rspPageWithRequestMessage.getRecordsTotal();
                            if (!ObjectUtils.isEmpty((Object)rspPageWithRequestMessage.getRows()) && rspPageWithRequestMessage.getRows().size() != 0) {
                                for (Object row : rspPageWithRequestMessage.getRows()) {
                                    HashMap row1 = (HashMap)row;
                                    String traceId = ObjectUtils.isEmpty(row1.get("traceId")) ? "" : row1.get("traceId").toString();
                                    queryDataReqBO.setTraceId(traceId);
                                    queryDataReqBO.setRequestMessage(null);
                                    queryDataReqBO.setRespondMessage(respondMessage);
                                    queryDataReqBO.setHsn(null);
                                    RspPage rspPageWithRespondMessage = (RspPage)this.getReqOut(queryDataReqBO).getData();
                                    if (rspPageWithRespondMessage.getRows().size() != 1) continue;
                                    GetLogBO getLogBO = new GetLogBO();
                                    getLogBO = this.addNewField(getLogBO, row1);
                                    HashMap res = (HashMap)rspPageWithRespondMessage.getRows().get(0);
                                    getLogBO.setRespondMessage(ObjectUtils.isEmpty(res.get("respondMessage")) ? "null" : res.get("respondMessage").toString());
                                    getLogBO.setRespondTime(ObjectUtils.isEmpty(res.get("respondTime")) ? "" : res.get("respondTime").toString());
                                    getLogBO.setTotalTime(this.TimeDifference(getLogBO.getJoinTime(), getLogBO.getRespondTime()));
                                    getLogBOList.add(getLogBO);
                                }
                                queryDataReqBO.setPageNo(queryDataReqBO.getPageNo() + 1);
                                continue;
                            }
                            break block6;
                        }
                        break block6;
                    }
                    if (ObjectUtils.isEmpty((Object)queryDataReqBO.getRequestMessage())) break block8;
                    RspPage rspPageWithRequestMessage = (RspPage)this.getReqIn(queryDataReqBO).getData();
                    recordsTotal = rspPageWithRequestMessage.getRecordsTotal();
                    if (ObjectUtils.isEmpty((Object)rspPageWithRequestMessage.getRows())) break block6;
                    for (Object row : rspPageWithRequestMessage.getRows()) {
                        HashMap row1 = (HashMap)row;
                        GetLogBO getLogBO = new GetLogBO();
                        getLogBO = this.addNewField(getLogBO, row1);
                        getLogBOList.add(getLogBO);
                    }
                    break block6;
                }
                if (ObjectUtils.isEmpty((Object)queryDataReqBO.getRespondMessage())) break block9;
                queryDataReqBO.setHsn(null);
                RspPage rspPageWithRespondMessage = (RspPage)this.getReqOut(queryDataReqBO).getData();
                recordsTotal = rspPageWithRespondMessage.getRecordsTotal();
                if (ObjectUtils.isEmpty((Object)rspPageWithRespondMessage.getRows())) break block6;
                for (Object row : rspPageWithRespondMessage.getRows()) {
                    HashMap row1 = (HashMap)row;
                    GetLogBO getLogBO = new GetLogBO();
                    getLogBO.setTraceId(ObjectUtils.isEmpty(row1.get("traceId")) ? "" : row1.get("traceId").toString());
                    getLogBO.setRespondMessage(ObjectUtils.isEmpty(row1.get("respondMessage")) ? "null" : row1.get("respondMessage").toString());
                    getLogBO.setRespondTime(ObjectUtils.isEmpty(row1.get("respondTime")) ? "" : row1.get("respondTime").toString());
                    getLogBO.setRespondHeaderInfo(ObjectUtils.isEmpty(row1.get("respondHeaderInfo")) ? "" : row1.get("respondHeaderInfo").toString());
                    getLogBOList.add(getLogBO);
                }
                break block6;
            }
            RspPage rspPage = (RspPage)this.getReqIn(queryDataReqBO).getData();
            recordsTotal = rspPage.getRecordsTotal();
            for (Object row : rspPage.getRows()) {
                HashMap row1 = (HashMap)row;
                GetLogBO getLogBO = new GetLogBO();
                getLogBO = this.addNewField(getLogBO, row1);
                getLogBOList.add(getLogBO);
            }
        }
        return new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), getLogBOList, recordsTotal);
    }

    public GetLogBO addNewField(GetLogBO getLogBO, HashMap map) {
        getLogBO.setTraceId(ObjectUtils.isEmpty(map.get("traceId")) ? "" : map.get("traceId").toString());
        getLogBO.setRequestMessage(ObjectUtils.isEmpty(map.get("requestMessage")) ? "null" : map.get("requestMessage").toString());
        getLogBO.setJoinTime(ObjectUtils.isEmpty(map.get("joinTime")) ? "" : map.get("joinTime").toString());
        getLogBO.setBusinessCenterCode(ObjectUtils.isEmpty(map.get("businessCenterCode")) ? "" : map.get("businessCenterCode").toString());
        getLogBO.setHsn(ObjectUtils.isEmpty(map.get("hsn")) ? "" : map.get("hsn").toString());
        getLogBO.setRequestHeaderInfo(ObjectUtils.isEmpty(map.get("requestHeaderInfo")) ? "" : map.get("requestHeaderInfo").toString());
        return getLogBO;
    }

    public RspPage getErrorTraceIdsWithParams(QueryDataReqBO queryDataReqBO) {
        HashMap hashMap;
        RspPage rspPageWithErrorMessage;
        HashMap row1;
        String requestMessage;
        ArrayList<String> traceIds = new ArrayList<String>();
        ArrayList<String> errorType = new ArrayList<String>();
        Long recordsTotal = 0L;
        if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getRequestMessage()) && !ObjectUtils.isEmpty((Object)queryDataReqBO.getRespondMessage())) {
            requestMessage = queryDataReqBO.getRequestMessage();
            String respondMessage = queryDataReqBO.getRespondMessage();
            queryDataReqBO.setRespondMessage(null);
            while (traceIds.size() < queryDataReqBO.getPageSize()) {
                queryDataReqBO.setRequestMessage(requestMessage);
                RspPage rspPageWithRequestMessage = (RspPage)this.getReqIn(queryDataReqBO).getData();
                recordsTotal = rspPageWithRequestMessage.getRecordsTotal();
                if (!ObjectUtils.isEmpty((Object)rspPageWithRequestMessage.getRows())) {
                    for (Object row : rspPageWithRequestMessage.getRows()) {
                        HashMap row12 = (HashMap)row;
                        queryDataReqBO.setTraceId(row12.get("traceId").toString());
                        queryDataReqBO.setRequestMessage(null);
                        queryDataReqBO.setRespondMessage(respondMessage);
                        RspPage rspPageWithRespondMessage = (RspPage)this.getReqOut(queryDataReqBO).getData();
                        queryDataReqBO.setRespondMessage(null);
                        RspPage rspPageWithErrorMessage2 = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
                        if (rspPageWithRespondMessage.getRows().size() != 1 || rspPageWithErrorMessage2.getRows().size() != 1) continue;
                        traceIds.add(row12.get("traceId").toString());
                        HashMap hashMap2 = (HashMap)rspPageWithErrorMessage2.getRows().get(0);
                        errorType.add(hashMap2.get("errorType").toString());
                    }
                    queryDataReqBO.setPageNo(queryDataReqBO.getPageNo() + 1);
                    continue;
                }
                break;
            }
        } else if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getRequestMessage())) {
            requestMessage = queryDataReqBO.getRequestMessage();
            while (traceIds.size() < queryDataReqBO.getPageSize()) {
                RspPage rspPageWithRequestMessage = (RspPage)this.getReqIn(queryDataReqBO).getData();
                recordsTotal = rspPageWithRequestMessage.getRecordsTotal();
                if (!ObjectUtils.isEmpty((Object)rspPageWithRequestMessage.getRows())) {
                    for (Object row : rspPageWithRequestMessage.getRows()) {
                        row1 = (HashMap)row;
                        queryDataReqBO.setTraceId(row1.get("traceId").toString());
                        queryDataReqBO.setRequestMessage(null);
                        rspPageWithErrorMessage = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
                        if (rspPageWithErrorMessage.getRows().size() != 1) continue;
                        traceIds.add(row1.get("traceId").toString());
                        hashMap = (HashMap)rspPageWithErrorMessage.getRows().get(0);
                        errorType.add(hashMap.get("errorType").toString());
                    }
                    continue;
                }
                break;
            }
        } else if (!ObjectUtils.isEmpty((Object)queryDataReqBO.getRespondMessage())) {
            String respondMessage = queryDataReqBO.getRespondMessage();
            while (traceIds.size() < queryDataReqBO.getPageSize()) {
                RspPage rspPageWithRespondMessage = (RspPage)this.getRspIn(queryDataReqBO).getData();
                recordsTotal = rspPageWithRespondMessage.getRecordsTotal();
                if (!ObjectUtils.isEmpty((Object)rspPageWithRespondMessage.getRows())) {
                    for (Object row : rspPageWithRespondMessage.getRows()) {
                        row1 = (HashMap)row;
                        queryDataReqBO.setTraceId(row1.get("traceId").toString());
                        queryDataReqBO.setRespondMessage(null);
                        rspPageWithErrorMessage = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
                        if (rspPageWithErrorMessage.getRows().size() != 1) continue;
                        traceIds.add(row1.get("traceId").toString());
                        hashMap = (HashMap)rspPageWithErrorMessage.getRows().get(0);
                        errorType.add(hashMap.get("errorType").toString());
                    }
                    continue;
                }
                break;
            }
        } else {
            RspPage rspPageWithErrorMessage3 = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
            recordsTotal = rspPageWithErrorMessage3.getRecordsTotal();
            for (Object row : rspPageWithErrorMessage3.getRows()) {
                HashMap row13 = (HashMap)row;
                errorType.add(row13.get("errorType").toString());
                traceIds.add(row13.get("traceId").toString());
            }
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < traceIds.size(); ++i) {
            HashMap map = new HashMap();
            map.put("traceId", traceIds.get(i));
            map.put("errorType", errorType.get(i));
            list.add(map);
        }
        RspPage rspPage = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), list, recordsTotal);
        return rspPage;
    }

    @Override
    public RspBO getErrorData(QueryDataReqBO queryDataReqBO) throws Exception {
        RspPage rspPage = this.getErrorTraceIdsWithParams(queryDataReqBO);
        ArrayList<GetLogBO> list = new ArrayList<GetLogBO>();
        for (int i = 0; i < rspPage.getPageCout(); ++i) {
            GetLogBO getLogBO = new GetLogBO();
            HashMap hashMap = (HashMap)rspPage.getRows().get(i);
            QueryDataReqBO queryDataReqBO1 = new QueryDataReqBO();
            queryDataReqBO1.setTraceId(hashMap.get("traceId").toString());
            getLogBO.setErrorType(hashMap.get("errorType").toString());
            CountDownLatch countDownLatch = new CountDownLatch(4);
            CompletionStage getReqInFuture = CompletableFuture.runAsync(() -> {
                RspPage rspPage1 = (RspPage)this.getReqIn(queryDataReqBO1).getData();
                if (!ObjectUtils.isEmpty((Object)rspPage1.getRows())) {
                    HashMap hashMap1 = (HashMap)rspPage1.getRows().get(0);
                    getLogBO.setTraceId(hashMap1.get("traceId").toString());
                    getLogBO.setRequestMessage(hashMap1.get("requestMessage").toString());
                    getLogBO.setRequestMessage(getLogBO.getRequestMessage());
                    getLogBO.setJoinTime(hashMap1.get("joinTime").toString());
                    if (hashMap1.get("businessCenterCode") != null) {
                        getLogBO.setBusinessCenterCode(hashMap1.get("businessCenterCode").toString());
                    }
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u8c03\u7528\u5e73\u53f0\u5165\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getReqInFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getRspInFuture = CompletableFuture.runAsync(() -> {
                RspPage rspPage2 = (RspPage)this.getRspIn(queryDataReqBO1).getData();
                if (!ObjectUtils.isEmpty((Object)rspPage2.getRows())) {
                    HashMap hashMap2 = (HashMap)rspPage2.getRows().get(0);
                    getLogBO.setSendMessage(hashMap2.get("sendMessage").toString());
                    getLogBO.setSendMessage(getLogBO.getSendMessage());
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u5e73\u53f0\u843d\u5730\u5165\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getRspInFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getReqOutFuture = CompletableFuture.runAsync(() -> {
                RspPage rspPage3 = (RspPage)this.getReqOut(queryDataReqBO1).getData();
                if (!ObjectUtils.isEmpty((Object)rspPage3.getRows())) {
                    HashMap hashMap3 = (HashMap)rspPage3.getRows().get(0);
                    getLogBO.setRespondMessage(hashMap3.get("respondMessage").toString());
                    getLogBO.setRespondMessage(getLogBO.getRespondMessage());
                    getLogBO.setRespondTime(hashMap3.get("respondTime").toString());
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u5e73\u53f0\u843d\u5730\u51fa\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getReqOutFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getRspOutFuture = CompletableFuture.runAsync(() -> {
                RspPage rspPage4 = (RspPage)this.getRspOut(queryDataReqBO1).getData();
                if (!ObjectUtils.isEmpty((Object)rspPage4.getRows())) {
                    HashMap hashMap4 = (HashMap)rspPage4.getRows().get(0);
                    getLogBO.setRecieveMessage(hashMap4.get("recieveMessage").toString());
                    getLogBO.setRecieveMessage(getLogBO.getRecieveMessage());
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u8c03\u7528\u5e73\u53f0\u51fa\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getRspOutFuture).whenComplete((result, e) -> countDownLatch.countDown());
            countDownLatch.await();
            list.add(getLogBO);
        }
        RspPage rspPage2 = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), list, rspPage.getRecordsTotal());
        return RspBO.success((Object)rspPage2);
    }

    @Override
    public RspBO queryExcept(QueryDataReqBO queryDataReqBO) throws Exception {
        GetErrorMessageBO getErrorMessageBO = new GetErrorMessageBO();
        RspPage rspPage = (RspPage)this.getIndex(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO).getData();
        if (ObjectUtils.isEmpty((Object)rspPage.getRows())) {
            return RspBO.success((Object)getErrorMessageBO);
        }
        HashMap hashMap = (HashMap)rspPage.getRows().get(0);
        getErrorMessageBO.setResultMessage(hashMap.get("resultMessage").toString());
        getErrorMessageBO.setResultMessage(getErrorMessageBO.getResultMessage());
        return RspBO.success((Object)getErrorMessageBO);
    }

    @Override
    public RspBO getLogData(QueryDataReqBO queryDataReqBO) throws Exception {
        RspPage<GetLogBO> rspPage = this.getAllTraceIdsWithParams(queryDataReqBO);
        ArrayList<GetLogBO> list = new ArrayList<GetLogBO>();
        for (int i = 0; i < rspPage.getRows().size(); ++i) {
            GetLogBO getLogBo = (GetLogBO)rspPage.getRows().get(i);
            QueryDataReqBO queryDataReqBO1 = new QueryDataReqBO();
            queryDataReqBO1.setTraceId(getLogBo.getTraceId());
            CountDownLatch countDownLatch = new CountDownLatch(5);
            CompletionStage getReqInFuture = CompletableFuture.runAsync(() -> {
                if (StringUtils.isBlank((CharSequence)getLogBo.getRequestMessage())) {
                    RspPage rspPage1 = (RspPage)this.getReqIn(queryDataReqBO1).getData();
                    HashMap row1 = (HashMap)rspPage1.getRows().get(0);
                    getLogBo.setRequestMessage(ObjectUtils.isEmpty(row1.get("requestMessage")) ? "null" : row1.get("requestMessage").toString());
                    getLogBo.setJoinTime(ObjectUtils.isEmpty(row1.get("joinTime")) ? "" : row1.get("joinTime").toString());
                    getLogBo.setBusinessCenterCode(ObjectUtils.isEmpty(row1.get("businessCenterCode")) ? "" : row1.get("businessCenterCode").toString());
                    getLogBo.setHsn(ObjectUtils.isEmpty(row1.get("hsn")) ? "" : row1.get("hsn").toString());
                    getLogBo.setRequestHeaderInfo(ObjectUtils.isEmpty(row1.get("requestHeaderInfo")) ? "" : row1.get("requestHeaderInfo").toString());
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u8c03\u7528\u5e73\u53f0\u5165\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getReqInFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getRspInFuture = CompletableFuture.runAsync(() -> {
                RspPage rspPage2 = (RspPage)this.getRspIn(queryDataReqBO1).getData();
                if (!ObjectUtils.isEmpty((Object)rspPage2.getRows())) {
                    HashMap hashMap2 = (HashMap)rspPage2.getRows().get(0);
                    getLogBo.setSendMessage(ObjectUtils.isEmpty(hashMap2.get("sendMessage")) ? "null" : hashMap2.get("sendMessage").toString());
                    getLogBo.setSendHeaderInfo(ObjectUtils.isEmpty(hashMap2.get("sendHeaderInfo")) ? "" : hashMap2.get("sendHeaderInfo").toString());
                    getLogBo.setUrl(ObjectUtils.isEmpty(hashMap2.get("url")) ? "" : hashMap2.get("url").toString());
                } else {
                    getLogBo.setSendMessage("null");
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u5e73\u53f0\u843d\u5730\u5165\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getRspInFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getRspOutFuture = CompletableFuture.runAsync(() -> {
                RspPage rspPage4 = (RspPage)this.getRspOut(queryDataReqBO1).getData();
                if (!ObjectUtils.isEmpty((Object)rspPage4.getRows())) {
                    HashMap hashMap4 = (HashMap)rspPage4.getRows().get(0);
                    getLogBo.setRecieveMessage(ObjectUtils.isEmpty(hashMap4.get("recieveMessage")) ? "null" : hashMap4.get("recieveMessage").toString());
                    getLogBo.setRecieveHeaderInfo(ObjectUtils.isEmpty(hashMap4.get("recieveHeaderInfo")) ? "" : hashMap4.get("recieveHeaderInfo").toString());
                } else {
                    getLogBo.setRecieveMessage("null");
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u5e73\u53f0\u843d\u5730\u51fa\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getRspOutFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getReqOutFuture = CompletableFuture.runAsync(() -> {
                if (StringUtils.isBlank((CharSequence)getLogBo.getRespondMessage())) {
                    RspPage rspPage3 = (RspPage)this.getReqOut(queryDataReqBO1).getData();
                    if (!ObjectUtils.isEmpty((Object)rspPage3.getRows())) {
                        HashMap hashMap3 = (HashMap)rspPage3.getRows().get(0);
                        getLogBo.setRespondMessage(ObjectUtils.isEmpty(hashMap3.get("respondMessage")) ? "null" : hashMap3.get("respondMessage").toString());
                        getLogBo.setRespondHeaderInfo(ObjectUtils.isEmpty(hashMap3.get("respondHeaderInfo")) ? "" : hashMap3.get("respondHeaderInfo").toString());
                        getLogBo.setRespondTime(ObjectUtils.isEmpty(hashMap3.get("respondTime")) ? "" : hashMap3.get("respondTime").toString());
                    } else {
                        getLogBo.setRespondMessage("null");
                    }
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u8c03\u7528\u5e73\u53f0\u51fa\u53c2\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getReqOutFuture).whenComplete((result, e) -> countDownLatch.countDown());
            CompletionStage getErrorFuture = CompletableFuture.runAsync(() -> {
                if (StringUtils.isBlank((CharSequence)getLogBo.getErrorType())) {
                    RspPage errorData = this.getErrorTraceIdsWithParams(queryDataReqBO1);
                    if (!CollectionUtils.isEmpty((Collection)errorData.getRows())) {
                        HashMap hashMap3 = (HashMap)errorData.getRows().get(0);
                        getLogBo.setErrorType((String)hashMap3.get("errorType"));
                    } else {
                        getLogBo.setErrorType("\u8c03\u7528\u6210\u529f");
                    }
                }
            }, this.executorService).exceptionally(e -> {
                log.info("\u80fd\u529b\u5f02\u5e38\u7c7b\u578b\u67e5\u8be2\u5f02\u5e38\uff01, ex:{}\uff01", (Object)e.getMessage());
                log.error(e.getMessage(), e);
                return null;
            });
            ((CompletableFuture)getErrorFuture).whenComplete((result, e) -> countDownLatch.countDown());
            countDownLatch.await();
            if (StringUtils.isNotBlank((CharSequence)getLogBo.getRespondTime())) {
                getLogBo.setTotalTime(this.TimeDifference(getLogBo.getJoinTime(), getLogBo.getRespondTime()));
            }
            list.add(getLogBo);
        }
        RspPage rspPage2 = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), list, rspPage.getRecordsTotal());
        byte[] result2 = GzipUtil.compress(JSON.toJSONString((Object)rspPage2), "UTF-8");
        return RspBO.success((Object)result2);
    }

    @Override
    public RspBO copyLogData(QueryDataReqBO queryDataReqBO) throws Exception {
        RspBO rspBo = this.getLogData(queryDataReqBO);
        byte[] result = (byte[])rspBo.getData();
        String logString = GzipUtil.uncompressToString(result);
        JSONObject rspPage = JSON.parseObject((String)logString);
        JSONArray getLogBOList = rspPage.getJSONArray("rows");
        JSONObject copyJson = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)getLogBOList)) {
            JSONObject recieveHeaderInfo;
            JSONObject getLogBo = getLogBOList.getJSONObject(0);
            String joinTime = getLogBo.getString("joinTime");
            if (!ObjectUtils.isEmpty((Object)joinTime)) {
                copyJson.put("\u8bf7\u6c42\u65f6\u95f4", (Object)joinTime);
            }
            if (!ObjectUtils.isEmpty((Object)(recieveHeaderInfo = getLogBo.getJSONObject("recieveHeaderInfo"))) && !ObjectUtils.isEmpty((Object)recieveHeaderInfo.getJSONObject("esb-details"))) {
                JSONObject esbDetails = recieveHeaderInfo.getJSONObject("esb-details");
                copyJson.put("\u8bf7\u6c42\u5934", (Object)esbDetails.getString("headers"));
                copyJson.put("\u8bf7\u6c42\u5730\u5740", (Object)esbDetails.getString("url"));
                copyJson.put("\u8bf7\u6c42\u62a5\u6587", (Object)esbDetails.getString("body"));
            } else {
                copyJson.put("\u8bf7\u6c42\u5934", (Object)getLogBo.getString("sendHeaderInfo"));
                copyJson.put("\u8bf7\u6c42\u5730\u5740", (Object)getLogBo.getString("url"));
                copyJson.put("\u8bf7\u6c42\u62a5\u6587", (Object)getLogBo.getString("sendMessage"));
            }
            JSONObject recieveMessage = getLogBo.getJSONObject("recieveMessage");
            if (!ObjectUtils.isEmpty((Object)recieveMessage)) {
                copyJson.put("\u4f9b\u5e94\u5546-\u54cd\u5e94\u62a5\u6587", recieveMessage.getOrDefault((Object)"xml", (Object)recieveMessage.toJSONString()));
            } else {
                copyJson.put("\u4f9b\u5e94\u5546-\u54cd\u5e94\u62a5\u6587", (Object)"\u65e0\u54cd\u5e94\uff01");
            }
            copyJson.put("\u5185\u5e73\u53f0-\u54cd\u5e94\u62a5\u6587", (Object)getLogBo.getJSONObject("respondMessage"));
        }
        if (Boolean.TRUE.equals(queryDataReqBO.getGzip())) {
            byte[] copyJsonResult = GzipUtil.compress(JSON.toJSONString((Object)copyJson), "UTF-8");
            return RspBO.success((Object)copyJsonResult);
        }
        return RspBO.success((Object)copyJson);
    }

    @Override
    public RspBO calculatingTime(String traceId) throws Exception {
        CalculatTimeBO calculatTimeBO = new CalculatTimeBO();
        calculatTimeBO.setESB(traceId);
        QueryDataReqBO queryDataReqBO = new QueryDataReqBO();
        queryDataReqBO.setTraceId(traceId);
        RspPage rspPage = (RspPage)this.getReqIn(queryDataReqBO).getData();
        if (rspPage.getRows().size() == 0) {
            return RspBO.error((CodeMsg)new CodeMsg("9999", "\u4e0d\u5b58\u5728\uff01"), (Object)rspPage);
        }
        HashMap hashMap = (HashMap)rspPage.getRows().get(0);
        calculatTimeBO.setJoinTime(hashMap.get("joinTime").toString());
        rspPage = (RspPage)this.getReqOut(queryDataReqBO).getData();
        if (rspPage.getRows().size() == 0) {
            return RspBO.error((CodeMsg)new CodeMsg("9999", "\u843d\u5730\u4e0d\u6210\u529f\uff01\u6570\u636e\u65e0\u6548\uff01"), (Object)rspPage);
        }
        if (!ObjectUtils.isEmpty((Object)rspPage.getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            calculatTimeBO.setRespondTime(hashMap.get("respondTime").toString());
            calculatTimeBO.setTotalTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getRespondTime()));
        }
        if (!ObjectUtils.isEmpty((Object)(rspPage = (RspPage)this.getRspIn(queryDataReqBO).getData()).getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            calculatTimeBO.setSendTime(hashMap.get("sendTime").toString());
            calculatTimeBO.setReqTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getSendTime()));
        }
        if (!ObjectUtils.isEmpty((Object)(rspPage = (RspPage)this.getRspOut(queryDataReqBO).getData()).getRows())) {
            hashMap = (HashMap)rspPage.getRows().get(0);
            calculatTimeBO.setReceiveTime(hashMap.get("receiveTime").toString());
            calculatTimeBO.setRspTime(this.TimeDifference(calculatTimeBO.getSendTime(), calculatTimeBO.getReceiveTime()));
        }
        calculatTimeBO.setStatus("\u6709\u6548");
        return RspBO.success((Object)calculatTimeBO);
    }

    @Override
    public RspBO calculatingTimeList(QueryDataReqBO queryDataReqBO) throws Exception {
        ArrayList<CalculatTimeBO> calculatTimeBOS = new ArrayList<CalculatTimeBO>();
        HashMap<String, ArrayList> averageTime = new HashMap<String, ArrayList>();
        RspPage reqInRspPage = (RspPage)this.getReqIn(queryDataReqBO).getData();
        List reqInHashMapLIst = reqInRspPage.getRows();
        HashMap<String, Integer> invalidRecord = new HashMap<String, Integer>();
        ArrayList<String> traceIds = new ArrayList<String>();
        for (HashMap map : reqInHashMapLIst) {
            traceIds.add((String)map.get("traceId"));
        }
        Collections.sort(traceIds);
        while (traceIds.size() > 2) {
            traceIds.remove(1);
        }
        QueryDataReqBO dataReqBO = new QueryDataReqBO();
        dataReqBO.setPageNo(1);
        dataReqBO.setPageSize(queryDataReqBO.getPageSize() * 2);
        dataReqBO.setTraceIds(traceIds);
        RspPage reqOutRsp = (RspPage)this.getReqOut(dataReqBO).getData();
        List reqOutHashMapLIst = reqOutRsp.getRows();
        RspPage rspInRsp = (RspPage)this.getRspIn(dataReqBO).getData();
        List rspInHashMapLIst = rspInRsp.getRows();
        RspPage rspOutRsp = (RspPage)this.getRspOut(dataReqBO).getData();
        List rspOutHashMapLIst = rspOutRsp.getRows();
        for (Object map : reqInHashMapLIst) {
            CalculatTimeBO calculatTimeBO = new CalculatTimeBO();
            calculatTimeBO.setESB((String)((HashMap)map).get("traceId"));
            calculatTimeBO.setAbilityName((String)((HashMap)map).get("abilityName"));
            calculatTimeBO.setAbilityEname((String)((HashMap)map).get("abilityEname"));
            calculatTimeBO.setJoinTime((String)((HashMap)map).get("joinTime"));
            for (HashMap tmpMap : reqOutHashMapLIst) {
                if (!tmpMap.get("traceId").equals(calculatTimeBO.getESB())) continue;
                calculatTimeBO.setRespondTime((String)tmpMap.get("respondTime"));
            }
            for (HashMap tmpMap : rspInHashMapLIst) {
                if (!tmpMap.get("traceId").equals(calculatTimeBO.getESB())) continue;
                calculatTimeBO.setSendTime((String)tmpMap.get("sendTime"));
            }
            for (HashMap tmpMap : rspOutHashMapLIst) {
                if (!tmpMap.get("traceId").equals(calculatTimeBO.getESB())) continue;
                calculatTimeBO.setReceiveTime((String)tmpMap.get("receiveTime"));
            }
            invalidRecord.put(calculatTimeBO.getAbilityEname(), 0);
            if (calculatTimeBO.getRespondTime() == null || calculatTimeBO.getReceiveTime() == null || calculatTimeBO.getSendTime() == null) {
                calculatTimeBO.setStatus("\u65e0\u6548");
                if (invalidRecord.containsKey(calculatTimeBO.getAbilityEname())) {
                    invalidRecord.put(calculatTimeBO.getAbilityEname(), (Integer)invalidRecord.get(calculatTimeBO.getAbilityEname()) + 1);
                }
            } else {
                calculatTimeBO.setReqTime(this.TimeDifference(calculatTimeBO.getJoinTime(), calculatTimeBO.getRespondTime()));
                calculatTimeBO.setRspTime(this.TimeDifference(calculatTimeBO.getSendTime(), calculatTimeBO.getReceiveTime()));
                calculatTimeBO.setStatus("\u6709\u6548");
                ArrayList old = null;
                ArrayList<Long> list = new ArrayList<Long>();
                if (averageTime.containsKey(calculatTimeBO.getAbilityEname())) {
                    list.add(calculatTimeBO.getReqTime());
                    list.add(calculatTimeBO.getRspTime());
                    old = (ArrayList)averageTime.get(calculatTimeBO.getAbilityEname());
                    old.add(list);
                    averageTime.put(calculatTimeBO.getAbilityEname(), old);
                } else {
                    list.add(calculatTimeBO.getReqTime());
                    list.add(calculatTimeBO.getRspTime());
                    old = new ArrayList();
                    old.add(list);
                    averageTime.put(calculatTimeBO.getAbilityEname(), old);
                }
            }
            calculatTimeBOS.add(calculatTimeBO);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        for (Map.Entry entry : averageTime.entrySet()) {
            Long req = 0L;
            Long rsp = 0L;
            for (ArrayList list : (ArrayList)entry.getValue()) {
                req = req + (Long)list.get(0);
                rsp = rsp + (Long)list.get(1);
            }
            HashMap node = new HashMap();
            node.put("reqTime", req / (long)((ArrayList)entry.getValue()).size() + "");
            node.put("rspTime", rsp / (long)((ArrayList)entry.getValue()).size() + "");
            node.put("effective", (long)((ArrayList)entry.getValue()).size() + "");
            node.put("invalid", (long)((Integer)invalidRecord.get(entry.getKey())).intValue() + "");
            node.put("abilityEname", entry.getKey());
            result.add(node);
        }
        CaluclatTimeListBO caluclatTimeListBO = new CaluclatTimeListBO(queryDataReqBO.getPageSize(), queryDataReqBO.getPageNo(), calculatTimeBOS, reqInRspPage.getRecordsTotal());
        caluclatTimeListBO.setAvgTimeMap(result);
        return RspBO.success((Object)((Object)caluclatTimeListBO));
    }

    private Long TimeDifference(String start, String end) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date d1 = df.parse(start);
        Date d2 = df.parse(end);
        return d2.getTime() - d1.getTime();
    }

    @Override
    public RspBO getExceptionLogData(QueryDataReqBO queryDataReqBO) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.elasticSearchConfig.getExceptionIndexName()});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(0);
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            BoolQueryBuilder boolQueryBuilder = this.buildBoolQuery(this.elasticSearchConfig.getExceptionIndexName(), queryDataReqBO);
            TermsAggregationBuilder errorTypeGroup = (TermsAggregationBuilder)AggregationBuilders.terms((String)"errorTypeGroup").field("errorType.keyword");
            TermsAggregationBuilder abilityNameGroup = (TermsAggregationBuilder)AggregationBuilders.terms((String)"abilityNameGroup").field("abilityName.keyword");
            TermsAggregationBuilder abilityEnameGroup = ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"abilityEnameGroup").field("abilityEname.keyword")).subAggregation((AggregationBuilder)errorTypeGroup)).subAggregation((AggregationBuilder)abilityNameGroup)).size(Integer.MAX_VALUE);
            TermsAggregationBuilder joinTimeGroup = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"joinTimeGroup").field("joinTime.keyword")).order(BucketOrder.key((boolean)Boolean.FALSE));
            abilityEnameGroup.subAggregation((AggregationBuilder)joinTimeGroup);
            searchSourceBuilder.explain(Boolean.FALSE);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.aggregation((AggregationBuilder)abilityEnameGroup);
            searchRequest.source(searchSourceBuilder);
            List<Object> exceptionLogRspBoList = new LinkedList();
            try {
                SearchResponse searchResponse = this.client.search(searchRequest, this.options);
                Aggregations aggregations = searchResponse.getAggregations();
                Terms aggrAbilityException = (Terms)aggregations.get("abilityEnameGroup");
                List buckets = aggrAbilityException.getBuckets();
                for (Terms.Bucket bucket : buckets) {
                    Terms rspAbilityNameGroup = (Terms)bucket.getAggregations().get("abilityNameGroup");
                    List abilityNameBuckets = rspAbilityNameGroup.getBuckets();
                    Terms rspErrorTypeGroup = (Terms)bucket.getAggregations().get("errorTypeGroup");
                    List errorTypeBuckets = rspErrorTypeGroup.getBuckets();
                    long programErrorNum = 0L;
                    long landingReturnNum = 0L;
                    for (Terms.Bucket errorTypeBucket : errorTypeBuckets) {
                        if (errorTypeBucket.getKey().equals("\u7a0b\u5e8f\u62a5\u9519")) {
                            programErrorNum = errorTypeBucket.getDocCount();
                        }
                        if (!errorTypeBucket.getKey().equals("\u5f02\u5e38\u8fd4\u56de")) continue;
                        landingReturnNum = errorTypeBucket.getDocCount();
                    }
                    Terms rspJoinTimeGroup = (Terms)bucket.getAggregations().get("joinTimeGroup");
                    List joinTimeBuckets = rspJoinTimeGroup.getBuckets();
                    exceptionLogRspBoList.add(ExceptionLogRspBo.builder().abilityEname(bucket.getKey().toString()).abilityName(((Terms.Bucket)abilityNameBuckets.get(0)).getKey().toString()).programErrorNum(programErrorNum).landingReturnNum(landingReturnNum).earliestTime(((Terms.Bucket)joinTimeBuckets.get(joinTimeBuckets.size() - 1)).getKey().toString()).latestTime(((Terms.Bucket)joinTimeBuckets.get(0)).getKey().toString()).build());
                }
                if (queryDataReqBO.getErrorSortType().equals("\u65f6\u95f4\u964d\u5e8f")) {
                    exceptionLogRspBoList = exceptionLogRspBoList.stream().sorted(new Comparator<ExceptionLogRspBo>(){

                        @Override
                        public int compare(ExceptionLogRspBo o1, ExceptionLogRspBo o2) {
                            Date d1 = DateUtil.getStringToLocalDate((String)o1.getLatestTime());
                            Date d2 = DateUtil.getStringToLocalDate((String)o2.getLatestTime());
                            return d1.compareTo(d2);
                        }
                    }.reversed()).collect(Collectors.toList());
                } else if (queryDataReqBO.getErrorSortType().equals("\u6b21\u6570\u964d\u5e8f")) {
                    exceptionLogRspBoList = exceptionLogRspBoList.stream().sorted(new Comparator<ExceptionLogRspBo>(){

                        @Override
                        public int compare(ExceptionLogRspBo o1, ExceptionLogRspBo o2) {
                            Long num1 = o1.getProgramErrorNum() + o1.getLandingReturnNum();
                            Long num2 = o2.getProgramErrorNum() + o2.getLandingReturnNum();
                            return num1.compareTo(num2);
                        }
                    }.reversed()).collect(Collectors.toList());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int start = (queryDataReqBO.getPageNo() - 1) * queryDataReqBO.getPageSize();
            int end = Math.min(queryDataReqBO.getPageNo() * queryDataReqBO.getPageSize(), exceptionLogRspBoList.size());
            start = start > end ? (queryDataReqBO.getPageNo() - 2) * queryDataReqBO.getPageSize() : start;
            List logRspBoList = exceptionLogRspBoList.subList(start, end);
            RspPage rspPage = new RspPage(Integer.valueOf(queryDataReqBO.getPageSize()), Integer.valueOf(queryDataReqBO.getPageNo()), logRspBoList, Long.valueOf(Long.parseLong(String.valueOf(exceptionLogRspBoList.size()))));
            return RspBO.success((Object)rspPage);
        }
        catch (Exception e) {
            return RspBO.error((String)e.getMessage());
        }
    }
}

