/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.atp.base.util.GetFileContentUtil;
import com.ohaotian.logplatform.config.LogPlatformProperties;
import com.ohaotian.logplatform.model.req.AggsReqBO;
import com.ohaotian.logplatform.model.rsp.BarRspBO;
import com.ohaotian.logplatform.model.rsp.LineRspBO;
import com.ohaotian.logplatform.model.rsp.PieRspBO;
import com.ohaotian.logplatform.service.LogSearchService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.api.UserAPI;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LogSearchServiceImpl
implements LogSearchService {
    @Resource
    LogPlatformProperties logPlatformProperties;
    @Value(value="classpath:searchJson/invokeResultStats.json")
    private org.springframework.core.io.Resource invokeResultJson;
    @Value(value="classpath:searchJson/invokeCountStats.json")
    private org.springframework.core.io.Resource invokeCountJson;
    @Value(value="classpath:searchJson/invokeWeekStats.json")
    private org.springframework.core.io.Resource invokeWeekJson;
    @Value(value="classpath:searchJson/invokeDetail.json")
    private org.springframework.core.io.Resource invokeDetailJson;
    @Resource
    UserAPI userAPI;

    @Override
    public RspBO aggsSearch(AggsReqBO aggsReqBO) throws Exception {
        Long userId = this.userAPI.selectLoginUser();
        ValidBatchUtils.isNotEmpty((Object)aggsReqBO, (String[])new String[]{"json"});
        Map result = this.callLogPlatForm(aggsReqBO.getJson(), userId);
        return RspBO.success((Object)result);
    }

    @Override
    public RspBO invokeResutlStats(AggsReqBO aggsReqBO) throws Exception {
        ArrayList times = aggsReqBO.getTimes();
        if (times != null && (times.size() == 1 || times.size() > 2)) {
            throw new ZTBusinessException("\u65f6\u95f4\u6bb5\u53c2\u6570\u9519\u8bef");
        }
        if (times == null || times.size() == 0) {
            times = Lists.newArrayList();
            LocalDateTime today_start = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
            LocalDateTime today_end = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
            times.add(today_start);
            times.add(today_end);
        }
        String startTime = null;
        String endTime = null;
        if (times.get(0) == null) {
            LocalDateTime today_start = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
            startTime = today_start.toString();
        } else {
            startTime = ((LocalDateTime)times.get(0)).toString();
        }
        if (times.get(1) == null) {
            LocalDateTime today_end = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
            endTime = today_end.toString();
        } else {
            endTime = ((LocalDateTime)times.get(1)).toString();
        }
        String json = GetFileContentUtil.getFileContent((org.springframework.core.io.Resource)this.invokeResultJson);
        json = json.replace("#startTime#", startTime);
        json = json.replace("#endTime#", endTime);
        Long userId = this.userAPI.selectLoginUser();
        Map result = this.callLogPlatForm(json, userId);
        if (result == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map aggregations = (Map)result.get("aggregations");
        if (aggregations == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map invokeStats = (Map)aggregations.get("invoke_result_stats");
        if (invokeStats == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        List buckets = (List)invokeStats.get("buckets");
        if (buckets == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        List<PieRspBO.Model> data = buckets.stream().map(map -> {
            Double key = (Double)map.get("key");
            Double docCount = (Double)map.get("doc_count");
            PieRspBO.Model model = new PieRspBO.Model();
            if (key.equals(0.0)) {
                model.setName("\u5931\u8d25");
            } else {
                model.setName("\u6210\u529f");
            }
            model.setValue(docCount);
            return model;
        }).collect(Collectors.toList());
        if (data != null && data.size() == 1) {
            PieRspBO.Model model;
            if ("\u6210\u529f".equals(data.get(0).getName())) {
                model = new PieRspBO.Model();
                model.setName("\u5931\u8d25");
                model.setValue(0.0);
                data.add(model);
            } else {
                model = new PieRspBO.Model();
                model.setName("\u6210\u529f");
                model.setValue(0.0);
                data.add(model);
            }
        }
        PieRspBO rspBO = new PieRspBO();
        rspBO.setData(data);
        ArrayList mouduleData = Lists.newArrayList();
        mouduleData.add("\u6210\u529f");
        mouduleData.add("\u5931\u8d25");
        rspBO.setMouduleData(mouduleData);
        return RspBO.success((Object)rspBO);
    }

    @Override
    public RspBO invokeCountStats(AggsReqBO aggsReqBO) throws Exception {
        ArrayList times = aggsReqBO.getTimes();
        if (times != null && (times.size() == 1 || times.size() > 2)) {
            throw new ZTBusinessException("\u65f6\u95f4\u6bb5\u53c2\u6570\u9519\u8bef");
        }
        if (times == null || times.size() == 0) {
            times = Lists.newArrayList();
            LocalDateTime today_start = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
            LocalDateTime today_end = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
            times.add(today_start);
            times.add(today_end);
        }
        String startTime = null;
        String endTime = null;
        if (times.get(0) == null) {
            LocalDateTime today_start = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
            startTime = today_start.toString();
        } else {
            startTime = ((LocalDateTime)times.get(0)).toString();
        }
        if (times.get(1) == null) {
            LocalDateTime today_end = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
            endTime = today_end.toString();
        } else {
            endTime = ((LocalDateTime)times.get(1)).toString();
        }
        String json = GetFileContentUtil.getFileContent((org.springframework.core.io.Resource)this.invokeCountJson);
        json = json.replace("#startTime#", startTime);
        json = json.replace("#endTime#", endTime);
        Long userId = this.userAPI.selectLoginUser();
        Map result = this.callLogPlatForm(json, userId);
        if (result == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map aggregations = (Map)result.get("aggregations");
        if (aggregations == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map invokeStats = (Map)aggregations.get("invoke_count_stats");
        if (invokeStats == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        List buckets = (List)invokeStats.get("buckets");
        if (buckets == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        ArrayList mouduleData = Lists.newArrayList();
        List<BarRspBO.Model> data = buckets.stream().map(map -> {
            String key = (String)map.get("key");
            Double docCount = (Double)map.get("doc_count");
            BarRspBO.Model model = new BarRspBO.Model();
            model.setName(key);
            model.setValue(docCount);
            mouduleData.add(key);
            return model;
        }).collect(Collectors.toList());
        BarRspBO rspBO = new BarRspBO();
        rspBO.setData(data);
        rspBO.setMouduleData(mouduleData);
        return RspBO.success((Object)rspBO);
    }

    @Override
    public RspBO invokeCount7Days() throws Exception {
        Long userId;
        LocalDate endDate = LocalDate.now();
        LocalDate startDate = endDate.minusDays(6L);
        String json = GetFileContentUtil.getFileContent((org.springframework.core.io.Resource)this.invokeWeekJson);
        json = json.replace("#startTime#", startDate.toString());
        Map result = this.callLogPlatForm(json = json.replace("#endTime#", endDate.toString()), userId = this.userAPI.selectLoginUser());
        if (result == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map aggregations = (Map)result.get("aggregations");
        if (aggregations == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map invokeStats = (Map)aggregations.get("aggs");
        if (invokeStats == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        List buckets = (List)invokeStats.get("buckets");
        if (buckets == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        ArrayList dateData = Lists.newArrayList();
        ArrayList lineName = Lists.newArrayList();
        lineName.add("\u8fd17\u5929\u670d\u52a1\u8c03\u7528\u91cf");
        ArrayList data = Lists.newArrayList();
        LineRspBO.Model model = new LineRspBO.Model();
        model.setName("\u8c03\u7528\u91cf");
        model.setType("line");
        List<Double> dataList = buckets.stream().map(map -> {
            String keyAsString = (String)map.get("key_as_string");
            Double docCount = (Double)map.get("doc_count");
            dateData.add(keyAsString);
            return docCount;
        }).collect(Collectors.toList());
        model.setData(dataList);
        data.add(model);
        LineRspBO rspBO = new LineRspBO();
        rspBO.setDateData(dateData);
        rspBO.setLineName(lineName);
        rspBO.setData(data);
        return RspBO.success((Object)rspBO);
    }

    @Override
    public RspBO invokeDetail() throws Exception {
        Long userId;
        String json = GetFileContentUtil.getFileContent((org.springframework.core.io.Resource)this.invokeDetailJson);
        Map result = this.callLogPlatForm(json, userId = this.userAPI.selectLoginUser());
        if (result == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map aggregations = (Map)result.get("aggregations");
        if (aggregations == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        Map invokeStats = (Map)aggregations.get("top_tags");
        if (invokeStats == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        List buckets = (List)invokeStats.get("buckets");
        if (buckets == null) {
            throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
        }
        ArrayList datas = Lists.newArrayList();
        for (Map map : buckets) {
            Map topHits = (Map)map.get("top_hits");
            if (topHits == null) {
                throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
            }
            Map hits = (Map)topHits.get("hits");
            if (hits == null) {
                throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
            }
            HashMap data = Maps.newHashMap();
            List hitsSub = (List)hits.get("hits");
            Map requestIn = Maps.newHashMap();
            Map requestOut = Maps.newHashMap();
            Map respondIn = Maps.newHashMap();
            Map respondOut = Maps.newHashMap();
            for (Map hit : hitsSub) {
                Map source = (Map)hit.get("_source");
                String logType = (String)source.get("logType");
                if (logType == null) {
                    throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u8fd4\u56de\u9519\u8bef\uff01");
                }
                if ("RESPOND_OUT".equals(logType)) {
                    respondOut = source;
                    continue;
                }
                if ("REQUEST_OUT".equals(logType)) {
                    requestOut = source;
                    continue;
                }
                if ("RESPOND_IN".equals(logType)) {
                    respondIn = source;
                    continue;
                }
                if (!"REQUEST_IN".equals(logType)) continue;
                requestIn = source;
            }
            data.put("traceId", requestIn.get("traceId") != null ? (String)requestIn.get("traceId") : null);
            data.put("abilityName", String.valueOf(requestIn.get("abilityName")));
            data.put("abilityEname", String.valueOf(requestIn.get("abilityEname")));
            data.put("abilityVersion", String.valueOf(requestIn.get("abilityVersion")));
            data.put("requestIp", String.valueOf(requestIn.get("requestIp")));
            data.put("dropIp", String.valueOf(respondIn.get("dropIp")));
            data.put("dropPort", String.valueOf(respondIn.get("dropPort")));
            data.put("url", String.valueOf(respondIn.get("url")));
            data.put("successFlag", String.valueOf(requestOut.get("successFlag")));
            datas.add(data);
        }
        return RspBO.success((Object)datas);
    }

    private Map callLogPlatForm(String json, Long userId) throws Exception {
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", "application/json");
        headers.put("userId", userId.toString());
        HashMap params = Maps.newHashMap();
        params.put("indexName", this.logPlatformProperties.getIndexName());
        params.put("queryStr", json);
        String addr = this.logPlatformProperties.getAddr();
        String path = this.logPlatformProperties.getAggsPath();
        String resultJson = (String)HttpUtil.doPostJson((String)(addr + path), (String)GsonUtil.toJson((Object)params), (status, str) -> str, (Map)headers);
        RspBO rsp = (RspBO)GsonUtil.fromJson((String)resultJson, RspBO.class);
        if (rsp != null) {
            if (!"0".equals(rsp.getCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u65e5\u5fd7\u5e73\u53f0\u5931\u8d25\uff1a" + rsp.getMessage());
            }
            return (Map)rsp.getData();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        LocalDate end = LocalDate.now();
        LocalDate start = end.minusDays(7L);
        System.out.println(end);
        System.out.println(start);
    }
}

