/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.config;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class ElasticSearchConfig {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Value(value="${log.platform.es.addresses:127.0.0.1}")
    private String addresses;
    @Value(value="${log.platform.es.username:}")
    private String username;
    @Value(value="${log.platform.es.password:}")
    private String password;
    @Value(value="${log.platform.es.reqInIndexName:}")
    private String reqInIndexName;
    @Value(value="${log.platform.es.reqOutIndexName:}")
    private String reqOutIndexName;
    @Value(value="${log.platform.es.rspInIndexName:}")
    private String rspInIndexName;
    @Value(value="${log.platform.es.rspOutIndexName:}")
    private String rspOutIndexName;
    @Value(value="${log.platform.es.exceptionIndexName:}")
    private String exceptionIndexName;
    @Value(value="${log.platform.es.searchNum:-1}")
    private Integer indexSearchNum;
    @Value(value="${log.platform.es.encrypted:1}")
    private String isEncrypted;
    @Value(value="${log.platform.es.max.connect.numb:600}")
    private int maxConnectNumb;
    @Value(value="${log.platform.es.connect.timeout:30000}")
    private int connectTimeout;
    @Value(value="${log.platform.es.socket.timeout:30000}")
    private int socketTimeout;
    @Value(value="${log.platform.es.request.connect.timeout:6000}")
    private int requestConnectTimeout;
    public static final RequestOptions COMMON_OPTIONS;
    private static final String IS_ENCRYPTED = "1";

    @Bean
    public RestHighLevelClient client() {
        if (StringUtils.isEmpty((Object)this.addresses)) {
            return null;
        }
        ArrayList<String> nodeList = new ArrayList<String>(Arrays.asList(this.addresses.split(",")));
        log.info("es.config.addresses\uff1a{}", (Object)JSON.toJSONString(nodeList));
        HttpHost[] httpHosts = (HttpHost[])nodeList.stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        restClientBuilder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                super.onFailure(node);
                log.error(node.getHost().getHostName() + "===\u8282\u70b9\u5931\u8d25\u4e86");
            }
        });
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            if (IS_ENCRYPTED.equals(this.isEncrypted)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(this.maxConnectNumb).build());
            return httpAsyncClientBuilder;
        });
        restClientBuilder.setRequestConfigCallback(builder -> builder.setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.requestConnectTimeout));
        return new RestHighLevelClient(restClientBuilder);
    }

    public String getAddresses() {
        return this.addresses;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getReqInIndexName() {
        return this.reqInIndexName;
    }

    public String getReqOutIndexName() {
        return this.reqOutIndexName;
    }

    public String getRspInIndexName() {
        return this.rspInIndexName;
    }

    public String getRspOutIndexName() {
        return this.rspOutIndexName;
    }

    public String getExceptionIndexName() {
        return this.exceptionIndexName;
    }

    public Integer getIndexSearchNum() {
        return this.indexSearchNum;
    }

    public String getIsEncrypted() {
        return this.isEncrypted;
    }

    public int getMaxConnectNumb() {
        return this.maxConnectNumb;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getRequestConnectTimeout() {
        return this.requestConnectTimeout;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReqInIndexName(String reqInIndexName) {
        this.reqInIndexName = reqInIndexName;
    }

    public void setReqOutIndexName(String reqOutIndexName) {
        this.reqOutIndexName = reqOutIndexName;
    }

    public void setRspInIndexName(String rspInIndexName) {
        this.rspInIndexName = rspInIndexName;
    }

    public void setRspOutIndexName(String rspOutIndexName) {
        this.rspOutIndexName = rspOutIndexName;
    }

    public void setExceptionIndexName(String exceptionIndexName) {
        this.exceptionIndexName = exceptionIndexName;
    }

    public void setIndexSearchNum(Integer indexSearchNum) {
        this.indexSearchNum = indexSearchNum;
    }

    public void setIsEncrypted(String isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public void setMaxConnectNumb(int maxConnectNumb) {
        this.maxConnectNumb = maxConnectNumb;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setRequestConnectTimeout(int requestConnectTimeout) {
        this.requestConnectTimeout = requestConnectTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchConfig)) {
            return false;
        }
        ElasticSearchConfig other = (ElasticSearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$addresses = this.getAddresses();
        String other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !this$addresses.equals(other$addresses)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$reqInIndexName = this.getReqInIndexName();
        String other$reqInIndexName = other.getReqInIndexName();
        if (this$reqInIndexName == null ? other$reqInIndexName != null : !this$reqInIndexName.equals(other$reqInIndexName)) {
            return false;
        }
        String this$reqOutIndexName = this.getReqOutIndexName();
        String other$reqOutIndexName = other.getReqOutIndexName();
        if (this$reqOutIndexName == null ? other$reqOutIndexName != null : !this$reqOutIndexName.equals(other$reqOutIndexName)) {
            return false;
        }
        String this$rspInIndexName = this.getRspInIndexName();
        String other$rspInIndexName = other.getRspInIndexName();
        if (this$rspInIndexName == null ? other$rspInIndexName != null : !this$rspInIndexName.equals(other$rspInIndexName)) {
            return false;
        }
        String this$rspOutIndexName = this.getRspOutIndexName();
        String other$rspOutIndexName = other.getRspOutIndexName();
        if (this$rspOutIndexName == null ? other$rspOutIndexName != null : !this$rspOutIndexName.equals(other$rspOutIndexName)) {
            return false;
        }
        String this$exceptionIndexName = this.getExceptionIndexName();
        String other$exceptionIndexName = other.getExceptionIndexName();
        if (this$exceptionIndexName == null ? other$exceptionIndexName != null : !this$exceptionIndexName.equals(other$exceptionIndexName)) {
            return false;
        }
        Integer this$indexSearchNum = this.getIndexSearchNum();
        Integer other$indexSearchNum = other.getIndexSearchNum();
        if (this$indexSearchNum == null ? other$indexSearchNum != null : !((Object)this$indexSearchNum).equals(other$indexSearchNum)) {
            return false;
        }
        String this$isEncrypted = this.getIsEncrypted();
        String other$isEncrypted = other.getIsEncrypted();
        if (this$isEncrypted == null ? other$isEncrypted != null : !this$isEncrypted.equals(other$isEncrypted)) {
            return false;
        }
        if (this.getMaxConnectNumb() != other.getMaxConnectNumb()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        return this.getRequestConnectTimeout() == other.getRequestConnectTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : $addresses.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $reqInIndexName = this.getReqInIndexName();
        result = result * 59 + ($reqInIndexName == null ? 43 : $reqInIndexName.hashCode());
        String $reqOutIndexName = this.getReqOutIndexName();
        result = result * 59 + ($reqOutIndexName == null ? 43 : $reqOutIndexName.hashCode());
        String $rspInIndexName = this.getRspInIndexName();
        result = result * 59 + ($rspInIndexName == null ? 43 : $rspInIndexName.hashCode());
        String $rspOutIndexName = this.getRspOutIndexName();
        result = result * 59 + ($rspOutIndexName == null ? 43 : $rspOutIndexName.hashCode());
        String $exceptionIndexName = this.getExceptionIndexName();
        result = result * 59 + ($exceptionIndexName == null ? 43 : $exceptionIndexName.hashCode());
        Integer $indexSearchNum = this.getIndexSearchNum();
        result = result * 59 + ($indexSearchNum == null ? 43 : ((Object)$indexSearchNum).hashCode());
        String $isEncrypted = this.getIsEncrypted();
        result = result * 59 + ($isEncrypted == null ? 43 : $isEncrypted.hashCode());
        result = result * 59 + this.getMaxConnectNumb();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getSocketTimeout();
        result = result * 59 + this.getRequestConnectTimeout();
        return result;
    }

    public String toString() {
        return "ElasticSearchConfig(addresses=" + this.getAddresses() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", reqInIndexName=" + this.getReqInIndexName() + ", reqOutIndexName=" + this.getReqOutIndexName() + ", rspInIndexName=" + this.getRspInIndexName() + ", rspOutIndexName=" + this.getRspOutIndexName() + ", exceptionIndexName=" + this.getExceptionIndexName() + ", indexSearchNum=" + this.getIndexSearchNum() + ", isEncrypted=" + this.getIsEncrypted() + ", maxConnectNumb=" + this.getMaxConnectNumb() + ", connectTimeout=" + this.getConnectTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", requestConnectTimeout=" + this.getRequestConnectTimeout() + ")";
    }

    static {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        COMMON_OPTIONS = builder.build();
    }
}

