/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginMultiHpartyCheckMapper;
import com.ohaotian.plugin.mapper.MultiHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBO;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.SyncMultiHpartyCheckTokenBO;
import com.ohaotian.plugin.model.po.MultiHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginMultiHpartyCheckPO;
import com.ohaotian.plugin.util.HpartyCheckHttpUtil;
import com.ohaotian.plugin.util.MultiTokenUtil;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.redis.PubSubRedisBaseClient;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginDataRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MultiTokenRefreshLogic {
    private static final Logger log = LogManager.getLogger(MultiTokenRefreshLogic.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doLogic(MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper, AbilityPluginMultiHpartyCheckMapper abilityPluginMultiHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, PubSubRedisBaseClient pubSubRedisBaseClient, ConstantBaseVersion constantBaseVersion, PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO, MultiHpartyCheckTokenPO multiTokenPO, CacheClient cacheClient, PluginAPI pluginAPI) {
        PluginRspBO pluginRspBO = pluginAPI.getPluginInfo(pluginMultiHpartyCheckPO.getPluginId());
        String abilityNameAll = pluginRspBO.getPluginName() + "|" + pluginRspBO.getPluginEname();
        log.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####### multiTokenHPC ###### START", (Object)abilityNameAll);
        RefreshTokenReqBO refreshTokenReqBO = (RefreshTokenReqBO)BeanMapper.map((Object)multiTokenPO, RefreshTokenReqBO.class);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        refreshTokenReqBO.setTimestamp(now.format(ofPattern));
        refreshTokenReqBO.setGrantType("access_token");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", pluginMultiHpartyCheckPO.getTokenHeader());
        log.info("\u914d\u7f6e\u53c2\u6570\uff1a{}", (Object)GsonUtil.toJson((Object)pluginMultiHpartyCheckPO));
        log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)GsonUtil.toJson(headerMap));
        try {
            if (pluginMultiHpartyCheckPO.getCallProtocol() == 0) {
                log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1adoPostJson");
                log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)refreshTokenReqBO));
                HpartyCheckHttpUtil.doPostJson(multiTokenPO.getTokenPath().trim(), GsonUtil.toJson((Object)refreshTokenReqBO), (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        MultiTokenRefreshLogic.updateErrorToken(multiHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                    RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                    if (!refreshTokenRspBO.isSuccess()) {
                        log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        MultiTokenRefreshLogic.updateErrorToken(multiHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                    Long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = refreshTokenRspBO.getResult().getAccess_token();
                    multiTokenPO.setAccessToken(token);
                    MultiTokenRefreshLogic.updateToken(multiHpartyCheckTokenMapper, multiTokenPO, new Date(time.getTime() + duration));
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u63d2\u4ef6\u5206\u533a:{}", (Object)pluginMultiHpartyCheckPO.getRegionCode());
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)multiTokenPO));
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u503c:{}", (Object)token);
                    MultiTokenRefreshLogic.setRedis(abilityPluginMultiHpartyCheckMapper, abilityPluginDeployApi, cacheClient, constantBaseVersion, pluginMultiHpartyCheckPO, multiTokenPO);
                    return status;
                }, headerMap);
            } else {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("client_id", refreshTokenReqBO.getClientId());
                paramsMap.put("client_secret", refreshTokenReqBO.getClientSecret());
                paramsMap.put("username", refreshTokenReqBO.getUserName());
                paramsMap.put("grant_type", "access_token");
                paramsMap.put("timestamp", refreshTokenReqBO.getTimestamp());
                String password = MultiTokenUtil.getMD5Str(refreshTokenReqBO.getUserPassword());
                String sign = refreshTokenReqBO.getClientSecret() + refreshTokenReqBO.getTimestamp() + refreshTokenReqBO.getClientId() + refreshTokenReqBO.getUserName() + password + "access_token" + refreshTokenReqBO.getClientSecret();
                sign = MultiTokenUtil.getMD5Str(sign).toUpperCase();
                paramsMap.put("sign", sign);
                paramsMap.put("password", password);
                log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1adoPostForm");
                log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson(paramsMap));
                HttpUtil.doPost((String)multiTokenPO.getTokenPath().trim(), (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        MultiTokenRefreshLogic.updateErrorToken(multiHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                    RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                    if (!refreshTokenRspBO.isSuccess()) {
                        log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        MultiTokenRefreshLogic.updateErrorToken(multiHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                    Long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = refreshTokenRspBO.getResult().getAccess_token();
                    multiTokenPO.setAccessToken(token);
                    MultiTokenRefreshLogic.updateToken(multiHpartyCheckTokenMapper, multiTokenPO, new Date(time.getTime() + duration));
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u63d2\u4ef6\u5206\u533a:{}", (Object)pluginMultiHpartyCheckPO.getRegionCode());
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u8bb0\u5f55:{}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u503c:{}", (Object)token);
                    MultiTokenRefreshLogic.setRedis(abilityPluginMultiHpartyCheckMapper, abilityPluginDeployApi, cacheClient, constantBaseVersion, pluginMultiHpartyCheckPO, multiTokenPO);
                    return status;
                }, paramsMap);
            }
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5931\u8d25:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)multiTokenPO), (Object)e);
            MultiTokenRefreshLogic.updateErrorToken(multiHpartyCheckTokenMapper, multiTokenPO);
        }
        finally {
            log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
        }
    }

    private static void updateToken(MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper, MultiHpartyCheckTokenPO multiHpartyCheckTokenPO, Date expiresIn) {
        multiHpartyCheckTokenPO.setIsRunning(1);
        multiHpartyCheckTokenPO.setExpiresIn(expiresIn);
        multiHpartyCheckTokenPO.setUpdateTime(new Date());
        multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
    }

    private static void updateErrorToken(MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper, MultiHpartyCheckTokenPO multiHpartyCheckTokenPO) {
        multiHpartyCheckTokenPO.setIsRunning(2);
        multiHpartyCheckTokenPO.setUpdateTime(new Date());
        multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
    }

    public static void noticeForData(AbilityPluginMultiHpartyCheckMapper abilityPluginMultiHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, PubSubRedisBaseClient pubSubRedisBaseClient, PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO, MultiHpartyCheckTokenPO multiHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = abilityPluginMultiHpartyCheckMapper.queryAllDeployIds();
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            List clusterIds = abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).collect(Collectors.toList());
            PluginDataRspBO pluginDataRspBO = new PluginDataRspBO();
            pluginDataRspBO.setClusterIds(clusterIds);
            pluginDataRspBO.setPluginType("multiTokenHPC");
            pluginDataRspBO.setOpr("refresh");
            SyncMultiHpartyCheckTokenBO syncMultiHpartyCheckTokenBO = (SyncMultiHpartyCheckTokenBO)BeanMapper.map((Object)multiHpartyCheckTokenPO, SyncMultiHpartyCheckTokenBO.class);
            syncMultiHpartyCheckTokenBO.setClientId(pluginMultiHpartyCheckPO.getClientId());
            syncMultiHpartyCheckTokenBO.setRegionCode(pluginMultiHpartyCheckPO.getRegionCode());
            pluginDataRspBO.setData((Object)GsonUtil.toJson((Object)syncMultiHpartyCheckTokenBO));
            log.debug("\u96c6\u7fa4\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)pluginDataRspBO));
        }
    }

    public static void setRedis(AbilityPluginMultiHpartyCheckMapper abilityPluginMultiHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, CacheClient cacheClient, ConstantBaseVersion constantBaseVersion, PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO, MultiHpartyCheckTokenPO multiHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = abilityPluginMultiHpartyCheckMapper.queryAllDeployIds();
        SyncMultiHpartyCheckTokenBO syncMultiHpartyCheckTokenBO = (SyncMultiHpartyCheckTokenBO)BeanMapper.map((Object)multiHpartyCheckTokenPO, SyncMultiHpartyCheckTokenBO.class);
        syncMultiHpartyCheckTokenBO.setRegionCode(pluginMultiHpartyCheckPO.getRegionCode());
        syncMultiHpartyCheckTokenBO.setCallProtocol(pluginMultiHpartyCheckPO.getCallProtocol());
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).forEach(i -> {
                String key = constantBaseVersion.getATP() + "multiTokenHPC-" + i + "-" + multiHpartyCheckTokenPO.getPluginId() + "-" + multiHpartyCheckTokenPO.getOrgId() + "-" + pluginMultiHpartyCheckPO.getRegionCode();
                AbilityRedisTokenDataBo abilityRedisTokenDataBo = new AbilityRedisTokenDataBo();
                abilityRedisTokenDataBo.setPluginId(syncMultiHpartyCheckTokenBO.getPluginId().toString());
                abilityRedisTokenDataBo.setClientId(syncMultiHpartyCheckTokenBO.getClientId());
                abilityRedisTokenDataBo.setClientSecret("");
                abilityRedisTokenDataBo.setAccName("");
                abilityRedisTokenDataBo.setCallProtocol(syncMultiHpartyCheckTokenBO.getCallProtocol());
                abilityRedisTokenDataBo.setTokenPath("");
                abilityRedisTokenDataBo.setToken(syncMultiHpartyCheckTokenBO.getAccessToken());
                abilityRedisTokenDataBo.setRefreshInterval("");
                abilityRedisTokenDataBo.setTokenPosition(Integer.valueOf(0));
                abilityRedisTokenDataBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
                abilityRedisTokenDataBo.setHsn("");
                abilityRedisTokenDataBo.setOrgId(syncMultiHpartyCheckTokenBO.getOrgId());
                abilityRedisTokenDataBo.setCompanyName("");
                abilityRedisTokenDataBo.setRegionCode(syncMultiHpartyCheckTokenBO.getRegionCode());
                abilityRedisTokenDataBo.setAppends("");
                String value = GsonUtil.toJson((Object)abilityRedisTokenDataBo);
                cacheClient.set(key, (Object)value);
            });
        }
    }
}

