/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mapper.AbilityPluginMultiHpartyCheckMapper;
import com.ohaotian.plugin.mapper.MultiHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginMultiHpartyCheckMapper;
import com.ohaotian.plugin.model.po.MultiHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginMultiHpartyCheckPO;
import com.ohaotian.plugin.task.MultiTokenRefreshLogic;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class MultiTokenRefreshTask
implements Job {
    private static final Logger log = LogManager.getLogger(MultiTokenRefreshTask.class);
    @Resource
    MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper;
    @Resource
    PluginMultiHpartyCheckMapper pluginMultiHpartyCheckMapper;
    @Resource
    AbilityPluginMultiHpartyCheckMapper abilityPluginMultiHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginAPI;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    AdminClusterConfig adminClusterConfig;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (Boolean.FALSE.equals(this.adminClusterConfig.isMaster())) {
            return;
        }
        Long pluginId = (Long)jobExecutionContext.getMergedJobDataMap().get((Object)"parameterData");
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(pluginId);
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
        multiHpartyCheckTokenPO.setPluginId(pluginId);
        List<MultiHpartyCheckTokenPO> multiHpartyCheckTokenPOS = this.multiHpartyCheckTokenMapper.queryByCond(multiHpartyCheckTokenPO);
        ((Stream)multiHpartyCheckTokenPOS.stream().parallel()).filter(multi -> 1 == multi.getIsRunning() || 2 == multi.getIsRunning()).forEach(multiTokenPO -> MultiTokenRefreshLogic.doLogic(this.multiHpartyCheckTokenMapper, this.abilityPluginMultiHpartyCheckMapper, this.abilityPluginDeployApi, this.constantBaseVersion, pluginMultiHpartyCheckPO, multiTokenPO, this.cacheClient, this.pluginAPI));
    }
}

