/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mapper.AbilityPluginMultiHpartyCheckMapper;
import com.ohaotian.plugin.mapper.MultiHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginMultiHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.MultiHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTokenListTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTokenTaskReqBO;
import com.ohaotian.plugin.model.bo.rsp.ResponseVO;
import com.ohaotian.plugin.model.po.MultiHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginMultiHpartyCheckPO;
import com.ohaotian.plugin.service.MultiHpartyCheckService;
import com.ohaotian.plugin.task.MultiTokenRefreshLogic;
import com.ohaotian.plugin.task.MultiTokenRefreshTask;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.redis.PubSubRedisBaseClient;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.retry.handler.QuartzScheduleManager;
import com.ohaotian.portalcommon.util.SqlUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiHpartyCheckServiceImpl
implements MultiHpartyCheckService {
    private Logger log = LogManager.getLogger(MultiHpartyCheckServiceImpl.class);
    @Resource
    private PluginMultiHpartyCheckMapper pluginMultiHpartyCheckMapper;
    @Resource
    private MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper;
    @Resource
    private AbilityPluginMultiHpartyCheckMapper abilityPluginMultiHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    QuartzScheduleManager quartzScheduleManager;
    @Autowired
    PubSubRedisBaseClient pubSubRedisBaseClient;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginAPI;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    @Override
    public RspBO executeAll(PluginMultiHpartyCheckTaskReqBO pluginMultiHpartyCheckTaskReqBO) {
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(pluginMultiHpartyCheckTaskReqBO.getPluginId());
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
        multiHpartyCheckTokenPO.setPluginId(pluginMultiHpartyCheckTaskReqBO.getPluginId());
        List<MultiHpartyCheckTokenPO> multiHpartyCheckTokenPOS = this.multiHpartyCheckTokenMapper.queryByCond(multiHpartyCheckTokenPO);
        ((Stream)multiHpartyCheckTokenPOS.stream().parallel()).filter(multiHpartyCheckToken -> 1 == multiHpartyCheckToken.getIsRunning() || 2 == multiHpartyCheckToken.getIsRunning()).forEach(multiToken -> MultiTokenRefreshLogic.doLogic(this.multiHpartyCheckTokenMapper, this.abilityPluginMultiHpartyCheckMapper, this.abilityPluginDeployApi, this.constantBaseVersion, pluginMultiHpartyCheckPO, multiToken, this.cacheClient, this.pluginAPI));
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO execute(PluginMultiHpartyCheckTokenTaskReqBO pluginMultiHpartyCheckTokenTaskReqBO) {
        MultiHpartyCheckTokenPO jdToken = this.multiHpartyCheckTokenMapper.queryByHpartyCheckTokenId(pluginMultiHpartyCheckTokenTaskReqBO.getHpartyCheckTokenId());
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        MultiTokenRefreshLogic.doLogic(this.multiHpartyCheckTokenMapper, this.abilityPluginMultiHpartyCheckMapper, this.abilityPluginDeployApi, this.constantBaseVersion, pluginMultiHpartyCheckPO, jdToken, this.cacheClient, this.pluginAPI);
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO start(PluginMultiHpartyCheckTaskReqBO pluginMultiHpartyCheckTaskReqBO) {
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(pluginMultiHpartyCheckTaskReqBO.getPluginId());
        Boolean aBoolean = this.quartzScheduleManager.checkJob(pluginMultiHpartyCheckPO.getClientId());
        if (!aBoolean.booleanValue()) {
            pluginMultiHpartyCheckPO.setTaskSwitch(1);
            this.pluginMultiHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginMultiHpartyCheckPO);
            this.quartzScheduleManager.addJob(pluginMultiHpartyCheckPO.getClientId(), MultiTokenRefreshTask.class, pluginMultiHpartyCheckPO.getRefreshInterval(), (Object)pluginMultiHpartyCheckPO.getPluginId());
        } else {
            pluginMultiHpartyCheckPO.setTaskSwitch(1);
            this.pluginMultiHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginMultiHpartyCheckPO);
            this.quartzScheduleManager.removeJob(pluginMultiHpartyCheckPO.getClientId());
            this.quartzScheduleManager.addJob(pluginMultiHpartyCheckPO.getClientId(), MultiTokenRefreshTask.class, pluginMultiHpartyCheckPO.getRefreshInterval(), (Object)pluginMultiHpartyCheckPO.getPluginId());
        }
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO stop(PluginMultiHpartyCheckTaskReqBO pluginMultiHpartyCheckTaskReqBO) {
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(pluginMultiHpartyCheckTaskReqBO.getPluginId());
        Boolean aBoolean = this.quartzScheduleManager.checkJob(pluginMultiHpartyCheckPO.getClientId());
        if (aBoolean.booleanValue()) {
            pluginMultiHpartyCheckPO.setTaskSwitch(0);
            this.pluginMultiHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginMultiHpartyCheckPO);
            this.quartzScheduleManager.removeJob(pluginMultiHpartyCheckPO.getClientId());
        } else {
            pluginMultiHpartyCheckPO.setTaskSwitch(0);
            this.pluginMultiHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginMultiHpartyCheckPO);
        }
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO getPluginExtInfoList(PluginMultiHpartyCheckTokenReqBO pluginMultiHpartyCheckTokenReqBO) {
        StringBuilder order = new StringBuilder();
        if (pluginMultiHpartyCheckTokenReqBO.getSortName() != null) {
            order.append(pluginMultiHpartyCheckTokenReqBO.getSortName());
            if (pluginMultiHpartyCheckTokenReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(pluginMultiHpartyCheckTokenReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = PageMethod.startPage((int)pluginMultiHpartyCheckTokenReqBO.getPageNo(), (int)pluginMultiHpartyCheckTokenReqBO.getPageSize(), (String)order.toString());
        List<MultiHpartyCheckTokenPO> multiHpartyCheckTokenPOS = this.multiHpartyCheckTokenMapper.queryByPluginId(pluginMultiHpartyCheckTokenReqBO.getPluginId());
        RspPage rspPage = new RspPage(Integer.valueOf(pluginMultiHpartyCheckTokenReqBO.getPageSize()), Integer.valueOf(pluginMultiHpartyCheckTokenReqBO.getPageNo()), multiHpartyCheckTokenPOS, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        this.log.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @Override
    public ResponseVO put(MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        List<PluginMultiHpartyCheckPO> pluginMultiHpartyCheckPOS = this.pluginMultiHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginMultiHpartyCheckPOS.get(0).getPluginId();
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = this.multiHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, multiHpartyCheckTokenReqBO.getOrgId());
        if (multiHpartyCheckTokenPO != null) {
            multiHpartyCheckTokenPO.setUpdateTime(new Date());
            multiHpartyCheckTokenPO.setUserName(multiHpartyCheckTokenReqBO.getUsername());
            multiHpartyCheckTokenPO.setUserPassword(multiHpartyCheckTokenReqBO.getPassword());
            multiHpartyCheckTokenPO.setCompanyName(multiHpartyCheckTokenReqBO.getCompanyName());
            multiHpartyCheckTokenPO.setIsRunning(1);
            this.multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
        } else {
            multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
            multiHpartyCheckTokenPO.setPluginId(pluginId);
            multiHpartyCheckTokenPO.setCreateTime(new Date());
            multiHpartyCheckTokenPO.setUserName(multiHpartyCheckTokenReqBO.getUsername());
            multiHpartyCheckTokenPO.setUserPassword(multiHpartyCheckTokenReqBO.getPassword());
            multiHpartyCheckTokenPO.setOrgId(multiHpartyCheckTokenReqBO.getOrgId());
            multiHpartyCheckTokenPO.setCompanyName(multiHpartyCheckTokenReqBO.getCompanyName());
            multiHpartyCheckTokenPO.setIsRunning(1);
            this.multiHpartyCheckTokenMapper.insertSelective(multiHpartyCheckTokenPO);
        }
        MultiHpartyCheckTokenPO jdToken = this.multiHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, multiHpartyCheckTokenReqBO.getOrgId());
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        MultiTokenRefreshLogic.doLogic(this.multiHpartyCheckTokenMapper, this.abilityPluginMultiHpartyCheckMapper, this.abilityPluginDeployApi, this.constantBaseVersion, pluginMultiHpartyCheckPO, jdToken, this.cacheClient, this.pluginAPI);
        return ResponseVO.success();
    }

    @Override
    public ResponseVO modify(MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        List<PluginMultiHpartyCheckPO> pluginMultiHpartyCheckPOS = this.pluginMultiHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginMultiHpartyCheckPOS.get(0).getPluginId();
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = this.multiHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, multiHpartyCheckTokenReqBO.getOrgId());
        if (multiHpartyCheckTokenPO != null) {
            multiHpartyCheckTokenPO.setUpdateTime(new Date());
            multiHpartyCheckTokenPO.setUserName(multiHpartyCheckTokenReqBO.getUsername());
            multiHpartyCheckTokenPO.setUserPassword(multiHpartyCheckTokenReqBO.getPassword());
            multiHpartyCheckTokenPO.setCompanyName(multiHpartyCheckTokenReqBO.getCompanyName());
            this.multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
        } else {
            multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
            multiHpartyCheckTokenPO.setPluginId(pluginId);
            multiHpartyCheckTokenPO.setCreateTime(new Date());
            multiHpartyCheckTokenPO.setUserName(multiHpartyCheckTokenReqBO.getUsername());
            multiHpartyCheckTokenPO.setUserPassword(multiHpartyCheckTokenReqBO.getPassword());
            multiHpartyCheckTokenPO.setOrgId(multiHpartyCheckTokenReqBO.getOrgId());
            multiHpartyCheckTokenPO.setCompanyName(multiHpartyCheckTokenReqBO.getCompanyName());
            multiHpartyCheckTokenPO.setIsRunning(1);
            this.multiHpartyCheckTokenMapper.insertSelective(multiHpartyCheckTokenPO);
        }
        MultiHpartyCheckTokenPO jdToken = this.multiHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, multiHpartyCheckTokenReqBO.getOrgId());
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        MultiTokenRefreshLogic.doLogic(this.multiHpartyCheckTokenMapper, this.abilityPluginMultiHpartyCheckMapper, this.abilityPluginDeployApi, this.constantBaseVersion, pluginMultiHpartyCheckPO, jdToken, this.cacheClient, this.pluginAPI);
        return ResponseVO.success();
    }

    @Override
    public ResponseVO delete(MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        List<PluginMultiHpartyCheckPO> pluginMultiHpartyCheckPOS = this.pluginMultiHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginMultiHpartyCheckPOS.get(0).getPluginId();
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = this.multiHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, multiHpartyCheckTokenReqBO.getOrgId());
        if (multiHpartyCheckTokenPO != null) {
            multiHpartyCheckTokenPO.setUpdateTime(new Date());
            multiHpartyCheckTokenPO.setIsRunning(3);
            this.multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
        }
        return ResponseVO.success();
    }

    @Override
    public RspBO checkIn(PluginMultiHpartyCheckTokenListTaskReqBO pluginMultiHpartyCheckTokenListTaskReqBO) {
        pluginMultiHpartyCheckTokenListTaskReqBO.getHpartyCheckTokenIds().stream().forEach(k -> {
            MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
            multiHpartyCheckTokenPO.setIsRunning(1);
            multiHpartyCheckTokenPO.setHpartyCheckTokenId((Long)k);
            this.multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
        });
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO checkOut(PluginMultiHpartyCheckTokenListTaskReqBO pluginMultiHpartyCheckTokenListTaskReqBO) {
        pluginMultiHpartyCheckTokenListTaskReqBO.getHpartyCheckTokenIds().stream().forEach(k -> {
            MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
            multiHpartyCheckTokenPO.setIsRunning(0);
            multiHpartyCheckTokenPO.setHpartyCheckTokenId((Long)k);
            this.multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
        });
        return RspBO.success((Object)Boolean.TRUE);
    }
}

